"use strict";
cc._RF.push(module, '78ca3nM8PRIVZeqkuNrmj1L', 'CCMUtils');
// lib/CCMUtils.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var CCMUtils = /** @class */ (function () {
    function CCMUtils() {
        this.clickTime = {};
    }
    CCMUtils.getInstance = function () {
        if (!CCMUtils.instance) {
            CCMUtils.instance = new CCMUtils();
        }
        return CCMUtils.instance;
    };
    /**
     * @description 是否频繁点击
     * @param 判断重点的一个id，用于区分不同时机
     * @duration 少于该时长即认为发生了重复点击（毫秒）
     **/
    CCMUtils.prototype.isQuickClick = function (tag, duration) {
        if (!tag)
            tag = 'normal';
        if (!this.clickTime)
            this.clickTime = {};
        if (this.clickTime[tag] == undefined)
            this.clickTime[tag] = 0;
        var gapTime = new Date().getTime() - this.clickTime[tag];
        if (!duration)
            duration = 500;
        if (gapTime < duration) {
            console.log(CCMUtils.TAG, '请勿重复点击');
            return true;
        }
        this.clickTime[tag] = new Date().getTime();
        return false;
    };
    /**
     * @description 是否是平板的屏幕，仅根据屏幕高宽比判断，不适合用于确定是否真的平板
     */
    CCMUtils.prototype.isPadScreen = function () {
        var screenWidth = cc.view.getVisibleSize().width;
        var screenHeight = cc.view.getVisibleSize().height;
        var ratio = 1.69;
        return !(screenWidth > screenHeight && screenWidth >= ratio * screenHeight)
            && !(screenHeight > screenWidth && screenHeight >= ratio * screenWidth);
    };
    CCMUtils.prototype.isWxGame = function () {
        return cc.sys.platform === cc.sys.WECHAT_GAME;
    };
    CCMUtils.prototype.isAndroid = function () {
        return cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID;
    };
    CCMUtils.prototype.isIOS = function () {
        return cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS;
    };
    CCMUtils.prototype.isBrowser = function () {
        return cc.sys.isBrowser;
    };
    /**
     * @description 快速获取某个数据对象中深层 key 的值
     * @param src 数据对象
     * @param key 要获取值对应的 key，层级通过 # 分割
     */
    CCMUtils.prototype.key4property = function (src, key) {
        if (!src)
            return undefined;
        var keys = key.split('#');
        for (var i = 0, j = keys.length; i < j; i++) {
            src = src[keys[i]];
            if (typeof src == 'object' && src != null)
                continue;
            if (i < j - 1)
                return undefined;
        }
        return src;
    };
    CCMUtils.TAG = 'CCMSceneManager';
    return CCMUtils;
}());
exports.default = CCMUtils;

cc._RF.pop();