
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMlib/md5.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}(function (process,global){
"use strict";
cc._RF.push(module, 'f235fQ4+ixNk7QK8/3d0vC4', 'md5');
// lib/CCMlib/md5.js

"use strict";

/**
 * [js-md5]{@link https://github.com/emn178/js-md5}
 *
 * @namespace md5
 * @version 0.7.3
 * @author Chen, Yi-Cyuan [emn178@gmail.com]
 * @copyright Chen, Yi-Cyuan 2014-2017
 * @license MIT
 */

/* eslint-disable */
(function () {
  'use strict';

  var ERROR = 'input is invalid type';
  var WINDOW = typeof window === 'object';
  var root = WINDOW ? window : {};

  if (root.JS_MD5_NO_WINDOW) {
    WINDOW = false;
  }

  var WEB_WORKER = !WINDOW && typeof self === 'object';
  var NODE_JS = !root.JS_MD5_NO_NODE_JS && process && typeof process === 'object' && process.versions && process.versions.node;

  if (NODE_JS) {
    root = global;
  } else if (WEB_WORKER) {
    root = self;
  }

  var COMMON_JS = !root.JS_MD5_NO_COMMON_JS && typeof module === 'object' && module.exports;
  var AMD = typeof define === 'function' && define.amd;
  var ARRAY_BUFFER = !root.JS_MD5_NO_ARRAY_BUFFER && typeof ArrayBuffer !== 'undefined';
  var HEX_CHARS = '0123456789abcdef'.split('');
  var EXTRA = [128, 32768, 8388608, -2147483648];
  var SHIFT = [0, 8, 16, 24];
  var OUTPUT_TYPES = ['hex', 'array', 'digest', 'buffer', 'arrayBuffer', 'base64'];
  var BASE64_ENCODE_CHAR = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');
  var blocks = [],
      buffer8;

  if (ARRAY_BUFFER) {
    var buffer = new ArrayBuffer(68);
    buffer8 = new Uint8Array(buffer);
    blocks = new Uint32Array(buffer);
  }

  if (root.JS_MD5_NO_NODE_JS || !Array.isArray) {
    Array.isArray = function (obj) {
      return Object.prototype.toString.call(obj) === '[object Array]';
    };
  }

  if (ARRAY_BUFFER && (root.JS_MD5_NO_ARRAY_BUFFER_IS_VIEW || !ArrayBuffer.isView)) {
    ArrayBuffer.isView = function (obj) {
      return typeof obj === 'object' && obj.buffer && obj.buffer.constructor === ArrayBuffer;
    };
  }
  /**
   * @method hex
   * @memberof md5
   * @description Output hash as hex string
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {String} Hex string
   * @example
   * md5.hex('The quick brown fox jumps over the lazy dog');
   * // equal to
   * md5('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method digest
   * @memberof md5
   * @description Output hash as bytes array
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Array} Bytes array
   * @example
   * md5.digest('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method array
   * @memberof md5
   * @description Output hash as bytes array
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Array} Bytes array
   * @example
   * md5.array('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method arrayBuffer
   * @memberof md5
   * @description Output hash as ArrayBuffer
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {ArrayBuffer} ArrayBuffer
   * @example
   * md5.arrayBuffer('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method buffer
   * @deprecated This maybe confuse with Buffer in node.js. Please use arrayBuffer instead.
   * @memberof md5
   * @description Output hash as ArrayBuffer
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {ArrayBuffer} ArrayBuffer
   * @example
   * md5.buffer('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method base64
   * @memberof md5
   * @description Output hash as base64 string
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {String} base64 string
   * @example
   * md5.base64('The quick brown fox jumps over the lazy dog');
   */


  var createOutputMethod = function createOutputMethod(outputType) {
    return function (message) {
      return new Md5(true).update(message)[outputType]();
    };
  };
  /**
   * @method create
   * @memberof md5
   * @description Create Md5 object
   * @returns {Md5} Md5 object.
   * @example
   * var hash = md5.create();
   */

  /**
   * @method update
   * @memberof md5
   * @description Create and update Md5 object
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Md5} Md5 object.
   * @example
   * var hash = md5.update('The quick brown fox jumps over the lazy dog');
   * // equal to
   * var hash = md5.create();
   * hash.update('The quick brown fox jumps over the lazy dog');
   */


  var createMethod = function createMethod() {
    var method = createOutputMethod('hex');

    if (NODE_JS) {
      method = nodeWrap(method);
    }

    method.create = function () {
      return new Md5();
    };

    method.update = function (message) {
      return method.create().update(message);
    };

    for (var i = 0; i < OUTPUT_TYPES.length; ++i) {
      var type = OUTPUT_TYPES[i];
      method[type] = createOutputMethod(type);
    }

    return method;
  };

  var nodeWrap = function nodeWrap(method) {
    var crypto = eval("require('crypto')");
    var Buffer = eval("require('buffer').Buffer");

    var nodeMethod = function nodeMethod(message) {
      if (typeof message === 'string') {
        return crypto.createHash('md5').update(message, 'utf8').digest('hex');
      } else {
        if (message === null || message === undefined) {
          throw ERROR;
        } else if (message.constructor === ArrayBuffer) {
          message = new Uint8Array(message);
        }
      }

      if (Array.isArray(message) || ArrayBuffer.isView(message) || message.constructor === Buffer) {
        return crypto.createHash('md5').update(new Buffer(message)).digest('hex');
      } else {
        return method(message);
      }
    };

    return nodeMethod;
  };
  /**
   * Md5 class
   * @class Md5
   * @description This is internal class.
   * @see {@link md5.create}
   */


  function Md5(sharedMemory) {
    if (sharedMemory) {
      blocks[0] = blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
      this.blocks = blocks;
      this.buffer8 = buffer8;
    } else {
      if (ARRAY_BUFFER) {
        var buffer = new ArrayBuffer(68);
        this.buffer8 = new Uint8Array(buffer);
        this.blocks = new Uint32Array(buffer);
      } else {
        this.blocks = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
      }
    }

    this.h0 = this.h1 = this.h2 = this.h3 = this.start = this.bytes = this.hBytes = 0;
    this.finalized = this.hashed = false;
    this.first = true;
  }
  /**
   * @method update
   * @memberof Md5
   * @instance
   * @description Update hash
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Md5} Md5 object.
   * @see {@link md5.update}
   */


  Md5.prototype.update = function (message) {
    if (this.finalized) {
      return;
    }

    var notString,
        type = typeof message;

    if (type !== 'string') {
      if (type === 'object') {
        if (message === null) {
          throw ERROR;
        } else if (ARRAY_BUFFER && message.constructor === ArrayBuffer) {
          message = new Uint8Array(message);
        } else if (!Array.isArray(message)) {
          if (!ARRAY_BUFFER || !ArrayBuffer.isView(message)) {
            throw ERROR;
          }
        }
      } else {
        throw ERROR;
      }

      notString = true;
    }

    var code,
        index = 0,
        i,
        length = message.length,
        blocks = this.blocks;
    var buffer8 = this.buffer8;

    while (index < length) {
      if (this.hashed) {
        this.hashed = false;
        blocks[0] = blocks[16];
        blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
      }

      if (notString) {
        if (ARRAY_BUFFER) {
          for (i = this.start; index < length && i < 64; ++index) {
            buffer8[i++] = message[index];
          }
        } else {
          for (i = this.start; index < length && i < 64; ++index) {
            blocks[i >> 2] |= message[index] << SHIFT[i++ & 3];
          }
        }
      } else {
        if (ARRAY_BUFFER) {
          for (i = this.start; index < length && i < 64; ++index) {
            code = message.charCodeAt(index);

            if (code < 0x80) {
              buffer8[i++] = code;
            } else if (code < 0x800) {
              buffer8[i++] = 0xc0 | code >> 6;
              buffer8[i++] = 0x80 | code & 0x3f;
            } else if (code < 0xd800 || code >= 0xe000) {
              buffer8[i++] = 0xe0 | code >> 12;
              buffer8[i++] = 0x80 | code >> 6 & 0x3f;
              buffer8[i++] = 0x80 | code & 0x3f;
            } else {
              code = 0x10000 + ((code & 0x3ff) << 10 | message.charCodeAt(++index) & 0x3ff);
              buffer8[i++] = 0xf0 | code >> 18;
              buffer8[i++] = 0x80 | code >> 12 & 0x3f;
              buffer8[i++] = 0x80 | code >> 6 & 0x3f;
              buffer8[i++] = 0x80 | code & 0x3f;
            }
          }
        } else {
          for (i = this.start; index < length && i < 64; ++index) {
            code = message.charCodeAt(index);

            if (code < 0x80) {
              blocks[i >> 2] |= code << SHIFT[i++ & 3];
            } else if (code < 0x800) {
              blocks[i >> 2] |= (0xc0 | code >> 6) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code & 0x3f) << SHIFT[i++ & 3];
            } else if (code < 0xd800 || code >= 0xe000) {
              blocks[i >> 2] |= (0xe0 | code >> 12) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code >> 6 & 0x3f) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code & 0x3f) << SHIFT[i++ & 3];
            } else {
              code = 0x10000 + ((code & 0x3ff) << 10 | message.charCodeAt(++index) & 0x3ff);
              blocks[i >> 2] |= (0xf0 | code >> 18) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code >> 12 & 0x3f) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code >> 6 & 0x3f) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code & 0x3f) << SHIFT[i++ & 3];
            }
          }
        }
      }

      this.lastByteIndex = i;
      this.bytes += i - this.start;

      if (i >= 64) {
        this.start = i - 64;
        this.hash();
        this.hashed = true;
      } else {
        this.start = i;
      }
    }

    if (this.bytes > 4294967295) {
      this.hBytes += this.bytes / 4294967296 << 0;
      this.bytes = this.bytes % 4294967296;
    }

    return this;
  };

  Md5.prototype.finalize = function () {
    if (this.finalized) {
      return;
    }

    this.finalized = true;
    var blocks = this.blocks,
        i = this.lastByteIndex;
    blocks[i >> 2] |= EXTRA[i & 3];

    if (i >= 56) {
      if (!this.hashed) {
        this.hash();
      }

      blocks[0] = blocks[16];
      blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
    }

    blocks[14] = this.bytes << 3;
    blocks[15] = this.hBytes << 3 | this.bytes >>> 29;
    this.hash();
  };

  Md5.prototype.hash = function () {
    var a,
        b,
        c,
        d,
        bc,
        da,
        blocks = this.blocks;

    if (this.first) {
      a = blocks[0] - 680876937;
      a = (a << 7 | a >>> 25) - 271733879 << 0;
      d = (-1732584194 ^ a & 2004318071) + blocks[1] - 117830708;
      d = (d << 12 | d >>> 20) + a << 0;
      c = (-271733879 ^ d & (a ^ -271733879)) + blocks[2] - 1126478375;
      c = (c << 17 | c >>> 15) + d << 0;
      b = (a ^ c & (d ^ a)) + blocks[3] - 1316259209;
      b = (b << 22 | b >>> 10) + c << 0;
    } else {
      a = this.h0;
      b = this.h1;
      c = this.h2;
      d = this.h3;
      a += (d ^ b & (c ^ d)) + blocks[0] - 680876936;
      a = (a << 7 | a >>> 25) + b << 0;
      d += (c ^ a & (b ^ c)) + blocks[1] - 389564586;
      d = (d << 12 | d >>> 20) + a << 0;
      c += (b ^ d & (a ^ b)) + blocks[2] + 606105819;
      c = (c << 17 | c >>> 15) + d << 0;
      b += (a ^ c & (d ^ a)) + blocks[3] - 1044525330;
      b = (b << 22 | b >>> 10) + c << 0;
    }

    a += (d ^ b & (c ^ d)) + blocks[4] - 176418897;
    a = (a << 7 | a >>> 25) + b << 0;
    d += (c ^ a & (b ^ c)) + blocks[5] + 1200080426;
    d = (d << 12 | d >>> 20) + a << 0;
    c += (b ^ d & (a ^ b)) + blocks[6] - 1473231341;
    c = (c << 17 | c >>> 15) + d << 0;
    b += (a ^ c & (d ^ a)) + blocks[7] - 45705983;
    b = (b << 22 | b >>> 10) + c << 0;
    a += (d ^ b & (c ^ d)) + blocks[8] + 1770035416;
    a = (a << 7 | a >>> 25) + b << 0;
    d += (c ^ a & (b ^ c)) + blocks[9] - 1958414417;
    d = (d << 12 | d >>> 20) + a << 0;
    c += (b ^ d & (a ^ b)) + blocks[10] - 42063;
    c = (c << 17 | c >>> 15) + d << 0;
    b += (a ^ c & (d ^ a)) + blocks[11] - 1990404162;
    b = (b << 22 | b >>> 10) + c << 0;
    a += (d ^ b & (c ^ d)) + blocks[12] + 1804603682;
    a = (a << 7 | a >>> 25) + b << 0;
    d += (c ^ a & (b ^ c)) + blocks[13] - 40341101;
    d = (d << 12 | d >>> 20) + a << 0;
    c += (b ^ d & (a ^ b)) + blocks[14] - 1502002290;
    c = (c << 17 | c >>> 15) + d << 0;
    b += (a ^ c & (d ^ a)) + blocks[15] + 1236535329;
    b = (b << 22 | b >>> 10) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[1] - 165796510;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[6] - 1069501632;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[11] + 643717713;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[0] - 373897302;
    b = (b << 20 | b >>> 12) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[5] - 701558691;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[10] + 38016083;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[15] - 660478335;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[4] - 405537848;
    b = (b << 20 | b >>> 12) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[9] + 568446438;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[14] - 1019803690;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[3] - 187363961;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[8] + 1163531501;
    b = (b << 20 | b >>> 12) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[13] - 1444681467;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[2] - 51403784;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[7] + 1735328473;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[12] - 1926607734;
    b = (b << 20 | b >>> 12) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[5] - 378558;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[8] - 2022574463;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[11] + 1839030562;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[14] - 35309556;
    b = (b << 23 | b >>> 9) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[1] - 1530992060;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[4] + 1272893353;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[7] - 155497632;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[10] - 1094730640;
    b = (b << 23 | b >>> 9) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[13] + 681279174;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[0] - 358537222;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[3] - 722521979;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[6] + 76029189;
    b = (b << 23 | b >>> 9) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[9] - 640364487;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[12] - 421815835;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[15] + 530742520;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[2] - 995338651;
    b = (b << 23 | b >>> 9) + c << 0;
    a += (c ^ (b | ~d)) + blocks[0] - 198630844;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[7] + 1126891415;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[14] - 1416354905;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[5] - 57434055;
    b = (b << 21 | b >>> 11) + c << 0;
    a += (c ^ (b | ~d)) + blocks[12] + 1700485571;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[3] - 1894986606;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[10] - 1051523;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[1] - 2054922799;
    b = (b << 21 | b >>> 11) + c << 0;
    a += (c ^ (b | ~d)) + blocks[8] + 1873313359;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[15] - 30611744;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[6] - 1560198380;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[13] + 1309151649;
    b = (b << 21 | b >>> 11) + c << 0;
    a += (c ^ (b | ~d)) + blocks[4] - 145523070;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[11] - 1120210379;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[2] + 718787259;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[9] - 343485551;
    b = (b << 21 | b >>> 11) + c << 0;

    if (this.first) {
      this.h0 = a + 1732584193 << 0;
      this.h1 = b - 271733879 << 0;
      this.h2 = c - 1732584194 << 0;
      this.h3 = d + 271733878 << 0;
      this.first = false;
    } else {
      this.h0 = this.h0 + a << 0;
      this.h1 = this.h1 + b << 0;
      this.h2 = this.h2 + c << 0;
      this.h3 = this.h3 + d << 0;
    }
  };
  /**
   * @method hex
   * @memberof Md5
   * @instance
   * @description Output hash as hex string
   * @returns {String} Hex string
   * @see {@link md5.hex}
   * @example
   * hash.hex();
   */


  Md5.prototype.hex = function () {
    this.finalize();
    var h0 = this.h0,
        h1 = this.h1,
        h2 = this.h2,
        h3 = this.h3;
    return HEX_CHARS[h0 >> 4 & 0x0F] + HEX_CHARS[h0 & 0x0F] + HEX_CHARS[h0 >> 12 & 0x0F] + HEX_CHARS[h0 >> 8 & 0x0F] + HEX_CHARS[h0 >> 20 & 0x0F] + HEX_CHARS[h0 >> 16 & 0x0F] + HEX_CHARS[h0 >> 28 & 0x0F] + HEX_CHARS[h0 >> 24 & 0x0F] + HEX_CHARS[h1 >> 4 & 0x0F] + HEX_CHARS[h1 & 0x0F] + HEX_CHARS[h1 >> 12 & 0x0F] + HEX_CHARS[h1 >> 8 & 0x0F] + HEX_CHARS[h1 >> 20 & 0x0F] + HEX_CHARS[h1 >> 16 & 0x0F] + HEX_CHARS[h1 >> 28 & 0x0F] + HEX_CHARS[h1 >> 24 & 0x0F] + HEX_CHARS[h2 >> 4 & 0x0F] + HEX_CHARS[h2 & 0x0F] + HEX_CHARS[h2 >> 12 & 0x0F] + HEX_CHARS[h2 >> 8 & 0x0F] + HEX_CHARS[h2 >> 20 & 0x0F] + HEX_CHARS[h2 >> 16 & 0x0F] + HEX_CHARS[h2 >> 28 & 0x0F] + HEX_CHARS[h2 >> 24 & 0x0F] + HEX_CHARS[h3 >> 4 & 0x0F] + HEX_CHARS[h3 & 0x0F] + HEX_CHARS[h3 >> 12 & 0x0F] + HEX_CHARS[h3 >> 8 & 0x0F] + HEX_CHARS[h3 >> 20 & 0x0F] + HEX_CHARS[h3 >> 16 & 0x0F] + HEX_CHARS[h3 >> 28 & 0x0F] + HEX_CHARS[h3 >> 24 & 0x0F];
  };
  /**
   * @method toString
   * @memberof Md5
   * @instance
   * @description Output hash as hex string
   * @returns {String} Hex string
   * @see {@link md5.hex}
   * @example
   * hash.toString();
   */


  Md5.prototype.toString = Md5.prototype.hex;
  /**
   * @method digest
   * @memberof Md5
   * @instance
   * @description Output hash as bytes array
   * @returns {Array} Bytes array
   * @see {@link md5.digest}
   * @example
   * hash.digest();
   */

  Md5.prototype.digest = function () {
    this.finalize();
    var h0 = this.h0,
        h1 = this.h1,
        h2 = this.h2,
        h3 = this.h3;
    return [h0 & 0xFF, h0 >> 8 & 0xFF, h0 >> 16 & 0xFF, h0 >> 24 & 0xFF, h1 & 0xFF, h1 >> 8 & 0xFF, h1 >> 16 & 0xFF, h1 >> 24 & 0xFF, h2 & 0xFF, h2 >> 8 & 0xFF, h2 >> 16 & 0xFF, h2 >> 24 & 0xFF, h3 & 0xFF, h3 >> 8 & 0xFF, h3 >> 16 & 0xFF, h3 >> 24 & 0xFF];
  };
  /**
   * @method array
   * @memberof Md5
   * @instance
   * @description Output hash as bytes array
   * @returns {Array} Bytes array
   * @see {@link md5.array}
   * @example
   * hash.array();
   */


  Md5.prototype.array = Md5.prototype.digest;
  /**
   * @method arrayBuffer
   * @memberof Md5
   * @instance
   * @description Output hash as ArrayBuffer
   * @returns {ArrayBuffer} ArrayBuffer
   * @see {@link md5.arrayBuffer}
   * @example
   * hash.arrayBuffer();
   */

  Md5.prototype.arrayBuffer = function () {
    this.finalize();
    var buffer = new ArrayBuffer(16);
    var blocks = new Uint32Array(buffer);
    blocks[0] = this.h0;
    blocks[1] = this.h1;
    blocks[2] = this.h2;
    blocks[3] = this.h3;
    return buffer;
  };
  /**
   * @method buffer
   * @deprecated This maybe confuse with Buffer in node.js. Please use arrayBuffer instead.
   * @memberof Md5
   * @instance
   * @description Output hash as ArrayBuffer
   * @returns {ArrayBuffer} ArrayBuffer
   * @see {@link md5.buffer}
   * @example
   * hash.buffer();
   */


  Md5.prototype.buffer = Md5.prototype.arrayBuffer;
  /**
   * @method base64
   * @memberof Md5
   * @instance
   * @description Output hash as base64 string
   * @returns {String} base64 string
   * @see {@link md5.base64}
   * @example
   * hash.base64();
   */

  Md5.prototype.base64 = function () {
    var v1,
        v2,
        v3,
        base64Str = '',
        bytes = this.array();

    for (var i = 0; i < 15;) {
      v1 = bytes[i++];
      v2 = bytes[i++];
      v3 = bytes[i++];
      base64Str += BASE64_ENCODE_CHAR[v1 >>> 2] + BASE64_ENCODE_CHAR[(v1 << 4 | v2 >>> 4) & 63] + BASE64_ENCODE_CHAR[(v2 << 2 | v3 >>> 6) & 63] + BASE64_ENCODE_CHAR[v3 & 63];
    }

    v1 = bytes[i];
    base64Str += BASE64_ENCODE_CHAR[v1 >>> 2] + BASE64_ENCODE_CHAR[v1 << 4 & 63] + '==';
    return base64Str;
  };

  var exports = createMethod();

  if (COMMON_JS) {
    module.exports = exports;
  } else {
    /**
     * @method md5
     * @description Md5 hash function, export to global in browsers.
     * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
     * @returns {String} md5 hashes
     * @example
     * md5(''); // d41d8cd98f00b204e9800998ecf8427e
     * md5('The quick brown fox jumps over the lazy dog'); // 9e107d9d372bb6826bd81d3542a419d6
     * md5('The quick brown fox jumps over the lazy dog.'); // e4d909c290d0fb1ca068ffaddf22cbd0
     *
     * // It also supports UTF-8 encoding
     * md5('中文'); // a7bac2239fcdcb3a067903d8077c4a07
     *
     * // It also supports byte `Array`, `Uint8Array`, `ArrayBuffer`
     * md5([]); // d41d8cd98f00b204e9800998ecf8427e
     * md5(new Uint8Array([])); // d41d8cd98f00b204e9800998ecf8427e
     */
    root.md5 = exports;

    if (AMD) {
      define(function () {
        return exports;
      });
    }
  }
})();

cc._RF.pop();

}).call(this,require("../../../../../../../../../../../../Applications/CocosCreator/Creator/2.4.11/CocosCreator.app/Contents/Resources/app.asar/node_modules/process/browser.js"),typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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