
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMVideo/CCMVideo.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5bcb2O7tHNFYKddKtn7YOjW', 'CCMVideo');
// lib/CCMVideo/CCMVideo.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CCMVideo = exports.EventType = void 0;
var CCMVideoAssembler_1 = require("./CCMVideoAssembler");
var EventType;
(function (EventType) {
    EventType[EventType["PREPARING"] = 1] = "PREPARING";
    EventType[EventType["LOADED"] = 2] = "LOADED";
    EventType[EventType["READY"] = 3] = "READY";
    EventType[EventType["COMPLETED"] = 4] = "COMPLETED";
    EventType[EventType["ERROR"] = 5] = "ERROR";
    EventType[EventType["PLAYING"] = 6] = "PLAYING";
    EventType[EventType["PAUSED"] = 7] = "PAUSED";
    EventType[EventType["STOPPED"] = 8] = "STOPPED";
    EventType[EventType["BUFFER_START"] = 9] = "BUFFER_START";
    EventType[EventType["BUFFER_UPDATE"] = 10] = "BUFFER_UPDATE";
    EventType[EventType["BUFFER_END"] = 11] = "BUFFER_END";
})(EventType = exports.EventType || (exports.EventType = {}));
;
var VideoState;
(function (VideoState) {
    VideoState[VideoState["ERROR"] = -1] = "ERROR";
    VideoState[VideoState["IDLE"] = 0] = "IDLE";
    VideoState[VideoState["PREPARING"] = 1] = "PREPARING";
    VideoState[VideoState["PREPARED"] = 2] = "PREPARED";
    VideoState[VideoState["PLAYING"] = 3] = "PLAYING";
    VideoState[VideoState["PAUSED"] = 4] = "PAUSED";
    VideoState[VideoState["COMPLETED"] = 5] = "COMPLETED";
})(VideoState || (VideoState = {}));
;
var ReadyState;
(function (ReadyState) {
    ReadyState[ReadyState["HAVE_NOTHING"] = 0] = "HAVE_NOTHING";
    ReadyState[ReadyState["HAVE_METADATA"] = 1] = "HAVE_METADATA";
    ReadyState[ReadyState["HAVE_CURRENT_DATA"] = 2] = "HAVE_CURRENT_DATA";
    ReadyState[ReadyState["HAVE_FUTURE_DATA"] = 3] = "HAVE_FUTURE_DATA";
    ReadyState[ReadyState["HAVE_ENOUGH_DATA"] = 4] = "HAVE_ENOUGH_DATA";
})(ReadyState || (ReadyState = {}));
;
var PixelFormat;
(function (PixelFormat) {
    PixelFormat[PixelFormat["NONE"] = -1] = "NONE";
    PixelFormat[PixelFormat["I420"] = 0] = "I420";
    PixelFormat[PixelFormat["RGB"] = 2] = "RGB";
    PixelFormat[PixelFormat["NV12"] = 23] = "NV12";
    PixelFormat[PixelFormat["NV21"] = 24] = "NV21";
    PixelFormat[PixelFormat["RGBA"] = 26] = "RGBA";
})(PixelFormat || (PixelFormat = {}));
;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var gfx = cc.gfx;
var CCMVideo = /** @class */ (function (_super) {
    __extends(CCMVideo, _super);
    function CCMVideo() {
        var _this = _super.call(this) || this;
        _this.source = null;
        _this.seekTime = 0;
        _this.nativeDuration = 0;
        _this.nativeWidth = 0;
        _this.nativeHeight = 0;
        _this.currentState = VideoState.IDLE;
        _this.targetState = VideoState.IDLE;
        _this.pixelFormat = PixelFormat.RGBA;
        _this.impl = null;
        _this.textures = [];
        _this.loaded = false;
        _this.isBuffering = false;
        _this.inBackground = false;
        _this.lastPlayState = false;
        // rgb material
        _this.rgb = null;
        // rgb material
        _this.rgba = null;
        // i420 material
        _this.i420 = null;
        // nv12 material
        _this.nv12 = null;
        // nv21 material
        _this.nv21 = null;
        // loop property
        _this.loop = false;
        // video event handler for editor
        _this.videoPlayerEvent = [];
        _this.initialize();
        return _this;
    }
    Object.defineProperty(CCMVideo.prototype, "materials", {
        // hide materials property of base class
        get: function () {
            return this['_materials'];
        },
        set: function (val) {
            this['_materials'] = val;
            // @ts-ignore
            this._activateMaterial();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "clip", {
        // video resource
        get: function () {
            return this.source;
        },
        set: function (value) {
            this.source = value;
            this.updateVideoSource();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "currentTime", {
        // current position of the video which is playing
        get: function () {
            if (!this.impl)
                return 0;
            if (this.isInPlaybackState()) {
                if (CC_JSB) {
                    return this.impl.currentTime();
                }
                else {
                    return this.impl.currentTime;
                }
            }
            else {
                return this.seekTime;
            }
        },
        // seek to position
        set: function (value) {
            if (!this.impl)
                return;
            if (this.isInPlaybackState()) {
                if (CC_JSB) {
                    this.impl.seek(value);
                }
                else {
                    this.impl.currentTime = value;
                }
            }
            else {
                this.seekTime = value;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "duration", {
        // duration of the video
        get: function () {
            if (!this.impl)
                return 0;
            if (this.nativeDuration > 0)
                return this.nativeDuration;
            if (CC_JSB) {
                this.nativeDuration = this.impl.duration();
            }
            else {
                var duration = this.impl.duration;
                this.nativeDuration = isNaN(duration) ? 0 : duration;
            }
            return this.nativeDuration;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "width", {
        get: function () {
            if (!this.isInPlaybackState())
                return 0;
            if (this.nativeWidth > 0)
                return this.nativeWidth;
            if (CC_JSB) {
                this.nativeWidth = this.impl.width();
            }
            else {
                var width = this.impl.videoWidth;
                this.nativeWidth = isNaN(width) ? 0 : width;
            }
            return this.nativeWidth;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "height", {
        get: function () {
            if (!this.isInPlaybackState())
                return 0;
            if (this.nativeHeight > 0)
                return this.nativeHeight;
            if (CC_JSB) {
                this.nativeHeight = this.impl.height();
            }
            else {
                var height = this.impl.videoHeight;
                this.nativeHeight = isNaN(height) ? 0 : height;
            }
            return this.nativeHeight;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "bufferPercentage", {
        // not accurate because native event is async, larger than actual percentage.
        get: function () {
            if (!this.impl)
                return 0;
            if (CC_JSB) {
                return this.impl.bufferPercentage();
            }
            else {
                return 0;
            }
        },
        enumerable: false,
        configurable: true
    });
    /**
     * override private method __preload
     */
    CCMVideo.prototype.__preload = function () {
        this.initializeMaterials();
        // @ts-ignore
        _super.prototype.__preload.call(this);
    };
    // must be called before super.__preload()
    CCMVideo.prototype.initializeMaterials = function () {
        this['_materials'] = [this.rgba];
    };
    /**
     * override private method _updateMaterial for set material properties
     */
    CCMVideo.prototype._updateMaterial = function () {
        var _this = this;
        var material = this.getMaterial(0);
        if (material) {
            material.setProperty('texture0', { getImpl: function () { return _this.textures[0]; } });
            switch (this.pixelFormat) {
                case PixelFormat.I420:
                    material.setProperty('texture2', { getImpl: function () { return _this.textures[2]; } });
                // fall through
                case PixelFormat.NV12:
                case PixelFormat.NV21:
                    material.setProperty('texture1', { getImpl: function () { return _this.textures[1]; } });
                    break;
            }
        }
        // @ts-ignore
        this.markForRender(true);
    };
    /**
     * update pixel format for android, ios, web platform, support yuv render
     */
    CCMVideo.prototype.updatePixelFormat = function () {
        var pixelFormat = CC_JSB ? this.impl.pixelFormat() : PixelFormat.RGB;
        if (this.pixelFormat == pixelFormat)
            return;
        this.pixelFormat = pixelFormat;
        switch (pixelFormat) {
            case PixelFormat.RGB:
                this.materials = [this.rgb];
                break;
            case PixelFormat.RGBA:
                this.materials = [this.rgba];
                break;
            case PixelFormat.I420:
                this.materials = [this.i420];
                break;
            case PixelFormat.NV12:
                this.materials = [this.nv12];
                break;
            case PixelFormat.NV21:
                this.materials = [this.nv21];
                break;
        }
    };
    /**
     * override private method _resetAssembler for customize video assembler
     */
    CCMVideo.prototype._resetAssembler = function () {
        // @ts-ignore
        this.setVertsDirty();
        this['_assembler'] = new CCMVideoAssembler_1.CCMVideoAssembler();
        this['_assembler'].init(this);
    };
    /**
     * initialize native video player, register video event handler
     */
    CCMVideo.prototype.initializeNative = function () {
        var _this = this;
        this.impl = new gfx.Video();
        this.textures = this.impl.getTextures();
        this.impl.addEventListener('loaded', function () { return _this.onMetaLoaded(); });
        this.impl.addEventListener('ready', function () { return _this.onReadyToPlay(); });
        this.impl.addEventListener('completed', function () { return _this.onCompleted(); });
        this.impl.addEventListener('error', function () { return _this.onError(); });
        this.impl.addEventListener('buffer_start', function () { return _this.onBufferStart(); });
        this.impl.addEventListener('buffer_update', function () { return _this.onBufferUpdate(); });
        this.impl.addEventListener('buffer_end', function () { return _this.onBufferEnd(); });
    };
    /**
     * initialize browser player, register video event handler
     */
    CCMVideo.prototype.initializeBrowser = function () {
        var _this = this;
        this.impl = document.createElement('video');
        this.impl.crossOrigin = 'anonymous';
        this.impl.autoplay = false;
        this.impl.loop = false;
        this.impl.muted = false;
        this.textures = [
            // @ts-ignore
            new cc.renderer.Texture2D(cc.renderer.device, {
                wrapS: gfx.WRAP_CLAMP,
                wrapT: gfx.WRAP_CLAMP,
                genMipmaps: false,
                premultiplyAlpha: false,
                flipY: false,
                format: gfx.TEXTURE_FMT_RGBA8
            })
        ];
        this.impl.addEventListener('loadedmetadata', function () { return _this.onMetaLoaded(); });
        this.impl.addEventListener('ended', function () { return _this.onCompleted(); });
        this.loaded = false;
        var onCanPlay = function () {
            if (_this.loaded || _this.currentState == VideoState.PLAYING)
                return;
            if (_this.impl.readyState === ReadyState.HAVE_ENOUGH_DATA ||
                _this.impl.readyState === ReadyState.HAVE_METADATA) {
                _this.impl.currentTime = 0;
                _this.loaded = true;
                _this.onReadyToPlay();
            }
        };
        this.impl.addEventListener('canplay', onCanPlay);
        this.impl.addEventListener('canplaythrough', onCanPlay);
        this.impl.addEventListener('suspend', onCanPlay);
        // @ts-ignore
        var gl = cc.renderer.device._gl;
        this.update = function (dt) {
            if (_this.isInPlaybackState()) {
                gl.bindTexture(gl.TEXTURE_2D, _this.textures[0]._glID);
                gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, _this.impl);
                // @ts-ignore
                cc.renderer.device._restoreTexture(0);
            }
        };
    };
    /**
     * initialize video player
     */
    CCMVideo.prototype.initialize = function () {
        if (CC_JSB) {
            this.initializeNative();
        }
        else {
            this.initializeBrowser();
        }
    };
    CCMVideo.prototype.onLoad = function () {
        if (this.impl) {
            this.updateVideoSource();
        }
    };
    /**
     * register game show and hide event handler
     */
    CCMVideo.prototype.onEnable = function () {
        _super.prototype.onEnable.call(this);
        cc.game.on(cc.game.EVENT_SHOW, this.onShow, this);
        cc.game.on(cc.game.EVENT_HIDE, this.onHide, this);
    };
    // unregister game show and hide event handler
    CCMVideo.prototype.onDisable = function () {
        _super.prototype.onDisable.call(this);
        cc.game.off(cc.game.EVENT_SHOW, this.onShow, this);
        cc.game.off(cc.game.EVENT_HIDE, this.onHide, this);
        this.stop();
    };
    CCMVideo.prototype.onShow = function () {
        if (!this.inBackground)
            return;
        this.inBackground = false;
        if (this.lastPlayState)
            this.resume();
    };
    CCMVideo.prototype.onHide = function () {
        if (this.inBackground)
            return;
        this.inBackground = true;
        this.lastPlayState = this.isPlaying();
        if (this.lastPlayState)
            this.pause();
    };
    CCMVideo.prototype._onPreDestroy = function () {
        if (this.impl) {
            if (CC_JSB)
                this.impl.destroy();
            this.impl = undefined;
        }
        // @ts-ignore
        _super.prototype._onPreDestroy.call(this);
    };
    /**
     * update video data source
     */
    CCMVideo.prototype.updateVideoSource = function () {
        this.seekTime = 0;
        this.nativeDuration = 0;
        this.nativeWidth = 0;
        this.nativeHeight = 0;
        this.currentState = VideoState.PREPARING;
        this.targetState = VideoState.PREPARING;
        var url = '';
        if (this.source) {
            if (typeof this.source == 'string') {
                url = this.source;
            }
            else {
                url = this.source.nativeUrl;
            }
        }
        if (url && cc.loader.md5Pipe) {
            url = cc.loader.md5Pipe.transformURL(url);
        }
        if (CC_JSB) {
            this.impl.stop();
            this.impl.setURL(url);
            this.impl.prepare();
        }
        else {
            this.loaded = false;
            this.impl.pause();
            this.impl.src = url;
        }
        this.node.emit('preparing', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PREPARING);
    };
    CCMVideo.prototype.onReadyToPlay = function () {
        this.updatePixelFormat();
        this.currentState = VideoState.PREPARED;
        if (this.seekTime > 0.1) {
            this.currentTime = this.seekTime;
        }
        this.node.emit('ready', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.READY);
        this.targetState == VideoState.PLAYING && this.play();
    };
    CCMVideo.prototype.onMetaLoaded = function () {
        this.node.emit('loaded', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.LOADED);
    };
    CCMVideo.prototype.onBufferStart = function () {
        this.isBuffering = true;
        this.node.emit('buffer_start', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.BUFFER_START);
    };
    CCMVideo.prototype.onBufferUpdate = function () {
        this.node.emit('buffer_update', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.BUFFER_UPDATE);
    };
    CCMVideo.prototype.onBufferEnd = function () {
        this.isBuffering = false;
        this.node.emit('buffer_end', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.BUFFER_END);
    };
    CCMVideo.prototype.onCompleted = function () {
        if (this.loop) {
            if (this.currentState == VideoState.PLAYING) {
                this.currentTime = 0;
                this.impl.play();
            }
        }
        else {
            this.currentState = VideoState.COMPLETED;
            this.targetState = VideoState.COMPLETED;
            this.node.emit('completed', this);
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.COMPLETED);
        }
    };
    CCMVideo.prototype.onError = function () {
        this.currentState = VideoState.ERROR;
        this.targetState = VideoState.ERROR;
        this.node.emit('error', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.ERROR);
    };
    CCMVideo.prototype.play = function () {
        if (this.isInPlaybackState()) {
            if (this.currentState == VideoState.COMPLETED) {
                this.currentTime = 0;
            }
            if (this.currentState != VideoState.PLAYING) {
                this.impl.play();
                this.node.emit('playing', this);
                this.currentState = VideoState.PLAYING;
                this.targetState = VideoState.PLAYING;
                cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PLAYING);
            }
        }
        else {
            this.targetState = VideoState.PLAYING;
        }
    };
    CCMVideo.prototype.resume = function () {
        if (this.isInPlaybackState() && this.currentState != VideoState.PLAYING) {
            if (CC_JSB) {
                this.impl.resume();
            }
            else {
                this.impl.play();
            }
            this.node.emit('playing', this);
            this.currentState = VideoState.PLAYING;
            this.targetState = VideoState.PLAYING;
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PLAYING);
        }
        else {
            this.targetState = VideoState.PLAYING;
        }
    };
    CCMVideo.prototype.pause = function () {
        if (this.isInPlaybackState() && this.currentState != VideoState.PAUSED) {
            this.impl.pause();
            this.node.emit('paused', this);
            this.currentState = VideoState.PAUSED;
            this.targetState = VideoState.PAUSED;
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PAUSED);
        }
        else {
            this.targetState = VideoState.PAUSED;
        }
    };
    CCMVideo.prototype.stop = function () {
        this.seekTime = 0;
        if (this.isInPlaybackState() && this.currentState != VideoState.IDLE) {
            if (CC_JSB) {
                this.impl.stop();
            }
            else {
                this.impl.pause();
                this.impl.currentTime = 0;
            }
            this.node.emit('stopped', this);
            this.currentState = VideoState.IDLE;
            this.targetState = VideoState.IDLE;
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.STOPPED);
        }
        else {
            this.targetState = VideoState.IDLE;
        }
    };
    CCMVideo.prototype.clear = function () {
    };
    CCMVideo.prototype.isPlaying = function () {
        return this.currentState == VideoState.PLAYING || this.targetState == VideoState.PLAYING;
    };
    CCMVideo.prototype.isInPlaybackState = function () {
        return !!this.impl && this.currentState != VideoState.IDLE && this.currentState != VideoState.PREPARING && this.currentState != VideoState.ERROR;
    };
    __decorate([
        property({
            type: [cc.Material],
            visible: false,
            override: true,
        })
    ], CCMVideo.prototype, "materials", null);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "rgb", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "rgba", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "i420", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "nv12", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "nv21", void 0);
    __decorate([
        property
    ], CCMVideo.prototype, "loop", void 0);
    __decorate([
        property([cc.Component.EventHandler])
    ], CCMVideo.prototype, "videoPlayerEvent", void 0);
    CCMVideo = __decorate([
        ccclass
    ], CCMVideo);
    return CCMVideo;
}(cc.RenderComponent));
exports.CCMVideo = CCMVideo;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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