
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMUtils.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '78ca3nM8PRIVZeqkuNrmj1L', 'CCMUtils');
// lib/CCMUtils.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var CCMUtils = /** @class */ (function () {
    function CCMUtils() {
        this.clickTime = {};
    }
    CCMUtils.getInstance = function () {
        if (!CCMUtils.instance) {
            CCMUtils.instance = new CCMUtils();
        }
        return CCMUtils.instance;
    };
    /**
     * @description 是否频繁点击
     * @param 判断重点的一个id，用于区分不同时机
     * @duration 少于该时长即认为发生了重复点击（毫秒）
     **/
    CCMUtils.prototype.isQuickClick = function (tag, duration) {
        if (!tag)
            tag = 'normal';
        if (!this.clickTime)
            this.clickTime = {};
        if (this.clickTime[tag] == undefined)
            this.clickTime[tag] = 0;
        var gapTime = new Date().getTime() - this.clickTime[tag];
        if (!duration)
            duration = 500;
        if (gapTime < duration) {
            console.log(CCMUtils.TAG, '请勿重复点击');
            return true;
        }
        this.clickTime[tag] = new Date().getTime();
        return false;
    };
    /**
     * @description 是否是平板的屏幕，仅根据屏幕高宽比判断，不适合用于确定是否真的平板
     */
    CCMUtils.prototype.isPadScreen = function () {
        var screenWidth = cc.view.getVisibleSize().width;
        var screenHeight = cc.view.getVisibleSize().height;
        var ratio = 1.69;
        return !(screenWidth > screenHeight && screenWidth >= ratio * screenHeight)
            && !(screenHeight > screenWidth && screenHeight >= ratio * screenWidth);
    };
    CCMUtils.prototype.isWxGame = function () {
        return cc.sys.platform === cc.sys.WECHAT_GAME;
    };
    CCMUtils.prototype.isAndroid = function () {
        return cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID;
    };
    CCMUtils.prototype.isIOS = function () {
        return cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS;
    };
    CCMUtils.prototype.isBrowser = function () {
        return cc.sys.isBrowser;
    };
    /**
     * @description 快速获取某个数据对象中深层 key 的值
     * @param src 数据对象
     * @param key 要获取值对应的 key，层级通过 # 分割
     */
    CCMUtils.prototype.key4property = function (src, key) {
        if (!src)
            return undefined;
        var keys = key.split('#');
        for (var i = 0, j = keys.length; i < j; i++) {
            src = src[keys[i]];
            if (typeof src == 'object' && src != null)
                continue;
            if (i < j - 1)
                return undefined;
        }
        return src;
    };
    CCMUtils.TAG = 'CCMSceneManager';
    return CCMUtils;
}());
exports.default = CCMUtils;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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