
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMBinding/CCMRouter.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0cac4WEByFBWavsOGLakGqf', 'CCMRouter');
// lib/CCMBinding/CCMRouter.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 路由方法，可以注册方法供别的模块,或者是native主动发起调用
 */
var CCMBinding_1 = require("./CCMBinding");
var TAG = 'CCMRouter';
var CCMRouter = /** @class */ (function () {
    function CCMRouter() {
        this.methodMap = new Map();
    }
    CCMRouter.callMethod = function (methodName, args) {
        return this.Instance.callMethod(methodName, args);
    };
    CCMRouter.registerMethod = function (methodName, callback) {
        return this.Instance.registerMethod(methodName, callback);
    };
    CCMRouter.unRegisterMethod = function (eventName) {
        return this.Instance.unRegisterMethod(eventName);
    };
    Object.defineProperty(CCMRouter, "Instance", {
        get: function () {
            if (!this.instance) {
                this.instance = new CCMRouter();
            }
            return this.instance;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 自定义事件处理者
     */
    CCMRouter.prototype.registerMethod = function (eventName, callback) {
        var _this = this;
        this.methodMap.set(eventName, callback);
        window["ccmbinding_router_" + eventName] = function (args) {
            cc.log(TAG, 'called eventName' + eventName);
            return _this.callMethod(eventName, args).then().catch();
        };
    };
    CCMRouter.prototype.unRegisterMethod = function (eventName) {
        this.methodMap.delete(eventName);
        delete window["ccmbinding_router_" + eventName];
    };
    CCMRouter.prototype.callMethod = function (methodName, args) {
        var method = this.methodMap.get(methodName);
        if (method) {
            var data = args['data'];
            var exeResult = method.call(this, data);
            // 如果是在native环境下，则需要把结果返回到native中。
            if (cc.sys.isNative && typeof exeResult === 'object') {
                if (exeResult instanceof Promise) {
                    exeResult.then(function (result) {
                        cc.log('start call native from ts');
                        var callbackName = args['@nativeCallbackName'];
                        CCMBinding_1.default.withOptions({ hasCallback: false }).callNativeMethod(callbackName, result)
                            .then(function (rs) {
                            cc.log('receive:', rs);
                        }).catch(function (e) {
                            cc.log('exception:', e);
                        });
                    });
                }
                else {
                    cc.log('start call native from ts');
                    var callbackName = args['@nativeCallbackName'];
                    CCMBinding_1.default.withOptions({ hasCallback: false }).callNativeMethod(callbackName, exeResult)
                        .then(function (rs) {
                        cc.log('receive:', rs);
                    }).catch(function (e) {
                        cc.log('exception:', e);
                    });
                }
            }
            return Promise.resolve(exeResult);
        }
        else {
            return Promise.reject({ code: -1, msg: methodName + " not register" });
        }
    };
    return CCMRouter;
}());
exports.default = CCMRouter;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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