
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMBinding/CCMBinding.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '88396uYlDlKdpiCzSL5nr8D', 'CCMBinding');
// lib/CCMBinding/CCMBinding.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var AUTO_INCREASE_ID = 0;
var ERROR_CODE_METHOD_NOT_DEFINED = -1;
var ERROR_CODE_PARAMS_ERROR = -2;
var ERROR_CODE_TIMEOUT = -3;
var ERROR_CODE_UNKNOW = -999;
var CCMBinding = /** @class */ (function () {
    function CCMBinding() {
        this.DEFAULT_OPTIONS = { timeout: 60, hasCallback: true, onProgress: undefined };
        this._options = this.DEFAULT_OPTIONS;
    }
    Object.defineProperty(CCMBinding, "Instance", {
        get: function () {
            if (!this.instance) {
                this.instance = new CCMBinding();
            }
            return this.instance;
        },
        enumerable: false,
        configurable: true
    });
    CCMBinding.withOptions = function (options) {
        return this.Instance.withOptions(options);
    };
    CCMBinding.callNativeMethod = function (methodName, args) {
        return this.Instance.callNativeMethod(methodName, args);
    };
    /**
     * 创建一个临时请求native方法的可选项，包含：
     * 超时时间设置默认60秒，过程回调（若有)
     * @param options Options,
     */
    CCMBinding.prototype.withOptions = function (options) {
        var oriProto = Object.getPrototypeOf(this);
        var temp = Object.assign(Object.create(oriProto), this);
        temp._options = Object.assign({}, this.DEFAULT_OPTIONS, options);
        return temp;
    };
    CCMBinding.prototype.callNativeMethod = function (methodName, args) {
        var _this = this;
        console.log("options:" + JSON.stringify(this._options) + ", args:" + args);
        var hasCallback = this._options.hasCallback;
        var hasProgress = this._options.onProgress;
        return new Promise(function (resolve, reject) {
            var cbName = '';
            var timeoutId;
            var cbProgressName = '';
            if (hasCallback || hasProgress) {
                // eslint-disable-next-line no-plusplus
                cbName = "CCM_CB" + new Date().getTime() + "_" + AUTO_INCREASE_ID++;
                cbProgressName = cbName + "_p";
                timeoutId = setTimeout(function () {
                    if (window[cbName]) {
                        _this.clearCallback(cbName, -1, cbProgressName);
                        reject({ code: ERROR_CODE_TIMEOUT, msg: "delete cb name: " + cbName + ",because of timeout" });
                    }
                }, _this._options.timeout * 1000);
                window[cbName] = function (result) {
                    console.log('result from native:', JSON.stringify(result));
                    if (result) {
                        var code = result.code;
                        var msg = result.msg;
                        var errCode = result.eCode;
                        var data = result.data;
                        if (code == 0) {
                            resolve(data);
                        }
                        else {
                            reject({ code: errCode, msg: msg });
                        }
                    }
                    else {
                        reject({ code: ERROR_CODE_UNKNOW, msg: 'result is null' });
                    }
                    _this.clearCallback(cbName, timeoutId, cbProgressName);
                };
                window[cbProgressName] = function (progressData) {
                    cc.log('invoke data', JSON.stringify(progressData));
                    if (_this._options.onProgress && progressData) {
                        var code = progressData.code;
                        var msg = progressData.msg;
                        var errCode = progressData.eCode;
                        var data = progressData.data;
                        if (code == 0) {
                            _this._options.onProgress(data);
                        }
                        else {
                            cc.log("progress error: " + code + ", " + errCode + "," + msg);
                        }
                    }
                };
            }
            if (cc.sys.isNative && cc.sys.os === cc.sys.OS_ANDROID) {
                var resultCode = jsb.reflection.callStaticMethod('com/tencent/cocomat/binding/CCMBinding', 'execute', '(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I', methodName, typeof args === 'object' ? JSON.stringify(args) : '', cbName);
                if (resultCode !== 0) {
                    switch (resultCode) {
                        case -1:
                            reject({
                                code: ERROR_CODE_METHOD_NOT_DEFINED,
                                msg: methodName + " not found on Android platform"
                            });
                            break;
                        case -2:
                            reject({ code: ERROR_CODE_PARAMS_ERROR, msg: "error! invalid parameters" });
                            break;
                        default:
                            reject({ code: resultCode, msg: "error! result code=" + resultCode });
                            break;
                    }
                    if (hasCallback) {
                        _this.clearCallback(cbName, timeoutId, cbProgressName);
                    }
                }
            }
            else if (cc.sys.isNative && cc.sys.os === cc.sys.OS_IOS) {
                var retId = jsb.reflection.callStaticMethod('CCMBinding', 'executeWithMethodName:args:callback:', methodName, typeof args === 'object' ? JSON.stringify(args) : '', cbName);
            }
            else {
                var msg = 'no implemented on this platform';
                reject({ code: ERROR_CODE_METHOD_NOT_DEFINED, msg: msg });
                _this.clearCallback(cbName, timeoutId, cbProgressName);
            }
        });
    };
    CCMBinding.prototype.clearCallback = function (cbName, timeoutId, cbProgressName) {
        if (timeoutId === void 0) { timeoutId = -1; }
        if (cbProgressName === void 0) { cbProgressName = ''; }
        if (cbProgressName && cbProgressName != '') {
            console.log("delete cbProgressName" + cbName);
            delete window[cbProgressName];
        }
        if (cbName && cbName != '') {
            console.log("delete cbName" + cbName);
            delete window[cbName];
        }
        if (timeoutId >= 0) {
            console.log("clearTimeout" + cbName);
            clearTimeout(timeoutId);
        }
    };
    return CCMBinding;
}());
exports.default = CCMBinding;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvY28tbWF0L2xpYi9DQ01CaW5kaW5nL0NDTUJpbmRpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFTQSxJQUFJLGdCQUFnQixHQUFHLENBQUMsQ0FBQztBQUV6QixJQUFNLDZCQUE2QixHQUFHLENBQUMsQ0FBQyxDQUFDO0FBQ3pDLElBQU0sdUJBQXVCLEdBQUcsQ0FBQyxDQUFDLENBQUM7QUFDbkMsSUFBTSxrQkFBa0IsR0FBRyxDQUFDLENBQUMsQ0FBQztBQUM5QixJQUFNLGlCQUFpQixHQUFHLENBQUMsR0FBRyxDQUFDO0FBQy9CO0lBQUE7UUFrQlksb0JBQWUsR0FBWSxFQUFDLE9BQU8sRUFBRSxFQUFFLEVBQUUsV0FBVyxFQUFFLElBQUksRUFBRSxVQUFVLEVBQUUsU0FBUyxFQUFDLENBQUM7UUFDbkYsYUFBUSxHQUFZLElBQUksQ0FBQyxlQUFlLENBQUM7SUFrSHJELENBQUM7SUFsSUcsc0JBQWtCLHNCQUFRO2FBQTFCO1lBQ0ksSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUU7Z0JBQ2hCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxVQUFVLEVBQUUsQ0FBQzthQUNwQztZQUNELE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUN6QixDQUFDOzs7T0FBQTtJQUVhLHNCQUFXLEdBQXpCLFVBQTBCLE9BQWdCO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUVhLDJCQUFnQixHQUE5QixVQUErQixVQUFrQixFQUFFLElBQWdEO1FBQy9GLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDNUQsQ0FBQztJQU1EOzs7O09BSUc7SUFDSSxnQ0FBVyxHQUFsQixVQUFtQixPQUFnQjtRQUMvQixJQUFNLFFBQVEsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzdDLElBQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMxRCxJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxlQUFlLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDakUsT0FBTyxJQUFJLENBQUM7SUFDaEIsQ0FBQztJQUVNLHFDQUFnQixHQUF2QixVQUF3QixVQUFrQixFQUFFLElBQWdEO1FBQTVGLGlCQW1GQztRQWxGRyxPQUFPLENBQUMsR0FBRyxDQUFDLGFBQVcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLGVBQVUsSUFBTSxDQUFDLENBQUM7UUFDdEUsSUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUM7UUFDOUMsSUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUM7UUFDN0MsT0FBTyxJQUFJLE9BQU8sQ0FBQyxVQUFDLE9BQU8sRUFBRSxNQUFNO1lBQy9CLElBQUksTUFBTSxHQUFHLEVBQUUsQ0FBQztZQUNoQixJQUFJLFNBQVMsQ0FBQztZQUNkLElBQUksY0FBYyxHQUFHLEVBQUUsQ0FBQztZQUN4QixJQUFJLFdBQVcsSUFBSSxXQUFXLEVBQUU7Z0JBQzVCLHVDQUF1QztnQkFDdkMsTUFBTSxHQUFHLFdBQVMsSUFBSSxJQUFJLEVBQUUsQ0FBQyxPQUFPLEVBQUUsU0FBSSxnQkFBZ0IsRUFBSSxDQUFDO2dCQUMvRCxjQUFjLEdBQU0sTUFBTSxPQUFJLENBQUM7Z0JBQy9CLFNBQVMsR0FBRyxVQUFVLENBQUM7b0JBQ25CLElBQUksTUFBTSxDQUFDLE1BQU0sQ0FBQyxFQUFFO3dCQUNoQixLQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUMsRUFBRSxjQUFjLENBQUMsQ0FBQzt3QkFDL0MsTUFBTSxDQUFDLEVBQUMsSUFBSSxFQUFFLGtCQUFrQixFQUFFLEdBQUcsRUFBRSxxQkFBbUIsTUFBTSx3QkFBcUIsRUFBQyxDQUFDLENBQUM7cUJBQzNGO2dCQUNMLENBQUMsRUFBRSxLQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsQ0FBQztnQkFDakMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxHQUFHLFVBQUMsTUFBTTtvQkFDcEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7b0JBQzNELElBQUksTUFBTSxFQUFFO3dCQUNSLElBQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7d0JBQ3pCLElBQU0sR0FBRyxHQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUM7d0JBQ3ZCLElBQU0sT0FBTyxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7d0JBQzdCLElBQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7d0JBQ3pCLElBQUksSUFBSSxJQUFJLENBQUMsRUFBRTs0QkFDWCxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7eUJBQ2pCOzZCQUFNOzRCQUNILE1BQU0sQ0FBQyxFQUFDLElBQUksRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBQyxDQUFDLENBQUM7eUJBQ3JDO3FCQUNKO3lCQUFNO3dCQUNILE1BQU0sQ0FBQyxFQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRSxHQUFHLEVBQUUsZ0JBQWdCLEVBQUMsQ0FBQyxDQUFDO3FCQUM1RDtvQkFDRCxLQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sRUFBRSxTQUFTLEVBQUUsY0FBYyxDQUFDLENBQUM7Z0JBQzFELENBQUMsQ0FBQztnQkFFRixNQUFNLENBQUMsY0FBYyxDQUFDLEdBQUcsVUFBQyxZQUFZO29CQUNsQyxFQUFFLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7b0JBQ3BELElBQUksS0FBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLElBQUksWUFBWSxFQUFFO3dCQUMxQyxJQUFNLElBQUksR0FBRyxZQUFZLENBQUMsSUFBSSxDQUFDO3dCQUMvQixJQUFNLEdBQUcsR0FBRyxZQUFZLENBQUMsR0FBRyxDQUFDO3dCQUM3QixJQUFNLE9BQU8sR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO3dCQUNuQyxJQUFNLElBQUksR0FBRyxZQUFZLENBQUMsSUFBSSxDQUFDO3dCQUMvQixJQUFJLElBQUksSUFBSSxDQUFDLEVBQUU7NEJBQ1gsS0FBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUM7eUJBQ2xDOzZCQUFNOzRCQUNILEVBQUUsQ0FBQyxHQUFHLENBQUMscUJBQW1CLElBQUksVUFBSyxPQUFPLFNBQUksR0FBSyxDQUFDLENBQUM7eUJBQ3hEO3FCQUNKO2dCQUNMLENBQUMsQ0FBQzthQUNMO1lBRUQsSUFBSSxFQUFFLENBQUMsR0FBRyxDQUFDLFFBQVEsSUFBSSxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsR0FBRyxDQUFDLFVBQVUsRUFBRTtnQkFDcEQsSUFBTSxVQUFVLEdBQUcsR0FBRyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyx3Q0FBd0MsRUFBRSxTQUFTLEVBQUUsMkRBQTJELEVBQy9KLFVBQVUsRUFBRSxPQUFPLElBQUksS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxNQUFNLENBQUMsQ0FBQztnQkFDOUUsSUFBSSxVQUFVLEtBQUssQ0FBQyxFQUFFO29CQUNsQixRQUFRLFVBQVUsRUFBRTt3QkFDaEIsS0FBSyxDQUFDLENBQUM7NEJBQ0gsTUFBTSxDQUFDO2dDQUNILElBQUksRUFBRSw2QkFBNkI7Z0NBQ25DLEdBQUcsRUFBSyxVQUFVLG1DQUFnQzs2QkFDckQsQ0FBQyxDQUFDOzRCQUNILE1BQU07d0JBQ1YsS0FBSyxDQUFDLENBQUM7NEJBQ0gsTUFBTSxDQUFDLEVBQUMsSUFBSSxFQUFFLHVCQUF1QixFQUFFLEdBQUcsRUFBRSwyQkFBMkIsRUFBQyxDQUFDLENBQUM7NEJBQzFFLE1BQU07d0JBQ1Y7NEJBQ0ksTUFBTSxDQUFDLEVBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRSxHQUFHLEVBQUUsd0JBQXNCLFVBQVksRUFBQyxDQUFDLENBQUM7NEJBQ3BFLE1BQU07cUJBQ2I7b0JBQ0QsSUFBSSxXQUFXLEVBQUU7d0JBQ2IsS0FBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLEVBQUUsU0FBUyxFQUFFLGNBQWMsQ0FBQyxDQUFDO3FCQUN6RDtpQkFDSjthQUNKO2lCQUFNLElBQUksRUFBRSxDQUFDLEdBQUcsQ0FBQyxRQUFRLElBQUksRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEtBQUssRUFBRSxDQUFDLEdBQUcsQ0FBQyxNQUFNLEVBQUU7Z0JBQ3ZELElBQU0sS0FBSyxHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxFQUFFLHNDQUFzQyxFQUM5RixVQUFVLEVBQUUsT0FBTyxJQUFJLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsTUFBTSxDQUFDLENBQUM7YUFDakY7aUJBQU07Z0JBQ0gsSUFBTSxHQUFHLEdBQUcsaUNBQWlDLENBQUM7Z0JBQzlDLE1BQU0sQ0FBQyxFQUFDLElBQUksRUFBRSw2QkFBNkIsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFDLENBQUMsQ0FBQztnQkFDeEQsS0FBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLEVBQUUsU0FBUyxFQUFFLGNBQWMsQ0FBQyxDQUFDO2FBQ3pEO1FBQ0wsQ0FBQyxDQUFDLENBQUM7SUFDUCxDQUFDO0lBRU8sa0NBQWEsR0FBckIsVUFBc0IsTUFBYyxFQUFFLFNBQXNCLEVBQUUsY0FBbUI7UUFBM0MsMEJBQUEsRUFBQSxhQUFxQixDQUFDO1FBQUUsK0JBQUEsRUFBQSxtQkFBbUI7UUFDN0UsSUFBSSxjQUFjLElBQUksY0FBYyxJQUFJLEVBQUUsRUFBRTtZQUN4QyxPQUFPLENBQUMsR0FBRyxDQUFDLDBCQUF3QixNQUFRLENBQUMsQ0FBQztZQUM5QyxPQUFPLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQztTQUNqQztRQUNELElBQUksTUFBTSxJQUFJLE1BQU0sSUFBSSxFQUFFLEVBQUU7WUFDeEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBZ0IsTUFBUSxDQUFDLENBQUM7WUFDdEMsT0FBTyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUM7U0FDekI7UUFDRCxJQUFJLFNBQVMsSUFBSSxDQUFDLEVBQUU7WUFDaEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBZSxNQUFRLENBQUMsQ0FBQztZQUNyQyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUM7U0FDM0I7SUFDTCxDQUFDO0lBQ0wsaUJBQUM7QUFBRCxDQXJJQSxBQXFJQyxJQUFBIiwiZmlsZSI6IiIsInNvdXJjZVJvb3QiOiIvIiwic291cmNlc0NvbnRlbnQiOlsiaW50ZXJmYWNlIE9wdGlvbnMge1xuICAgIC8qKlxuICAgICAqIOaOpeWPo+iwg+eUqOi2heaXtuaXtumXtCzljZXkvY3np5JcbiAgICAgKi9cbiAgICB0aW1lb3V0PzogbnVtYmVyO1xuICAgIGhhc0NhbGxiYWNrPzogYm9vbGVhbjtcbiAgICBvblByb2dyZXNzPzogRnVuY3Rpb247XG59XG5cbmxldCBBVVRPX0lOQ1JFQVNFX0lEID0gMDtcblxuY29uc3QgRVJST1JfQ09ERV9NRVRIT0RfTk9UX0RFRklORUQgPSAtMTtcbmNvbnN0IEVSUk9SX0NPREVfUEFSQU1TX0VSUk9SID0gLTI7XG5jb25zdCBFUlJPUl9DT0RFX1RJTUVPVVQgPSAtMztcbmNvbnN0IEVSUk9SX0NPREVfVU5LTk9XID0gLTk5OTtcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIENDTUJpbmRpbmcge1xuICAgIHByaXZhdGUgc3RhdGljIGluc3RhbmNlOiBDQ01CaW5kaW5nO1xuXG4gICAgcHVibGljIHN0YXRpYyBnZXQgSW5zdGFuY2UoKSB7XG4gICAgICAgIGlmICghdGhpcy5pbnN0YW5jZSkge1xuICAgICAgICAgICAgdGhpcy5pbnN0YW5jZSA9IG5ldyBDQ01CaW5kaW5nKCk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHRoaXMuaW5zdGFuY2U7XG4gICAgfVxuXG4gICAgcHVibGljIHN0YXRpYyB3aXRoT3B0aW9ucyhvcHRpb25zOiBPcHRpb25zKTogQ0NNQmluZGluZyB7XG4gICAgICAgIHJldHVybiB0aGlzLkluc3RhbmNlLndpdGhPcHRpb25zKG9wdGlvbnMpO1xuICAgIH1cblxuICAgIHB1YmxpYyBzdGF0aWMgY2FsbE5hdGl2ZU1ldGhvZChtZXRob2ROYW1lOiBzdHJpbmcsIGFyZ3M/OiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmcgfCBudW1iZXIgfCBib29sZWFuPik6IFByb21pc2U8YW55PiB7XG4gICAgICAgIHJldHVybiB0aGlzLkluc3RhbmNlLmNhbGxOYXRpdmVNZXRob2QobWV0aG9kTmFtZSwgYXJncyk7XG4gICAgfVxuXG4gICAgcHJpdmF0ZSBERUZBVUxUX09QVElPTlM6IE9wdGlvbnMgPSB7dGltZW91dDogNjAsIGhhc0NhbGxiYWNrOiB0cnVlLCBvblByb2dyZXNzOiB1bmRlZmluZWR9O1xuICAgIHByaXZhdGUgX29wdGlvbnM6IE9wdGlvbnMgPSB0aGlzLkRFRkFVTFRfT1BUSU9OUztcblxuXG4gICAgLyoqXG4gICAgICog5Yib5bu65LiA5Liq5Li05pe26K+35rGCbmF0aXZl5pa55rOV55qE5Y+v6YCJ6aG577yM5YyF5ZCr77yaXG4gICAgICog6LaF5pe25pe26Ze06K6+572u6buY6K6kNjDnp5LvvIzov4fnqIvlm57osIPvvIjoi6XmnIkpXG4gICAgICogQHBhcmFtIG9wdGlvbnMgT3B0aW9ucyxcbiAgICAgKi9cbiAgICBwdWJsaWMgd2l0aE9wdGlvbnMob3B0aW9uczogT3B0aW9ucyk6IENDTUJpbmRpbmcge1xuICAgICAgICBjb25zdCBvcmlQcm90byA9IE9iamVjdC5nZXRQcm90b3R5cGVPZih0aGlzKTtcbiAgICAgICAgY29uc3QgdGVtcCA9IE9iamVjdC5hc3NpZ24oT2JqZWN0LmNyZWF0ZShvcmlQcm90byksIHRoaXMpO1xuICAgICAgICB0ZW1wLl9vcHRpb25zID0gT2JqZWN0LmFzc2lnbih7fSwgdGhpcy5ERUZBVUxUX09QVElPTlMsIG9wdGlvbnMpO1xuICAgICAgICByZXR1cm4gdGVtcDtcbiAgICB9XG5cbiAgICBwdWJsaWMgY2FsbE5hdGl2ZU1ldGhvZChtZXRob2ROYW1lOiBzdHJpbmcsIGFyZ3M/OiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmcgfCBudW1iZXIgfCBib29sZWFuPik6IFByb21pc2U8YW55PiB7XG4gICAgICAgIGNvbnNvbGUubG9nKGBvcHRpb25zOiR7SlNPTi5zdHJpbmdpZnkodGhpcy5fb3B0aW9ucyl9LCBhcmdzOiR7YXJnc31gKTtcbiAgICAgICAgY29uc3QgaGFzQ2FsbGJhY2sgPSB0aGlzLl9vcHRpb25zLmhhc0NhbGxiYWNrO1xuICAgICAgICBjb25zdCBoYXNQcm9ncmVzcyA9IHRoaXMuX29wdGlvbnMub25Qcm9ncmVzcztcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICAgICAgICAgIGxldCBjYk5hbWUgPSAnJztcbiAgICAgICAgICAgIGxldCB0aW1lb3V0SWQ7XG4gICAgICAgICAgICBsZXQgY2JQcm9ncmVzc05hbWUgPSAnJztcbiAgICAgICAgICAgIGlmIChoYXNDYWxsYmFjayB8fCBoYXNQcm9ncmVzcykge1xuICAgICAgICAgICAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1wbHVzcGx1c1xuICAgICAgICAgICAgICAgIGNiTmFtZSA9IGBDQ01fQ0Ike25ldyBEYXRlKCkuZ2V0VGltZSgpfV8ke0FVVE9fSU5DUkVBU0VfSUQrK31gO1xuICAgICAgICAgICAgICAgIGNiUHJvZ3Jlc3NOYW1lID0gYCR7Y2JOYW1lfV9wYDtcbiAgICAgICAgICAgICAgICB0aW1lb3V0SWQgPSBzZXRUaW1lb3V0KCgpID0+IHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHdpbmRvd1tjYk5hbWVdKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmNsZWFyQ2FsbGJhY2soY2JOYW1lLCAtMSwgY2JQcm9ncmVzc05hbWUpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmVqZWN0KHtjb2RlOiBFUlJPUl9DT0RFX1RJTUVPVVQsIG1zZzogYGRlbGV0ZSBjYiBuYW1lOiAke2NiTmFtZX0sYmVjYXVzZSBvZiB0aW1lb3V0YH0pO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSwgdGhpcy5fb3B0aW9ucy50aW1lb3V0ICogMTAwMCk7XG4gICAgICAgICAgICAgICAgd2luZG93W2NiTmFtZV0gPSAocmVzdWx0KSA9PiB7XG4gICAgICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKCdyZXN1bHQgZnJvbSBuYXRpdmU6JywgSlNPTi5zdHJpbmdpZnkocmVzdWx0KSk7XG4gICAgICAgICAgICAgICAgICAgIGlmIChyZXN1bHQpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnN0IGNvZGUgPSByZXN1bHQuY29kZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnN0IG1zZyA9IHJlc3VsdC5tc2c7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb25zdCBlcnJDb2RlID0gcmVzdWx0LmVDb2RlO1xuICAgICAgICAgICAgICAgICAgICAgICAgY29uc3QgZGF0YSA9IHJlc3VsdC5kYXRhO1xuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKGNvZGUgPT0gMCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlc29sdmUoZGF0YSk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlamVjdCh7Y29kZTogZXJyQ29kZSwgbXNnOiBtc2d9KTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJlamVjdCh7Y29kZTogRVJST1JfQ09ERV9VTktOT1csIG1zZzogJ3Jlc3VsdCBpcyBudWxsJ30pO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuY2xlYXJDYWxsYmFjayhjYk5hbWUsIHRpbWVvdXRJZCwgY2JQcm9ncmVzc05hbWUpO1xuICAgICAgICAgICAgICAgIH07XG5cbiAgICAgICAgICAgICAgICB3aW5kb3dbY2JQcm9ncmVzc05hbWVdID0gKHByb2dyZXNzRGF0YSkgPT4ge1xuICAgICAgICAgICAgICAgICAgICBjYy5sb2coJ2ludm9rZSBkYXRhJywgSlNPTi5zdHJpbmdpZnkocHJvZ3Jlc3NEYXRhKSk7XG4gICAgICAgICAgICAgICAgICAgIGlmICh0aGlzLl9vcHRpb25zLm9uUHJvZ3Jlc3MgJiYgcHJvZ3Jlc3NEYXRhKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb25zdCBjb2RlID0gcHJvZ3Jlc3NEYXRhLmNvZGU7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb25zdCBtc2cgPSBwcm9ncmVzc0RhdGEubXNnO1xuICAgICAgICAgICAgICAgICAgICAgICAgY29uc3QgZXJyQ29kZSA9IHByb2dyZXNzRGF0YS5lQ29kZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnN0IGRhdGEgPSBwcm9ncmVzc0RhdGEuZGF0YTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmIChjb2RlID09IDApIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLl9vcHRpb25zLm9uUHJvZ3Jlc3MoZGF0YSk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNjLmxvZyhgcHJvZ3Jlc3MgZXJyb3I6ICR7Y29kZX0sICR7ZXJyQ29kZX0sJHttc2d9YCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpZiAoY2Muc3lzLmlzTmF0aXZlICYmIGNjLnN5cy5vcyA9PT0gY2Muc3lzLk9TX0FORFJPSUQpIHtcbiAgICAgICAgICAgICAgICBjb25zdCByZXN1bHRDb2RlID0ganNiLnJlZmxlY3Rpb24uY2FsbFN0YXRpY01ldGhvZCgnY29tL3RlbmNlbnQvY29jb21hdC9iaW5kaW5nL0NDTUJpbmRpbmcnLCAnZXhlY3V0ZScsICcoTGphdmEvbGFuZy9TdHJpbmc7TGphdmEvbGFuZy9TdHJpbmc7TGphdmEvbGFuZy9TdHJpbmc7KUknLFxuICAgICAgICAgICAgICAgICAgICBtZXRob2ROYW1lLCB0eXBlb2YgYXJncyA9PT0gJ29iamVjdCcgPyBKU09OLnN0cmluZ2lmeShhcmdzKSA6ICcnLCBjYk5hbWUpO1xuICAgICAgICAgICAgICAgIGlmIChyZXN1bHRDb2RlICE9PSAwKSB7XG4gICAgICAgICAgICAgICAgICAgIHN3aXRjaCAocmVzdWx0Q29kZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAtMTpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZWplY3Qoe1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiBFUlJPUl9DT0RFX01FVEhPRF9OT1RfREVGSU5FRCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbXNnOiBgJHttZXRob2ROYW1lfSBub3QgZm91bmQgb24gQW5kcm9pZCBwbGF0Zm9ybWBcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgLTI6XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmVqZWN0KHtjb2RlOiBFUlJPUl9DT0RFX1BBUkFNU19FUlJPUiwgbXNnOiBgZXJyb3IhIGludmFsaWQgcGFyYW1ldGVyc2B9KTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICAgICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmVqZWN0KHtjb2RlOiByZXN1bHRDb2RlLCBtc2c6IGBlcnJvciEgcmVzdWx0IGNvZGU9JHtyZXN1bHRDb2RlfWB9KTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICBpZiAoaGFzQ2FsbGJhY2spIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuY2xlYXJDYWxsYmFjayhjYk5hbWUsIHRpbWVvdXRJZCwgY2JQcm9ncmVzc05hbWUpO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSBlbHNlIGlmIChjYy5zeXMuaXNOYXRpdmUgJiYgY2Muc3lzLm9zID09PSBjYy5zeXMuT1NfSU9TKSB7XG4gICAgICAgICAgICAgICAgY29uc3QgcmV0SWQgPSBqc2IucmVmbGVjdGlvbi5jYWxsU3RhdGljTWV0aG9kKCdDQ01CaW5kaW5nJywgJ2V4ZWN1dGVXaXRoTWV0aG9kTmFtZTphcmdzOmNhbGxiYWNrOicsXG4gICAgICAgICAgICAgICAgICAgIG1ldGhvZE5hbWUsIHR5cGVvZiBhcmdzID09PSAnb2JqZWN0JyA/IEpTT04uc3RyaW5naWZ5KGFyZ3MpIDogJycsIGNiTmFtZSk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIGNvbnN0IG1zZyA9ICdubyBpbXBsZW1lbnRlZCBvbiB0aGlzIHBsYXRmb3JtJztcbiAgICAgICAgICAgICAgICByZWplY3Qoe2NvZGU6IEVSUk9SX0NPREVfTUVUSE9EX05PVF9ERUZJTkVELCBtc2c6IG1zZ30pO1xuICAgICAgICAgICAgICAgIHRoaXMuY2xlYXJDYWxsYmFjayhjYk5hbWUsIHRpbWVvdXRJZCwgY2JQcm9ncmVzc05hbWUpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICBwcml2YXRlIGNsZWFyQ2FsbGJhY2soY2JOYW1lOiBzdHJpbmcsIHRpbWVvdXRJZDogbnVtYmVyID0gLTEsIGNiUHJvZ3Jlc3NOYW1lID0gJycpIHtcbiAgICAgICAgaWYgKGNiUHJvZ3Jlc3NOYW1lICYmIGNiUHJvZ3Jlc3NOYW1lICE9ICcnKSB7XG4gICAgICAgICAgICBjb25zb2xlLmxvZyhgZGVsZXRlIGNiUHJvZ3Jlc3NOYW1lJHtjYk5hbWV9YCk7XG4gICAgICAgICAgICBkZWxldGUgd2luZG93W2NiUHJvZ3Jlc3NOYW1lXTtcbiAgICAgICAgfVxuICAgICAgICBpZiAoY2JOYW1lICYmIGNiTmFtZSAhPSAnJykge1xuICAgICAgICAgICAgY29uc29sZS5sb2coYGRlbGV0ZSBjYk5hbWUke2NiTmFtZX1gKTtcbiAgICAgICAgICAgIGRlbGV0ZSB3aW5kb3dbY2JOYW1lXTtcbiAgICAgICAgfVxuICAgICAgICBpZiAodGltZW91dElkID49IDApIHtcbiAgICAgICAgICAgIGNvbnNvbGUubG9nKGBjbGVhclRpbWVvdXQke2NiTmFtZX1gKTtcbiAgICAgICAgICAgIGNsZWFyVGltZW91dCh0aW1lb3V0SWQpO1xuICAgICAgICB9XG4gICAgfVxufVxuXG4iXX0=