
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/scripts/Test');
require('./coco-mat/lib/CCMBinding/CCMBinding');
require('./coco-mat/lib/CCMBinding/CCMRouter');
require('./coco-mat/lib/CCMUtils');
require('./coco-mat/lib/CCMVideo/CCMVideo');
require('./coco-mat/lib/CCMVideo/CCMVideoAssembler');
require('./coco-mat/lib/CCMlib/jszip.min');
require('./coco-mat/lib/CCMlib/md5');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMVideo/CCMVideo.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5bcb2O7tHNFYKddKtn7YOjW', 'CCMVideo');
// lib/CCMVideo/CCMVideo.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CCMVideo = exports.EventType = void 0;
var CCMVideoAssembler_1 = require("./CCMVideoAssembler");
var EventType;
(function (EventType) {
    EventType[EventType["PREPARING"] = 1] = "PREPARING";
    EventType[EventType["LOADED"] = 2] = "LOADED";
    EventType[EventType["READY"] = 3] = "READY";
    EventType[EventType["COMPLETED"] = 4] = "COMPLETED";
    EventType[EventType["ERROR"] = 5] = "ERROR";
    EventType[EventType["PLAYING"] = 6] = "PLAYING";
    EventType[EventType["PAUSED"] = 7] = "PAUSED";
    EventType[EventType["STOPPED"] = 8] = "STOPPED";
    EventType[EventType["BUFFER_START"] = 9] = "BUFFER_START";
    EventType[EventType["BUFFER_UPDATE"] = 10] = "BUFFER_UPDATE";
    EventType[EventType["BUFFER_END"] = 11] = "BUFFER_END";
})(EventType = exports.EventType || (exports.EventType = {}));
;
var VideoState;
(function (VideoState) {
    VideoState[VideoState["ERROR"] = -1] = "ERROR";
    VideoState[VideoState["IDLE"] = 0] = "IDLE";
    VideoState[VideoState["PREPARING"] = 1] = "PREPARING";
    VideoState[VideoState["PREPARED"] = 2] = "PREPARED";
    VideoState[VideoState["PLAYING"] = 3] = "PLAYING";
    VideoState[VideoState["PAUSED"] = 4] = "PAUSED";
    VideoState[VideoState["COMPLETED"] = 5] = "COMPLETED";
})(VideoState || (VideoState = {}));
;
var ReadyState;
(function (ReadyState) {
    ReadyState[ReadyState["HAVE_NOTHING"] = 0] = "HAVE_NOTHING";
    ReadyState[ReadyState["HAVE_METADATA"] = 1] = "HAVE_METADATA";
    ReadyState[ReadyState["HAVE_CURRENT_DATA"] = 2] = "HAVE_CURRENT_DATA";
    ReadyState[ReadyState["HAVE_FUTURE_DATA"] = 3] = "HAVE_FUTURE_DATA";
    ReadyState[ReadyState["HAVE_ENOUGH_DATA"] = 4] = "HAVE_ENOUGH_DATA";
})(ReadyState || (ReadyState = {}));
;
var PixelFormat;
(function (PixelFormat) {
    PixelFormat[PixelFormat["NONE"] = -1] = "NONE";
    PixelFormat[PixelFormat["I420"] = 0] = "I420";
    PixelFormat[PixelFormat["RGB"] = 2] = "RGB";
    PixelFormat[PixelFormat["NV12"] = 23] = "NV12";
    PixelFormat[PixelFormat["NV21"] = 24] = "NV21";
    PixelFormat[PixelFormat["RGBA"] = 26] = "RGBA";
})(PixelFormat || (PixelFormat = {}));
;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var gfx = cc.gfx;
var CCMVideo = /** @class */ (function (_super) {
    __extends(CCMVideo, _super);
    function CCMVideo() {
        var _this = _super.call(this) || this;
        _this.source = null;
        _this.seekTime = 0;
        _this.nativeDuration = 0;
        _this.nativeWidth = 0;
        _this.nativeHeight = 0;
        _this.currentState = VideoState.IDLE;
        _this.targetState = VideoState.IDLE;
        _this.pixelFormat = PixelFormat.RGBA;
        _this.impl = null;
        _this.textures = [];
        _this.loaded = false;
        _this.isBuffering = false;
        _this.inBackground = false;
        _this.lastPlayState = false;
        // rgb material
        _this.rgb = null;
        // rgb material
        _this.rgba = null;
        // i420 material
        _this.i420 = null;
        // nv12 material
        _this.nv12 = null;
        // nv21 material
        _this.nv21 = null;
        // loop property
        _this.loop = false;
        // video event handler for editor
        _this.videoPlayerEvent = [];
        _this.initialize();
        return _this;
    }
    Object.defineProperty(CCMVideo.prototype, "materials", {
        // hide materials property of base class
        get: function () {
            return this['_materials'];
        },
        set: function (val) {
            this['_materials'] = val;
            // @ts-ignore
            this._activateMaterial();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "clip", {
        // video resource
        get: function () {
            return this.source;
        },
        set: function (value) {
            this.source = value;
            this.updateVideoSource();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "currentTime", {
        // current position of the video which is playing
        get: function () {
            if (!this.impl)
                return 0;
            if (this.isInPlaybackState()) {
                if (CC_JSB) {
                    return this.impl.currentTime();
                }
                else {
                    return this.impl.currentTime;
                }
            }
            else {
                return this.seekTime;
            }
        },
        // seek to position
        set: function (value) {
            if (!this.impl)
                return;
            if (this.isInPlaybackState()) {
                if (CC_JSB) {
                    this.impl.seek(value);
                }
                else {
                    this.impl.currentTime = value;
                }
            }
            else {
                this.seekTime = value;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "duration", {
        // duration of the video
        get: function () {
            if (!this.impl)
                return 0;
            if (this.nativeDuration > 0)
                return this.nativeDuration;
            if (CC_JSB) {
                this.nativeDuration = this.impl.duration();
            }
            else {
                var duration = this.impl.duration;
                this.nativeDuration = isNaN(duration) ? 0 : duration;
            }
            return this.nativeDuration;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "width", {
        get: function () {
            if (!this.isInPlaybackState())
                return 0;
            if (this.nativeWidth > 0)
                return this.nativeWidth;
            if (CC_JSB) {
                this.nativeWidth = this.impl.width();
            }
            else {
                var width = this.impl.videoWidth;
                this.nativeWidth = isNaN(width) ? 0 : width;
            }
            return this.nativeWidth;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "height", {
        get: function () {
            if (!this.isInPlaybackState())
                return 0;
            if (this.nativeHeight > 0)
                return this.nativeHeight;
            if (CC_JSB) {
                this.nativeHeight = this.impl.height();
            }
            else {
                var height = this.impl.videoHeight;
                this.nativeHeight = isNaN(height) ? 0 : height;
            }
            return this.nativeHeight;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CCMVideo.prototype, "bufferPercentage", {
        // not accurate because native event is async, larger than actual percentage.
        get: function () {
            if (!this.impl)
                return 0;
            if (CC_JSB) {
                return this.impl.bufferPercentage();
            }
            else {
                return 0;
            }
        },
        enumerable: false,
        configurable: true
    });
    /**
     * override private method __preload
     */
    CCMVideo.prototype.__preload = function () {
        this.initializeMaterials();
        // @ts-ignore
        _super.prototype.__preload.call(this);
    };
    // must be called before super.__preload()
    CCMVideo.prototype.initializeMaterials = function () {
        this['_materials'] = [this.rgba];
    };
    /**
     * override private method _updateMaterial for set material properties
     */
    CCMVideo.prototype._updateMaterial = function () {
        var _this = this;
        var material = this.getMaterial(0);
        if (material) {
            material.setProperty('texture0', { getImpl: function () { return _this.textures[0]; } });
            switch (this.pixelFormat) {
                case PixelFormat.I420:
                    material.setProperty('texture2', { getImpl: function () { return _this.textures[2]; } });
                // fall through
                case PixelFormat.NV12:
                case PixelFormat.NV21:
                    material.setProperty('texture1', { getImpl: function () { return _this.textures[1]; } });
                    break;
            }
        }
        // @ts-ignore
        this.markForRender(true);
    };
    /**
     * update pixel format for android, ios, web platform, support yuv render
     */
    CCMVideo.prototype.updatePixelFormat = function () {
        var pixelFormat = CC_JSB ? this.impl.pixelFormat() : PixelFormat.RGB;
        if (this.pixelFormat == pixelFormat)
            return;
        this.pixelFormat = pixelFormat;
        switch (pixelFormat) {
            case PixelFormat.RGB:
                this.materials = [this.rgb];
                break;
            case PixelFormat.RGBA:
                this.materials = [this.rgba];
                break;
            case PixelFormat.I420:
                this.materials = [this.i420];
                break;
            case PixelFormat.NV12:
                this.materials = [this.nv12];
                break;
            case PixelFormat.NV21:
                this.materials = [this.nv21];
                break;
        }
    };
    /**
     * override private method _resetAssembler for customize video assembler
     */
    CCMVideo.prototype._resetAssembler = function () {
        // @ts-ignore
        this.setVertsDirty();
        this['_assembler'] = new CCMVideoAssembler_1.CCMVideoAssembler();
        this['_assembler'].init(this);
    };
    /**
     * initialize native video player, register video event handler
     */
    CCMVideo.prototype.initializeNative = function () {
        var _this = this;
        this.impl = new gfx.Video();
        this.textures = this.impl.getTextures();
        this.impl.addEventListener('loaded', function () { return _this.onMetaLoaded(); });
        this.impl.addEventListener('ready', function () { return _this.onReadyToPlay(); });
        this.impl.addEventListener('completed', function () { return _this.onCompleted(); });
        this.impl.addEventListener('error', function () { return _this.onError(); });
        this.impl.addEventListener('buffer_start', function () { return _this.onBufferStart(); });
        this.impl.addEventListener('buffer_update', function () { return _this.onBufferUpdate(); });
        this.impl.addEventListener('buffer_end', function () { return _this.onBufferEnd(); });
    };
    /**
     * initialize browser player, register video event handler
     */
    CCMVideo.prototype.initializeBrowser = function () {
        var _this = this;
        this.impl = document.createElement('video');
        this.impl.crossOrigin = 'anonymous';
        this.impl.autoplay = false;
        this.impl.loop = false;
        this.impl.muted = false;
        this.textures = [
            // @ts-ignore
            new cc.renderer.Texture2D(cc.renderer.device, {
                wrapS: gfx.WRAP_CLAMP,
                wrapT: gfx.WRAP_CLAMP,
                genMipmaps: false,
                premultiplyAlpha: false,
                flipY: false,
                format: gfx.TEXTURE_FMT_RGBA8
            })
        ];
        this.impl.addEventListener('loadedmetadata', function () { return _this.onMetaLoaded(); });
        this.impl.addEventListener('ended', function () { return _this.onCompleted(); });
        this.loaded = false;
        var onCanPlay = function () {
            if (_this.loaded || _this.currentState == VideoState.PLAYING)
                return;
            if (_this.impl.readyState === ReadyState.HAVE_ENOUGH_DATA ||
                _this.impl.readyState === ReadyState.HAVE_METADATA) {
                _this.impl.currentTime = 0;
                _this.loaded = true;
                _this.onReadyToPlay();
            }
        };
        this.impl.addEventListener('canplay', onCanPlay);
        this.impl.addEventListener('canplaythrough', onCanPlay);
        this.impl.addEventListener('suspend', onCanPlay);
        // @ts-ignore
        var gl = cc.renderer.device._gl;
        this.update = function (dt) {
            if (_this.isInPlaybackState()) {
                gl.bindTexture(gl.TEXTURE_2D, _this.textures[0]._glID);
                gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, _this.impl);
                // @ts-ignore
                cc.renderer.device._restoreTexture(0);
            }
        };
    };
    /**
     * initialize video player
     */
    CCMVideo.prototype.initialize = function () {
        if (CC_JSB) {
            this.initializeNative();
        }
        else {
            this.initializeBrowser();
        }
    };
    CCMVideo.prototype.onLoad = function () {
        if (this.impl) {
            this.updateVideoSource();
        }
    };
    /**
     * register game show and hide event handler
     */
    CCMVideo.prototype.onEnable = function () {
        _super.prototype.onEnable.call(this);
        cc.game.on(cc.game.EVENT_SHOW, this.onShow, this);
        cc.game.on(cc.game.EVENT_HIDE, this.onHide, this);
    };
    // unregister game show and hide event handler
    CCMVideo.prototype.onDisable = function () {
        _super.prototype.onDisable.call(this);
        cc.game.off(cc.game.EVENT_SHOW, this.onShow, this);
        cc.game.off(cc.game.EVENT_HIDE, this.onHide, this);
        this.stop();
    };
    CCMVideo.prototype.onShow = function () {
        if (!this.inBackground)
            return;
        this.inBackground = false;
        if (this.lastPlayState)
            this.resume();
    };
    CCMVideo.prototype.onHide = function () {
        if (this.inBackground)
            return;
        this.inBackground = true;
        this.lastPlayState = this.isPlaying();
        if (this.lastPlayState)
            this.pause();
    };
    CCMVideo.prototype._onPreDestroy = function () {
        if (this.impl) {
            if (CC_JSB)
                this.impl.destroy();
            this.impl = undefined;
        }
        // @ts-ignore
        _super.prototype._onPreDestroy.call(this);
    };
    /**
     * update video data source
     */
    CCMVideo.prototype.updateVideoSource = function () {
        this.seekTime = 0;
        this.nativeDuration = 0;
        this.nativeWidth = 0;
        this.nativeHeight = 0;
        this.currentState = VideoState.PREPARING;
        this.targetState = VideoState.PREPARING;
        var url = '';
        if (this.source) {
            if (typeof this.source == 'string') {
                url = this.source;
            }
            else {
                url = this.source.nativeUrl;
            }
        }
        if (url && cc.loader.md5Pipe) {
            url = cc.loader.md5Pipe.transformURL(url);
        }
        if (CC_JSB) {
            this.impl.stop();
            this.impl.setURL(url);
            this.impl.prepare();
        }
        else {
            this.loaded = false;
            this.impl.pause();
            this.impl.src = url;
        }
        this.node.emit('preparing', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PREPARING);
    };
    CCMVideo.prototype.onReadyToPlay = function () {
        this.updatePixelFormat();
        this.currentState = VideoState.PREPARED;
        if (this.seekTime > 0.1) {
            this.currentTime = this.seekTime;
        }
        this.node.emit('ready', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.READY);
        this.targetState == VideoState.PLAYING && this.play();
    };
    CCMVideo.prototype.onMetaLoaded = function () {
        this.node.emit('loaded', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.LOADED);
    };
    CCMVideo.prototype.onBufferStart = function () {
        this.isBuffering = true;
        this.node.emit('buffer_start', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.BUFFER_START);
    };
    CCMVideo.prototype.onBufferUpdate = function () {
        this.node.emit('buffer_update', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.BUFFER_UPDATE);
    };
    CCMVideo.prototype.onBufferEnd = function () {
        this.isBuffering = false;
        this.node.emit('buffer_end', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.BUFFER_END);
    };
    CCMVideo.prototype.onCompleted = function () {
        if (this.loop) {
            if (this.currentState == VideoState.PLAYING) {
                this.currentTime = 0;
                this.impl.play();
            }
        }
        else {
            this.currentState = VideoState.COMPLETED;
            this.targetState = VideoState.COMPLETED;
            this.node.emit('completed', this);
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.COMPLETED);
        }
    };
    CCMVideo.prototype.onError = function () {
        this.currentState = VideoState.ERROR;
        this.targetState = VideoState.ERROR;
        this.node.emit('error', this);
        cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.ERROR);
    };
    CCMVideo.prototype.play = function () {
        if (this.isInPlaybackState()) {
            if (this.currentState == VideoState.COMPLETED) {
                this.currentTime = 0;
            }
            if (this.currentState != VideoState.PLAYING) {
                this.impl.play();
                this.node.emit('playing', this);
                this.currentState = VideoState.PLAYING;
                this.targetState = VideoState.PLAYING;
                cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PLAYING);
            }
        }
        else {
            this.targetState = VideoState.PLAYING;
        }
    };
    CCMVideo.prototype.resume = function () {
        if (this.isInPlaybackState() && this.currentState != VideoState.PLAYING) {
            if (CC_JSB) {
                this.impl.resume();
            }
            else {
                this.impl.play();
            }
            this.node.emit('playing', this);
            this.currentState = VideoState.PLAYING;
            this.targetState = VideoState.PLAYING;
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PLAYING);
        }
        else {
            this.targetState = VideoState.PLAYING;
        }
    };
    CCMVideo.prototype.pause = function () {
        if (this.isInPlaybackState() && this.currentState != VideoState.PAUSED) {
            this.impl.pause();
            this.node.emit('paused', this);
            this.currentState = VideoState.PAUSED;
            this.targetState = VideoState.PAUSED;
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.PAUSED);
        }
        else {
            this.targetState = VideoState.PAUSED;
        }
    };
    CCMVideo.prototype.stop = function () {
        this.seekTime = 0;
        if (this.isInPlaybackState() && this.currentState != VideoState.IDLE) {
            if (CC_JSB) {
                this.impl.stop();
            }
            else {
                this.impl.pause();
                this.impl.currentTime = 0;
            }
            this.node.emit('stopped', this);
            this.currentState = VideoState.IDLE;
            this.targetState = VideoState.IDLE;
            cc.Component.EventHandler.emitEvents(this.videoPlayerEvent, this, EventType.STOPPED);
        }
        else {
            this.targetState = VideoState.IDLE;
        }
    };
    CCMVideo.prototype.clear = function () {
    };
    CCMVideo.prototype.isPlaying = function () {
        return this.currentState == VideoState.PLAYING || this.targetState == VideoState.PLAYING;
    };
    CCMVideo.prototype.isInPlaybackState = function () {
        return !!this.impl && this.currentState != VideoState.IDLE && this.currentState != VideoState.PREPARING && this.currentState != VideoState.ERROR;
    };
    __decorate([
        property({
            type: [cc.Material],
            visible: false,
            override: true,
        })
    ], CCMVideo.prototype, "materials", null);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "rgb", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "rgba", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "i420", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "nv12", void 0);
    __decorate([
        property(cc.Material)
    ], CCMVideo.prototype, "nv21", void 0);
    __decorate([
        property
    ], CCMVideo.prototype, "loop", void 0);
    __decorate([
        property([cc.Component.EventHandler])
    ], CCMVideo.prototype, "videoPlayerEvent", void 0);
    CCMVideo = __decorate([
        ccclass
    ], CCMVideo);
    return CCMVideo;
}(cc.RenderComponent));
exports.CCMVideo = CCMVideo;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMlib/md5.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}(function (process,global){
"use strict";
cc._RF.push(module, 'f235fQ4+ixNk7QK8/3d0vC4', 'md5');
// lib/CCMlib/md5.js

"use strict";

/**
 * [js-md5]{@link https://github.com/emn178/js-md5}
 *
 * @namespace md5
 * @version 0.7.3
 * @author Chen, Yi-Cyuan [emn178@gmail.com]
 * @copyright Chen, Yi-Cyuan 2014-2017
 * @license MIT
 */

/* eslint-disable */
(function () {
  'use strict';

  var ERROR = 'input is invalid type';
  var WINDOW = typeof window === 'object';
  var root = WINDOW ? window : {};

  if (root.JS_MD5_NO_WINDOW) {
    WINDOW = false;
  }

  var WEB_WORKER = !WINDOW && typeof self === 'object';
  var NODE_JS = !root.JS_MD5_NO_NODE_JS && process && typeof process === 'object' && process.versions && process.versions.node;

  if (NODE_JS) {
    root = global;
  } else if (WEB_WORKER) {
    root = self;
  }

  var COMMON_JS = !root.JS_MD5_NO_COMMON_JS && typeof module === 'object' && module.exports;
  var AMD = typeof define === 'function' && define.amd;
  var ARRAY_BUFFER = !root.JS_MD5_NO_ARRAY_BUFFER && typeof ArrayBuffer !== 'undefined';
  var HEX_CHARS = '0123456789abcdef'.split('');
  var EXTRA = [128, 32768, 8388608, -2147483648];
  var SHIFT = [0, 8, 16, 24];
  var OUTPUT_TYPES = ['hex', 'array', 'digest', 'buffer', 'arrayBuffer', 'base64'];
  var BASE64_ENCODE_CHAR = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');
  var blocks = [],
      buffer8;

  if (ARRAY_BUFFER) {
    var buffer = new ArrayBuffer(68);
    buffer8 = new Uint8Array(buffer);
    blocks = new Uint32Array(buffer);
  }

  if (root.JS_MD5_NO_NODE_JS || !Array.isArray) {
    Array.isArray = function (obj) {
      return Object.prototype.toString.call(obj) === '[object Array]';
    };
  }

  if (ARRAY_BUFFER && (root.JS_MD5_NO_ARRAY_BUFFER_IS_VIEW || !ArrayBuffer.isView)) {
    ArrayBuffer.isView = function (obj) {
      return typeof obj === 'object' && obj.buffer && obj.buffer.constructor === ArrayBuffer;
    };
  }
  /**
   * @method hex
   * @memberof md5
   * @description Output hash as hex string
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {String} Hex string
   * @example
   * md5.hex('The quick brown fox jumps over the lazy dog');
   * // equal to
   * md5('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method digest
   * @memberof md5
   * @description Output hash as bytes array
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Array} Bytes array
   * @example
   * md5.digest('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method array
   * @memberof md5
   * @description Output hash as bytes array
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Array} Bytes array
   * @example
   * md5.array('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method arrayBuffer
   * @memberof md5
   * @description Output hash as ArrayBuffer
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {ArrayBuffer} ArrayBuffer
   * @example
   * md5.arrayBuffer('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method buffer
   * @deprecated This maybe confuse with Buffer in node.js. Please use arrayBuffer instead.
   * @memberof md5
   * @description Output hash as ArrayBuffer
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {ArrayBuffer} ArrayBuffer
   * @example
   * md5.buffer('The quick brown fox jumps over the lazy dog');
   */

  /**
   * @method base64
   * @memberof md5
   * @description Output hash as base64 string
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {String} base64 string
   * @example
   * md5.base64('The quick brown fox jumps over the lazy dog');
   */


  var createOutputMethod = function createOutputMethod(outputType) {
    return function (message) {
      return new Md5(true).update(message)[outputType]();
    };
  };
  /**
   * @method create
   * @memberof md5
   * @description Create Md5 object
   * @returns {Md5} Md5 object.
   * @example
   * var hash = md5.create();
   */

  /**
   * @method update
   * @memberof md5
   * @description Create and update Md5 object
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Md5} Md5 object.
   * @example
   * var hash = md5.update('The quick brown fox jumps over the lazy dog');
   * // equal to
   * var hash = md5.create();
   * hash.update('The quick brown fox jumps over the lazy dog');
   */


  var createMethod = function createMethod() {
    var method = createOutputMethod('hex');

    if (NODE_JS) {
      method = nodeWrap(method);
    }

    method.create = function () {
      return new Md5();
    };

    method.update = function (message) {
      return method.create().update(message);
    };

    for (var i = 0; i < OUTPUT_TYPES.length; ++i) {
      var type = OUTPUT_TYPES[i];
      method[type] = createOutputMethod(type);
    }

    return method;
  };

  var nodeWrap = function nodeWrap(method) {
    var crypto = eval("require('crypto')");
    var Buffer = eval("require('buffer').Buffer");

    var nodeMethod = function nodeMethod(message) {
      if (typeof message === 'string') {
        return crypto.createHash('md5').update(message, 'utf8').digest('hex');
      } else {
        if (message === null || message === undefined) {
          throw ERROR;
        } else if (message.constructor === ArrayBuffer) {
          message = new Uint8Array(message);
        }
      }

      if (Array.isArray(message) || ArrayBuffer.isView(message) || message.constructor === Buffer) {
        return crypto.createHash('md5').update(new Buffer(message)).digest('hex');
      } else {
        return method(message);
      }
    };

    return nodeMethod;
  };
  /**
   * Md5 class
   * @class Md5
   * @description This is internal class.
   * @see {@link md5.create}
   */


  function Md5(sharedMemory) {
    if (sharedMemory) {
      blocks[0] = blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
      this.blocks = blocks;
      this.buffer8 = buffer8;
    } else {
      if (ARRAY_BUFFER) {
        var buffer = new ArrayBuffer(68);
        this.buffer8 = new Uint8Array(buffer);
        this.blocks = new Uint32Array(buffer);
      } else {
        this.blocks = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
      }
    }

    this.h0 = this.h1 = this.h2 = this.h3 = this.start = this.bytes = this.hBytes = 0;
    this.finalized = this.hashed = false;
    this.first = true;
  }
  /**
   * @method update
   * @memberof Md5
   * @instance
   * @description Update hash
   * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
   * @returns {Md5} Md5 object.
   * @see {@link md5.update}
   */


  Md5.prototype.update = function (message) {
    if (this.finalized) {
      return;
    }

    var notString,
        type = typeof message;

    if (type !== 'string') {
      if (type === 'object') {
        if (message === null) {
          throw ERROR;
        } else if (ARRAY_BUFFER && message.constructor === ArrayBuffer) {
          message = new Uint8Array(message);
        } else if (!Array.isArray(message)) {
          if (!ARRAY_BUFFER || !ArrayBuffer.isView(message)) {
            throw ERROR;
          }
        }
      } else {
        throw ERROR;
      }

      notString = true;
    }

    var code,
        index = 0,
        i,
        length = message.length,
        blocks = this.blocks;
    var buffer8 = this.buffer8;

    while (index < length) {
      if (this.hashed) {
        this.hashed = false;
        blocks[0] = blocks[16];
        blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
      }

      if (notString) {
        if (ARRAY_BUFFER) {
          for (i = this.start; index < length && i < 64; ++index) {
            buffer8[i++] = message[index];
          }
        } else {
          for (i = this.start; index < length && i < 64; ++index) {
            blocks[i >> 2] |= message[index] << SHIFT[i++ & 3];
          }
        }
      } else {
        if (ARRAY_BUFFER) {
          for (i = this.start; index < length && i < 64; ++index) {
            code = message.charCodeAt(index);

            if (code < 0x80) {
              buffer8[i++] = code;
            } else if (code < 0x800) {
              buffer8[i++] = 0xc0 | code >> 6;
              buffer8[i++] = 0x80 | code & 0x3f;
            } else if (code < 0xd800 || code >= 0xe000) {
              buffer8[i++] = 0xe0 | code >> 12;
              buffer8[i++] = 0x80 | code >> 6 & 0x3f;
              buffer8[i++] = 0x80 | code & 0x3f;
            } else {
              code = 0x10000 + ((code & 0x3ff) << 10 | message.charCodeAt(++index) & 0x3ff);
              buffer8[i++] = 0xf0 | code >> 18;
              buffer8[i++] = 0x80 | code >> 12 & 0x3f;
              buffer8[i++] = 0x80 | code >> 6 & 0x3f;
              buffer8[i++] = 0x80 | code & 0x3f;
            }
          }
        } else {
          for (i = this.start; index < length && i < 64; ++index) {
            code = message.charCodeAt(index);

            if (code < 0x80) {
              blocks[i >> 2] |= code << SHIFT[i++ & 3];
            } else if (code < 0x800) {
              blocks[i >> 2] |= (0xc0 | code >> 6) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code & 0x3f) << SHIFT[i++ & 3];
            } else if (code < 0xd800 || code >= 0xe000) {
              blocks[i >> 2] |= (0xe0 | code >> 12) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code >> 6 & 0x3f) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code & 0x3f) << SHIFT[i++ & 3];
            } else {
              code = 0x10000 + ((code & 0x3ff) << 10 | message.charCodeAt(++index) & 0x3ff);
              blocks[i >> 2] |= (0xf0 | code >> 18) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code >> 12 & 0x3f) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code >> 6 & 0x3f) << SHIFT[i++ & 3];
              blocks[i >> 2] |= (0x80 | code & 0x3f) << SHIFT[i++ & 3];
            }
          }
        }
      }

      this.lastByteIndex = i;
      this.bytes += i - this.start;

      if (i >= 64) {
        this.start = i - 64;
        this.hash();
        this.hashed = true;
      } else {
        this.start = i;
      }
    }

    if (this.bytes > 4294967295) {
      this.hBytes += this.bytes / 4294967296 << 0;
      this.bytes = this.bytes % 4294967296;
    }

    return this;
  };

  Md5.prototype.finalize = function () {
    if (this.finalized) {
      return;
    }

    this.finalized = true;
    var blocks = this.blocks,
        i = this.lastByteIndex;
    blocks[i >> 2] |= EXTRA[i & 3];

    if (i >= 56) {
      if (!this.hashed) {
        this.hash();
      }

      blocks[0] = blocks[16];
      blocks[16] = blocks[1] = blocks[2] = blocks[3] = blocks[4] = blocks[5] = blocks[6] = blocks[7] = blocks[8] = blocks[9] = blocks[10] = blocks[11] = blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
    }

    blocks[14] = this.bytes << 3;
    blocks[15] = this.hBytes << 3 | this.bytes >>> 29;
    this.hash();
  };

  Md5.prototype.hash = function () {
    var a,
        b,
        c,
        d,
        bc,
        da,
        blocks = this.blocks;

    if (this.first) {
      a = blocks[0] - 680876937;
      a = (a << 7 | a >>> 25) - 271733879 << 0;
      d = (-1732584194 ^ a & 2004318071) + blocks[1] - 117830708;
      d = (d << 12 | d >>> 20) + a << 0;
      c = (-271733879 ^ d & (a ^ -271733879)) + blocks[2] - 1126478375;
      c = (c << 17 | c >>> 15) + d << 0;
      b = (a ^ c & (d ^ a)) + blocks[3] - 1316259209;
      b = (b << 22 | b >>> 10) + c << 0;
    } else {
      a = this.h0;
      b = this.h1;
      c = this.h2;
      d = this.h3;
      a += (d ^ b & (c ^ d)) + blocks[0] - 680876936;
      a = (a << 7 | a >>> 25) + b << 0;
      d += (c ^ a & (b ^ c)) + blocks[1] - 389564586;
      d = (d << 12 | d >>> 20) + a << 0;
      c += (b ^ d & (a ^ b)) + blocks[2] + 606105819;
      c = (c << 17 | c >>> 15) + d << 0;
      b += (a ^ c & (d ^ a)) + blocks[3] - 1044525330;
      b = (b << 22 | b >>> 10) + c << 0;
    }

    a += (d ^ b & (c ^ d)) + blocks[4] - 176418897;
    a = (a << 7 | a >>> 25) + b << 0;
    d += (c ^ a & (b ^ c)) + blocks[5] + 1200080426;
    d = (d << 12 | d >>> 20) + a << 0;
    c += (b ^ d & (a ^ b)) + blocks[6] - 1473231341;
    c = (c << 17 | c >>> 15) + d << 0;
    b += (a ^ c & (d ^ a)) + blocks[7] - 45705983;
    b = (b << 22 | b >>> 10) + c << 0;
    a += (d ^ b & (c ^ d)) + blocks[8] + 1770035416;
    a = (a << 7 | a >>> 25) + b << 0;
    d += (c ^ a & (b ^ c)) + blocks[9] - 1958414417;
    d = (d << 12 | d >>> 20) + a << 0;
    c += (b ^ d & (a ^ b)) + blocks[10] - 42063;
    c = (c << 17 | c >>> 15) + d << 0;
    b += (a ^ c & (d ^ a)) + blocks[11] - 1990404162;
    b = (b << 22 | b >>> 10) + c << 0;
    a += (d ^ b & (c ^ d)) + blocks[12] + 1804603682;
    a = (a << 7 | a >>> 25) + b << 0;
    d += (c ^ a & (b ^ c)) + blocks[13] - 40341101;
    d = (d << 12 | d >>> 20) + a << 0;
    c += (b ^ d & (a ^ b)) + blocks[14] - 1502002290;
    c = (c << 17 | c >>> 15) + d << 0;
    b += (a ^ c & (d ^ a)) + blocks[15] + 1236535329;
    b = (b << 22 | b >>> 10) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[1] - 165796510;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[6] - 1069501632;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[11] + 643717713;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[0] - 373897302;
    b = (b << 20 | b >>> 12) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[5] - 701558691;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[10] + 38016083;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[15] - 660478335;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[4] - 405537848;
    b = (b << 20 | b >>> 12) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[9] + 568446438;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[14] - 1019803690;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[3] - 187363961;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[8] + 1163531501;
    b = (b << 20 | b >>> 12) + c << 0;
    a += (c ^ d & (b ^ c)) + blocks[13] - 1444681467;
    a = (a << 5 | a >>> 27) + b << 0;
    d += (b ^ c & (a ^ b)) + blocks[2] - 51403784;
    d = (d << 9 | d >>> 23) + a << 0;
    c += (a ^ b & (d ^ a)) + blocks[7] + 1735328473;
    c = (c << 14 | c >>> 18) + d << 0;
    b += (d ^ a & (c ^ d)) + blocks[12] - 1926607734;
    b = (b << 20 | b >>> 12) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[5] - 378558;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[8] - 2022574463;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[11] + 1839030562;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[14] - 35309556;
    b = (b << 23 | b >>> 9) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[1] - 1530992060;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[4] + 1272893353;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[7] - 155497632;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[10] - 1094730640;
    b = (b << 23 | b >>> 9) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[13] + 681279174;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[0] - 358537222;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[3] - 722521979;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[6] + 76029189;
    b = (b << 23 | b >>> 9) + c << 0;
    bc = b ^ c;
    a += (bc ^ d) + blocks[9] - 640364487;
    a = (a << 4 | a >>> 28) + b << 0;
    d += (bc ^ a) + blocks[12] - 421815835;
    d = (d << 11 | d >>> 21) + a << 0;
    da = d ^ a;
    c += (da ^ b) + blocks[15] + 530742520;
    c = (c << 16 | c >>> 16) + d << 0;
    b += (da ^ c) + blocks[2] - 995338651;
    b = (b << 23 | b >>> 9) + c << 0;
    a += (c ^ (b | ~d)) + blocks[0] - 198630844;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[7] + 1126891415;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[14] - 1416354905;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[5] - 57434055;
    b = (b << 21 | b >>> 11) + c << 0;
    a += (c ^ (b | ~d)) + blocks[12] + 1700485571;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[3] - 1894986606;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[10] - 1051523;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[1] - 2054922799;
    b = (b << 21 | b >>> 11) + c << 0;
    a += (c ^ (b | ~d)) + blocks[8] + 1873313359;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[15] - 30611744;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[6] - 1560198380;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[13] + 1309151649;
    b = (b << 21 | b >>> 11) + c << 0;
    a += (c ^ (b | ~d)) + blocks[4] - 145523070;
    a = (a << 6 | a >>> 26) + b << 0;
    d += (b ^ (a | ~c)) + blocks[11] - 1120210379;
    d = (d << 10 | d >>> 22) + a << 0;
    c += (a ^ (d | ~b)) + blocks[2] + 718787259;
    c = (c << 15 | c >>> 17) + d << 0;
    b += (d ^ (c | ~a)) + blocks[9] - 343485551;
    b = (b << 21 | b >>> 11) + c << 0;

    if (this.first) {
      this.h0 = a + 1732584193 << 0;
      this.h1 = b - 271733879 << 0;
      this.h2 = c - 1732584194 << 0;
      this.h3 = d + 271733878 << 0;
      this.first = false;
    } else {
      this.h0 = this.h0 + a << 0;
      this.h1 = this.h1 + b << 0;
      this.h2 = this.h2 + c << 0;
      this.h3 = this.h3 + d << 0;
    }
  };
  /**
   * @method hex
   * @memberof Md5
   * @instance
   * @description Output hash as hex string
   * @returns {String} Hex string
   * @see {@link md5.hex}
   * @example
   * hash.hex();
   */


  Md5.prototype.hex = function () {
    this.finalize();
    var h0 = this.h0,
        h1 = this.h1,
        h2 = this.h2,
        h3 = this.h3;
    return HEX_CHARS[h0 >> 4 & 0x0F] + HEX_CHARS[h0 & 0x0F] + HEX_CHARS[h0 >> 12 & 0x0F] + HEX_CHARS[h0 >> 8 & 0x0F] + HEX_CHARS[h0 >> 20 & 0x0F] + HEX_CHARS[h0 >> 16 & 0x0F] + HEX_CHARS[h0 >> 28 & 0x0F] + HEX_CHARS[h0 >> 24 & 0x0F] + HEX_CHARS[h1 >> 4 & 0x0F] + HEX_CHARS[h1 & 0x0F] + HEX_CHARS[h1 >> 12 & 0x0F] + HEX_CHARS[h1 >> 8 & 0x0F] + HEX_CHARS[h1 >> 20 & 0x0F] + HEX_CHARS[h1 >> 16 & 0x0F] + HEX_CHARS[h1 >> 28 & 0x0F] + HEX_CHARS[h1 >> 24 & 0x0F] + HEX_CHARS[h2 >> 4 & 0x0F] + HEX_CHARS[h2 & 0x0F] + HEX_CHARS[h2 >> 12 & 0x0F] + HEX_CHARS[h2 >> 8 & 0x0F] + HEX_CHARS[h2 >> 20 & 0x0F] + HEX_CHARS[h2 >> 16 & 0x0F] + HEX_CHARS[h2 >> 28 & 0x0F] + HEX_CHARS[h2 >> 24 & 0x0F] + HEX_CHARS[h3 >> 4 & 0x0F] + HEX_CHARS[h3 & 0x0F] + HEX_CHARS[h3 >> 12 & 0x0F] + HEX_CHARS[h3 >> 8 & 0x0F] + HEX_CHARS[h3 >> 20 & 0x0F] + HEX_CHARS[h3 >> 16 & 0x0F] + HEX_CHARS[h3 >> 28 & 0x0F] + HEX_CHARS[h3 >> 24 & 0x0F];
  };
  /**
   * @method toString
   * @memberof Md5
   * @instance
   * @description Output hash as hex string
   * @returns {String} Hex string
   * @see {@link md5.hex}
   * @example
   * hash.toString();
   */


  Md5.prototype.toString = Md5.prototype.hex;
  /**
   * @method digest
   * @memberof Md5
   * @instance
   * @description Output hash as bytes array
   * @returns {Array} Bytes array
   * @see {@link md5.digest}
   * @example
   * hash.digest();
   */

  Md5.prototype.digest = function () {
    this.finalize();
    var h0 = this.h0,
        h1 = this.h1,
        h2 = this.h2,
        h3 = this.h3;
    return [h0 & 0xFF, h0 >> 8 & 0xFF, h0 >> 16 & 0xFF, h0 >> 24 & 0xFF, h1 & 0xFF, h1 >> 8 & 0xFF, h1 >> 16 & 0xFF, h1 >> 24 & 0xFF, h2 & 0xFF, h2 >> 8 & 0xFF, h2 >> 16 & 0xFF, h2 >> 24 & 0xFF, h3 & 0xFF, h3 >> 8 & 0xFF, h3 >> 16 & 0xFF, h3 >> 24 & 0xFF];
  };
  /**
   * @method array
   * @memberof Md5
   * @instance
   * @description Output hash as bytes array
   * @returns {Array} Bytes array
   * @see {@link md5.array}
   * @example
   * hash.array();
   */


  Md5.prototype.array = Md5.prototype.digest;
  /**
   * @method arrayBuffer
   * @memberof Md5
   * @instance
   * @description Output hash as ArrayBuffer
   * @returns {ArrayBuffer} ArrayBuffer
   * @see {@link md5.arrayBuffer}
   * @example
   * hash.arrayBuffer();
   */

  Md5.prototype.arrayBuffer = function () {
    this.finalize();
    var buffer = new ArrayBuffer(16);
    var blocks = new Uint32Array(buffer);
    blocks[0] = this.h0;
    blocks[1] = this.h1;
    blocks[2] = this.h2;
    blocks[3] = this.h3;
    return buffer;
  };
  /**
   * @method buffer
   * @deprecated This maybe confuse with Buffer in node.js. Please use arrayBuffer instead.
   * @memberof Md5
   * @instance
   * @description Output hash as ArrayBuffer
   * @returns {ArrayBuffer} ArrayBuffer
   * @see {@link md5.buffer}
   * @example
   * hash.buffer();
   */


  Md5.prototype.buffer = Md5.prototype.arrayBuffer;
  /**
   * @method base64
   * @memberof Md5
   * @instance
   * @description Output hash as base64 string
   * @returns {String} base64 string
   * @see {@link md5.base64}
   * @example
   * hash.base64();
   */

  Md5.prototype.base64 = function () {
    var v1,
        v2,
        v3,
        base64Str = '',
        bytes = this.array();

    for (var i = 0; i < 15;) {
      v1 = bytes[i++];
      v2 = bytes[i++];
      v3 = bytes[i++];
      base64Str += BASE64_ENCODE_CHAR[v1 >>> 2] + BASE64_ENCODE_CHAR[(v1 << 4 | v2 >>> 4) & 63] + BASE64_ENCODE_CHAR[(v2 << 2 | v3 >>> 6) & 63] + BASE64_ENCODE_CHAR[v3 & 63];
    }

    v1 = bytes[i];
    base64Str += BASE64_ENCODE_CHAR[v1 >>> 2] + BASE64_ENCODE_CHAR[v1 << 4 & 63] + '==';
    return base64Str;
  };

  var exports = createMethod();

  if (COMMON_JS) {
    module.exports = exports;
  } else {
    /**
     * @method md5
     * @description Md5 hash function, export to global in browsers.
     * @param {String|Array|Uint8Array|ArrayBuffer} message message to hash
     * @returns {String} md5 hashes
     * @example
     * md5(''); // d41d8cd98f00b204e9800998ecf8427e
     * md5('The quick brown fox jumps over the lazy dog'); // 9e107d9d372bb6826bd81d3542a419d6
     * md5('The quick brown fox jumps over the lazy dog.'); // e4d909c290d0fb1ca068ffaddf22cbd0
     *
     * // It also supports UTF-8 encoding
     * md5('中文'); // a7bac2239fcdcb3a067903d8077c4a07
     *
     * // It also supports byte `Array`, `Uint8Array`, `ArrayBuffer`
     * md5([]); // d41d8cd98f00b204e9800998ecf8427e
     * md5(new Uint8Array([])); // d41d8cd98f00b204e9800998ecf8427e
     */
    root.md5 = exports;

    if (AMD) {
      define(function () {
        return exports;
      });
    }
  }
})();

cc._RF.pop();

}).call(this,require("../../../../../../../../../../../../Applications/CocosCreator/Creator/2.4.11/CocosCreator.app/Contents/Resources/app.asar/node_modules/process/browser.js"),typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMBinding/CCMRouter.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0cac4WEByFBWavsOGLakGqf', 'CCMRouter');
// lib/CCMBinding/CCMRouter.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 路由方法，可以注册方法供别的模块,或者是native主动发起调用
 */
var CCMBinding_1 = require("./CCMBinding");
var TAG = 'CCMRouter';
var CCMRouter = /** @class */ (function () {
    function CCMRouter() {
        this.methodMap = new Map();
    }
    CCMRouter.callMethod = function (methodName, args) {
        return this.Instance.callMethod(methodName, args);
    };
    CCMRouter.registerMethod = function (methodName, callback) {
        return this.Instance.registerMethod(methodName, callback);
    };
    CCMRouter.unRegisterMethod = function (eventName) {
        return this.Instance.unRegisterMethod(eventName);
    };
    Object.defineProperty(CCMRouter, "Instance", {
        get: function () {
            if (!this.instance) {
                this.instance = new CCMRouter();
            }
            return this.instance;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 自定义事件处理者
     */
    CCMRouter.prototype.registerMethod = function (eventName, callback) {
        var _this = this;
        this.methodMap.set(eventName, callback);
        window["ccmbinding_router_" + eventName] = function (args) {
            cc.log(TAG, 'called eventName' + eventName);
            return _this.callMethod(eventName, args).then().catch();
        };
    };
    CCMRouter.prototype.unRegisterMethod = function (eventName) {
        this.methodMap.delete(eventName);
        delete window["ccmbinding_router_" + eventName];
    };
    CCMRouter.prototype.callMethod = function (methodName, args) {
        var method = this.methodMap.get(methodName);
        if (method) {
            var data = args['data'];
            var exeResult = method.call(this, data);
            // 如果是在native环境下，则需要把结果返回到native中。
            if (cc.sys.isNative && typeof exeResult === 'object') {
                if (exeResult instanceof Promise) {
                    exeResult.then(function (result) {
                        cc.log('start call native from ts');
                        var callbackName = args['@nativeCallbackName'];
                        CCMBinding_1.default.withOptions({ hasCallback: false }).callNativeMethod(callbackName, result)
                            .then(function (rs) {
                            cc.log('receive:', rs);
                        }).catch(function (e) {
                            cc.log('exception:', e);
                        });
                    });
                }
                else {
                    cc.log('start call native from ts');
                    var callbackName = args['@nativeCallbackName'];
                    CCMBinding_1.default.withOptions({ hasCallback: false }).callNativeMethod(callbackName, exeResult)
                        .then(function (rs) {
                        cc.log('receive:', rs);
                    }).catch(function (e) {
                        cc.log('exception:', e);
                    });
                }
            }
            return Promise.resolve(exeResult);
        }
        else {
            return Promise.reject({ code: -1, msg: methodName + " not register" });
        }
    };
    return CCMRouter;
}());
exports.default = CCMRouter;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/Test.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '494386vPatLZJaqSOrJDD8d', 'Test');
// scripts/Test.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var CCMVideo_1 = require("../../coco-mat/lib/CCMVideo/CCMVideo");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Test = /** @class */ (function (_super) {
    __extends(Test, _super);
    function Test() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.video = null;
        _this.videoAsset = null;
        return _this;
        // update (dt) {}
    }
    // onLoad () {}
    Test.prototype.start = function () {
        this.video.clip = this.videoAsset;
        this.video.play();
    };
    Test.prototype.play = function () {
        this.video.play();
    };
    __decorate([
        property(CCMVideo_1.CCMVideo)
    ], Test.prototype, "video", void 0);
    __decorate([
        property(cc.Asset)
    ], Test.prototype, "videoAsset", void 0);
    Test = __decorate([
        ccclass
    ], Test);
    return Test;
}(cc.Component));
exports.default = Test;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9zY3JpcHRzL1Rlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQUEsaUVBQWdFO0FBRTFELElBQUEsS0FBd0IsRUFBRSxDQUFDLFVBQVUsRUFBbkMsT0FBTyxhQUFBLEVBQUUsUUFBUSxjQUFrQixDQUFDO0FBRzVDO0lBQWtDLHdCQUFZO0lBQTlDO1FBQUEscUVBcUJDO1FBbEJHLFdBQUssR0FBYSxJQUFJLENBQUM7UUFHdkIsZ0JBQVUsR0FBYSxJQUFJLENBQUM7O1FBYzVCLGlCQUFpQjtJQUNyQixDQUFDO0lBYkcsZUFBZTtJQUVmLG9CQUFLLEdBQUw7UUFFSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDO1FBQ2xDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDdEIsQ0FBQztJQUVELG1CQUFJLEdBQUo7UUFDSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ3RCLENBQUM7SUFmRDtRQURDLFFBQVEsQ0FBQyxtQkFBUSxDQUFDO3VDQUNJO0lBR3ZCO1FBREMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUM7NENBQ1M7SUFOWCxJQUFJO1FBRHhCLE9BQU87T0FDYSxJQUFJLENBcUJ4QjtJQUFELFdBQUM7Q0FyQkQsQUFxQkMsQ0FyQmlDLEVBQUUsQ0FBQyxTQUFTLEdBcUI3QztrQkFyQm9CLElBQUkiLCJmaWxlIjoiIiwic291cmNlUm9vdCI6Ii8iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDQ01WaWRlbyB9IGZyb20gXCIuLi8uLi9jb2NvLW1hdC9saWIvQ0NNVmlkZW8vQ0NNVmlkZW9cIjtcblxuY29uc3QgeyBjY2NsYXNzLCBwcm9wZXJ0eSB9ID0gY2MuX2RlY29yYXRvcjtcblxuQGNjY2xhc3NcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFRlc3QgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuXG4gICAgQHByb3BlcnR5KENDTVZpZGVvKVxuICAgIHZpZGVvOiBDQ01WaWRlbyA9IG51bGw7XG5cbiAgICBAcHJvcGVydHkoY2MuQXNzZXQpXG4gICAgdmlkZW9Bc3NldDogY2MuQXNzZXQgPSBudWxsO1xuXG4gICAgLy8gb25Mb2FkICgpIHt9XG5cbiAgICBzdGFydCgpIHtcblxuICAgICAgICB0aGlzLnZpZGVvLmNsaXAgPSB0aGlzLnZpZGVvQXNzZXQ7XG4gICAgICAgIHRoaXMudmlkZW8ucGxheSgpO1xuICAgIH1cblxuICAgIHBsYXkoKSB7XG4gICAgICAgIHRoaXMudmlkZW8ucGxheSgpO1xuICAgIH1cblxuICAgIC8vIHVwZGF0ZSAoZHQpIHt9XG59XG4iXX0=
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMlib/jszip.min.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}(function (global,Buffer){
"use strict";
cc._RF.push(module, 'a17d4/BAjtERatq0fQAXobP', 'jszip.min');
// lib/CCMlib/jszip.min.js

"use strict";

/*!

JSZip v3.6.0 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/master/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/master/LICENSE
*/
!function (e) {
  if ("object" == typeof exports && "undefined" != typeof module) module.exports = e();else if ("function" == typeof define && define.amd) define([], e);else {
    ("undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : this).JSZip = e();
  }
}(function () {
  return function s(a, o, u) {
    function h(r, e) {
      if (!o[r]) {
        if (!a[r]) {
          var t = "function" == typeof require && require;
          if (!e && t) return t(r, !0);
          if (f) return f(r, !0);
          var n = new Error("Cannot find module '" + r + "'");
          throw n.code = "MODULE_NOT_FOUND", n;
        }

        var i = o[r] = {
          exports: {}
        };
        a[r][0].call(i.exports, function (e) {
          var t = a[r][1][e];
          return h(t || e);
        }, i, i.exports, s, a, o, u);
      }

      return o[r].exports;
    }

    for (var f = "function" == typeof require && require, e = 0; e < u.length; e++) {
      h(u[e]);
    }

    return h;
  }({
    1: [function (l, t, n) {
      (function (r) {
        !function (e) {
          "object" == typeof n && void 0 !== t ? t.exports = e() : ("undefined" != typeof window ? window : void 0 !== r ? r : "undefined" != typeof self ? self : this).JSZip = e();
        }(function () {
          return function s(a, o, u) {
            function h(t, e) {
              if (!o[t]) {
                if (!a[t]) {
                  var r = "function" == typeof l && l;
                  if (!e && r) return r(t, !0);
                  if (f) return f(t, !0);
                  var n = new Error("Cannot find module '" + t + "'");
                  throw n.code = "MODULE_NOT_FOUND", n;
                }

                var i = o[t] = {
                  exports: {}
                };
                a[t][0].call(i.exports, function (e) {
                  return h(a[t][1][e] || e);
                }, i, i.exports, s, a, o, u);
              }

              return o[t].exports;
            }

            for (var f = "function" == typeof l && l, e = 0; e < u.length; e++) {
              h(u[e]);
            }

            return h;
          }({
            1: [function (l, t, n) {
              (function (r) {
                !function (e) {
                  "object" == typeof n && void 0 !== t ? t.exports = e() : ("undefined" != typeof window ? window : void 0 !== r ? r : "undefined" != typeof self ? self : this).JSZip = e();
                }(function () {
                  return function s(a, o, u) {
                    function h(t, e) {
                      if (!o[t]) {
                        if (!a[t]) {
                          var r = "function" == typeof l && l;
                          if (!e && r) return r(t, !0);
                          if (f) return f(t, !0);
                          var n = new Error("Cannot find module '" + t + "'");
                          throw n.code = "MODULE_NOT_FOUND", n;
                        }

                        var i = o[t] = {
                          exports: {}
                        };
                        a[t][0].call(i.exports, function (e) {
                          return h(a[t][1][e] || e);
                        }, i, i.exports, s, a, o, u);
                      }

                      return o[t].exports;
                    }

                    for (var f = "function" == typeof l && l, e = 0; e < u.length; e++) {
                      h(u[e]);
                    }

                    return h;
                  }({
                    1: [function (l, t, n) {
                      (function (r) {
                        !function (e) {
                          "object" == typeof n && void 0 !== t ? t.exports = e() : ("undefined" != typeof window ? window : void 0 !== r ? r : "undefined" != typeof self ? self : this).JSZip = e();
                        }(function () {
                          return function s(a, o, u) {
                            function h(t, e) {
                              if (!o[t]) {
                                if (!a[t]) {
                                  var r = "function" == typeof l && l;
                                  if (!e && r) return r(t, !0);
                                  if (f) return f(t, !0);
                                  var n = new Error("Cannot find module '" + t + "'");
                                  throw n.code = "MODULE_NOT_FOUND", n;
                                }

                                var i = o[t] = {
                                  exports: {}
                                };
                                a[t][0].call(i.exports, function (e) {
                                  return h(a[t][1][e] || e);
                                }, i, i.exports, s, a, o, u);
                              }

                              return o[t].exports;
                            }

                            for (var f = "function" == typeof l && l, e = 0; e < u.length; e++) {
                              h(u[e]);
                            }

                            return h;
                          }({
                            1: [function (l, t, n) {
                              (function (r) {
                                !function (e) {
                                  "object" == typeof n && void 0 !== t ? t.exports = e() : ("undefined" != typeof window ? window : void 0 !== r ? r : "undefined" != typeof self ? self : this).JSZip = e();
                                }(function () {
                                  return function s(a, o, u) {
                                    function h(t, e) {
                                      if (!o[t]) {
                                        if (!a[t]) {
                                          var r = "function" == typeof l && l;
                                          if (!e && r) return r(t, !0);
                                          if (f) return f(t, !0);
                                          var n = new Error("Cannot find module '" + t + "'");
                                          throw n.code = "MODULE_NOT_FOUND", n;
                                        }

                                        var i = o[t] = {
                                          exports: {}
                                        };
                                        a[t][0].call(i.exports, function (e) {
                                          return h(a[t][1][e] || e);
                                        }, i, i.exports, s, a, o, u);
                                      }

                                      return o[t].exports;
                                    }

                                    for (var f = "function" == typeof l && l, e = 0; e < u.length; e++) {
                                      h(u[e]);
                                    }

                                    return h;
                                  }({
                                    1: [function (l, t, n) {
                                      (function (r) {
                                        !function (e) {
                                          "object" == typeof n && void 0 !== t ? t.exports = e() : ("undefined" != typeof window ? window : void 0 !== r ? r : "undefined" != typeof self ? self : this).JSZip = e();
                                        }(function () {
                                          return function s(a, o, u) {
                                            function h(t, e) {
                                              if (!o[t]) {
                                                if (!a[t]) {
                                                  var r = "function" == typeof l && l;
                                                  if (!e && r) return r(t, !0);
                                                  if (f) return f(t, !0);
                                                  var n = new Error("Cannot find module '" + t + "'");
                                                  throw n.code = "MODULE_NOT_FOUND", n;
                                                }

                                                var i = o[t] = {
                                                  exports: {}
                                                };
                                                a[t][0].call(i.exports, function (e) {
                                                  return h(a[t][1][e] || e);
                                                }, i, i.exports, s, a, o, u);
                                              }

                                              return o[t].exports;
                                            }

                                            for (var f = "function" == typeof l && l, e = 0; e < u.length; e++) {
                                              h(u[e]);
                                            }

                                            return h;
                                          }({
                                            1: [function (e, t, r) {
                                              "use strict";

                                              var c = e("./utils"),
                                                  l = e("./support"),
                                                  p = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
                                              r.encode = function (e) {
                                                for (var t, r, n, i, s, a, o, u = [], h = 0, f = e.length, l = f, d = "string" !== c.getTypeOf(e); h < e.length;) {
                                                  l = f - h, n = d ? (t = e[h++], r = h < f ? e[h++] : 0, h < f ? e[h++] : 0) : (t = e.charCodeAt(h++), r = h < f ? e.charCodeAt(h++) : 0, h < f ? e.charCodeAt(h++) : 0), i = t >> 2, s = (3 & t) << 4 | r >> 4, a = 1 < l ? (15 & r) << 2 | n >> 6 : 64, o = 2 < l ? 63 & n : 64, u.push(p.charAt(i) + p.charAt(s) + p.charAt(a) + p.charAt(o));
                                                }

                                                return u.join("");
                                              }, r.decode = function (e) {
                                                var t,
                                                    r,
                                                    n,
                                                    i,
                                                    s,
                                                    a,
                                                    o = 0,
                                                    u = 0;
                                                if ("data:" === e.substr(0, "data:".length)) throw new Error("Invalid base64 input, it looks like a data url.");
                                                var h,
                                                    f = 3 * (e = e.replace(/[^A-Za-z0-9\+\/\=]/g, "")).length / 4;
                                                if (e.charAt(e.length - 1) === p.charAt(64) && f--, e.charAt(e.length - 2) === p.charAt(64) && f--, f % 1 != 0) throw new Error("Invalid base64 input, bad content length.");

                                                for (h = l.uint8array ? new Uint8Array(0 | f) : new Array(0 | f); o < e.length;) {
                                                  t = p.indexOf(e.charAt(o++)) << 2 | (i = p.indexOf(e.charAt(o++))) >> 4, r = (15 & i) << 4 | (s = p.indexOf(e.charAt(o++))) >> 2, n = (3 & s) << 6 | (a = p.indexOf(e.charAt(o++))), h[u++] = t, 64 !== s && (h[u++] = r), 64 !== a && (h[u++] = n);
                                                }

                                                return h;
                                              };
                                            }, {
                                              "./support": 30,
                                              "./utils": 32
                                            }],
                                            2: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./external"),
                                                  i = e("./stream/DataWorker"),
                                                  s = e("./stream/Crc32Probe"),
                                                  a = e("./stream/DataLengthProbe");

                                              function o(e, t, r, n, i) {
                                                this.compressedSize = e, this.uncompressedSize = t, this.crc32 = r, this.compression = n, this.compressedContent = i;
                                              }

                                              o.prototype = {
                                                getContentWorker: function getContentWorker() {
                                                  var e = new i(n.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new a("data_length")),
                                                      t = this;
                                                  return e.on("end", function () {
                                                    if (this.streamInfo.data_length !== t.uncompressedSize) throw new Error("Bug : uncompressed data size mismatch");
                                                  }), e;
                                                },
                                                getCompressedWorker: function getCompressedWorker() {
                                                  return new i(n.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize", this.compressedSize).withStreamInfo("uncompressedSize", this.uncompressedSize).withStreamInfo("crc32", this.crc32).withStreamInfo("compression", this.compression);
                                                }
                                              }, o.createWorkerFrom = function (e, t, r) {
                                                return e.pipe(new s()).pipe(new a("uncompressedSize")).pipe(t.compressWorker(r)).pipe(new a("compressedSize")).withStreamInfo("compression", t);
                                              }, t.exports = o;
                                            }, {
                                              "./external": 6,
                                              "./stream/Crc32Probe": 25,
                                              "./stream/DataLengthProbe": 26,
                                              "./stream/DataWorker": 27
                                            }],
                                            3: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./stream/GenericWorker");
                                              r.STORE = {
                                                magic: "\0\0",
                                                compressWorker: function compressWorker(e) {
                                                  return new n("STORE compression");
                                                },
                                                uncompressWorker: function uncompressWorker() {
                                                  return new n("STORE decompression");
                                                }
                                              }, r.DEFLATE = e("./flate");
                                            }, {
                                              "./flate": 7,
                                              "./stream/GenericWorker": 28
                                            }],
                                            4: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./utils"),
                                                  a = function () {
                                                for (var e, t = [], r = 0; r < 256; r++) {
                                                  e = r;

                                                  for (var n = 0; n < 8; n++) {
                                                    e = 1 & e ? 3988292384 ^ e >>> 1 : e >>> 1;
                                                  }

                                                  t[r] = e;
                                                }

                                                return t;
                                              }();

                                              t.exports = function (e, t) {
                                                return void 0 !== e && e.length ? "string" !== n.getTypeOf(e) ? function (e, t, r) {
                                                  var n = a,
                                                      i = 0 + r;
                                                  e ^= -1;

                                                  for (var s = 0; s < i; s++) {
                                                    e = e >>> 8 ^ n[255 & (e ^ t[s])];
                                                  }

                                                  return -1 ^ e;
                                                }(0 | t, e, e.length) : function (e, t, r) {
                                                  var n = a,
                                                      i = 0 + r;
                                                  e ^= -1;

                                                  for (var s = 0; s < i; s++) {
                                                    e = e >>> 8 ^ n[255 & (e ^ t.charCodeAt(s))];
                                                  }

                                                  return -1 ^ e;
                                                }(0 | t, e, e.length) : 0;
                                              };
                                            }, {
                                              "./utils": 32
                                            }],
                                            5: [function (e, t, r) {
                                              "use strict";

                                              r.base64 = !1, r.binary = !1, r.dir = !1, r.createFolders = !0, r.date = null, r.compression = null, r.compressionOptions = null, r.comment = null, r.unixPermissions = null, r.dosPermissions = null;
                                            }, {}],
                                            6: [function (e, t, r) {
                                              "use strict";

                                              var n;
                                              n = "undefined" != typeof Promise ? Promise : e("lie"), t.exports = {
                                                Promise: n
                                              };
                                            }, {
                                              lie: 37
                                            }],
                                            7: [function (e, t, r) {
                                              "use strict";

                                              var n = "undefined" != typeof Uint8Array && "undefined" != typeof Uint16Array && "undefined" != typeof Uint32Array,
                                                  i = e("pako"),
                                                  s = e("./utils"),
                                                  a = e("./stream/GenericWorker"),
                                                  o = n ? "uint8array" : "array";

                                              function u(e, t) {
                                                a.call(this, "FlateWorker/" + e), this._pako = null, this._pakoAction = e, this._pakoOptions = t, this.meta = {};
                                              }

                                              r.magic = "\b\0", s.inherits(u, a), u.prototype.processChunk = function (e) {
                                                this.meta = e.meta, null === this._pako && this._createPako(), this._pako.push(s.transformTo(o, e.data), !1);
                                              }, u.prototype.flush = function () {
                                                a.prototype.flush.call(this), null === this._pako && this._createPako(), this._pako.push([], !0);
                                              }, u.prototype.cleanUp = function () {
                                                a.prototype.cleanUp.call(this), this._pako = null;
                                              }, u.prototype._createPako = function () {
                                                this._pako = new i[this._pakoAction]({
                                                  raw: !0,
                                                  level: this._pakoOptions.level || -1
                                                });
                                                var t = this;

                                                this._pako.onData = function (e) {
                                                  t.push({
                                                    data: e,
                                                    meta: t.meta
                                                  });
                                                };
                                              }, r.compressWorker = function (e) {
                                                return new u("Deflate", e);
                                              }, r.uncompressWorker = function () {
                                                return new u("Inflate", {});
                                              };
                                            }, {
                                              "./stream/GenericWorker": 28,
                                              "./utils": 32,
                                              pako: 38
                                            }],
                                            8: [function (e, t, r) {
                                              "use strict";

                                              function I(e, t) {
                                                var r,
                                                    n = "";

                                                for (r = 0; r < t; r++) {
                                                  n += String.fromCharCode(255 & e), e >>>= 8;
                                                }

                                                return n;
                                              }

                                              function i(e, t, r, n, i, s) {
                                                var a,
                                                    o,
                                                    u = e.file,
                                                    h = e.compression,
                                                    f = s !== B.utf8encode,
                                                    l = O.transformTo("string", s(u.name)),
                                                    d = O.transformTo("string", B.utf8encode(u.name)),
                                                    c = u.comment,
                                                    p = O.transformTo("string", s(c)),
                                                    m = O.transformTo("string", B.utf8encode(c)),
                                                    _ = d.length !== u.name.length,
                                                    g = m.length !== c.length,
                                                    v = "",
                                                    b = "",
                                                    w = "",
                                                    y = u.dir,
                                                    k = u.date,
                                                    x = {
                                                  crc32: 0,
                                                  compressedSize: 0,
                                                  uncompressedSize: 0
                                                };

                                                t && !r || (x.crc32 = e.crc32, x.compressedSize = e.compressedSize, x.uncompressedSize = e.uncompressedSize);
                                                var S = 0;
                                                t && (S |= 8), f || !_ && !g || (S |= 2048);
                                                var z,
                                                    E = 0,
                                                    C = 0;
                                                y && (E |= 16), "UNIX" === i ? (C = 798, E |= ((z = u.unixPermissions) || (z = y ? 16893 : 33204), (65535 & z) << 16)) : (C = 20, E |= 63 & (u.dosPermissions || 0)), a = k.getUTCHours(), a <<= 6, a |= k.getUTCMinutes(), a <<= 5, a |= k.getUTCSeconds() / 2, o = k.getUTCFullYear() - 1980, o <<= 4, o |= k.getUTCMonth() + 1, o <<= 5, o |= k.getUTCDate(), _ && (v += "up" + I((b = I(1, 1) + I(T(l), 4) + d).length, 2) + b), g && (v += "uc" + I((w = I(1, 1) + I(T(p), 4) + m).length, 2) + w);
                                                var A = "";
                                                return A += "\n\0", A += I(S, 2), A += h.magic, A += I(a, 2), A += I(o, 2), A += I(x.crc32, 4), A += I(x.compressedSize, 4), A += I(x.uncompressedSize, 4), A += I(l.length, 2), A += I(v.length, 2), {
                                                  fileRecord: R.LOCAL_FILE_HEADER + A + l + v,
                                                  dirRecord: R.CENTRAL_FILE_HEADER + I(C, 2) + A + I(p.length, 2) + "\0\0\0\0" + I(E, 4) + I(n, 4) + l + v + p
                                                };
                                              }

                                              var O = e("../utils"),
                                                  s = e("../stream/GenericWorker"),
                                                  B = e("../utf8"),
                                                  T = e("../crc32"),
                                                  R = e("../signature");

                                              function n(e, t, r, n) {
                                                s.call(this, "ZipFileWorker"), this.bytesWritten = 0, this.zipComment = t, this.zipPlatform = r, this.encodeFileName = n, this.streamFiles = e, this.accumulate = !1, this.contentBuffer = [], this.dirRecords = [], this.currentSourceOffset = 0, this.entriesCount = 0, this.currentFile = null, this._sources = [];
                                              }

                                              O.inherits(n, s), n.prototype.push = function (e) {
                                                var t = e.meta.percent || 0,
                                                    r = this.entriesCount,
                                                    n = this._sources.length;
                                                this.accumulate ? this.contentBuffer.push(e) : (this.bytesWritten += e.data.length, s.prototype.push.call(this, {
                                                  data: e.data,
                                                  meta: {
                                                    currentFile: this.currentFile,
                                                    percent: r ? (t + 100 * (r - n - 1)) / r : 100
                                                  }
                                                }));
                                              }, n.prototype.openedSource = function (e) {
                                                this.currentSourceOffset = this.bytesWritten, this.currentFile = e.file.name;
                                                var t = this.streamFiles && !e.file.dir;

                                                if (t) {
                                                  var r = i(e, t, !1, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
                                                  this.push({
                                                    data: r.fileRecord,
                                                    meta: {
                                                      percent: 0
                                                    }
                                                  });
                                                } else this.accumulate = !0;
                                              }, n.prototype.closedSource = function (e) {
                                                this.accumulate = !1;
                                                var t,
                                                    r = this.streamFiles && !e.file.dir,
                                                    n = i(e, r, !0, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
                                                if (this.dirRecords.push(n.dirRecord), r) this.push({
                                                  data: (t = e, R.DATA_DESCRIPTOR + I(t.crc32, 4) + I(t.compressedSize, 4) + I(t.uncompressedSize, 4)),
                                                  meta: {
                                                    percent: 100
                                                  }
                                                });else for (this.push({
                                                  data: n.fileRecord,
                                                  meta: {
                                                    percent: 0
                                                  }
                                                }); this.contentBuffer.length;) {
                                                  this.push(this.contentBuffer.shift());
                                                }
                                                this.currentFile = null;
                                              }, n.prototype.flush = function () {
                                                for (var e = this.bytesWritten, t = 0; t < this.dirRecords.length; t++) {
                                                  this.push({
                                                    data: this.dirRecords[t],
                                                    meta: {
                                                      percent: 100
                                                    }
                                                  });
                                                }

                                                var r,
                                                    n,
                                                    i,
                                                    s,
                                                    a,
                                                    o,
                                                    u = this.bytesWritten - e,
                                                    h = (r = this.dirRecords.length, n = u, i = e, s = this.zipComment, a = this.encodeFileName, o = O.transformTo("string", a(s)), R.CENTRAL_DIRECTORY_END + "\0\0\0\0" + I(r, 2) + I(r, 2) + I(n, 4) + I(i, 4) + I(o.length, 2) + o);
                                                this.push({
                                                  data: h,
                                                  meta: {
                                                    percent: 100
                                                  }
                                                });
                                              }, n.prototype.prepareNextSource = function () {
                                                this.previous = this._sources.shift(), this.openedSource(this.previous.streamInfo), this.isPaused ? this.previous.pause() : this.previous.resume();
                                              }, n.prototype.registerPrevious = function (e) {
                                                this._sources.push(e);

                                                var t = this;
                                                return e.on("data", function (e) {
                                                  t.processChunk(e);
                                                }), e.on("end", function () {
                                                  t.closedSource(t.previous.streamInfo), t._sources.length ? t.prepareNextSource() : t.end();
                                                }), e.on("error", function (e) {
                                                  t.error(e);
                                                }), this;
                                              }, n.prototype.resume = function () {
                                                return !!s.prototype.resume.call(this) && (!this.previous && this._sources.length ? (this.prepareNextSource(), !0) : this.previous || this._sources.length || this.generatedError ? void 0 : (this.end(), !0));
                                              }, n.prototype.error = function (e) {
                                                var t = this._sources;
                                                if (!s.prototype.error.call(this, e)) return !1;

                                                for (var r = 0; r < t.length; r++) {
                                                  try {
                                                    t[r].error(e);
                                                  } catch (e) {}
                                                }

                                                return !0;
                                              }, n.prototype.lock = function () {
                                                s.prototype.lock.call(this);

                                                for (var e = this._sources, t = 0; t < e.length; t++) {
                                                  e[t].lock();
                                                }
                                              }, t.exports = n;
                                            }, {
                                              "../crc32": 4,
                                              "../signature": 23,
                                              "../stream/GenericWorker": 28,
                                              "../utf8": 31,
                                              "../utils": 32
                                            }],
                                            9: [function (e, t, r) {
                                              "use strict";

                                              var h = e("../compressions"),
                                                  n = e("./ZipFileWorker");

                                              r.generateWorker = function (e, a, t) {
                                                var o = new n(a.streamFiles, t, a.platform, a.encodeFileName),
                                                    u = 0;

                                                try {
                                                  e.forEach(function (e, t) {
                                                    u++;

                                                    var r = function (e, t) {
                                                      var r = e || t,
                                                          n = h[r];
                                                      if (!n) throw new Error(r + " is not a valid compression method !");
                                                      return n;
                                                    }(t.options.compression, a.compression),
                                                        n = t.options.compressionOptions || a.compressionOptions || {},
                                                        i = t.dir,
                                                        s = t.date;

                                                    t._compressWorker(r, n).withStreamInfo("file", {
                                                      name: e,
                                                      dir: i,
                                                      date: s,
                                                      comment: t.comment || "",
                                                      unixPermissions: t.unixPermissions,
                                                      dosPermissions: t.dosPermissions
                                                    }).pipe(o);
                                                  }), o.entriesCount = u;
                                                } catch (e) {
                                                  o.error(e);
                                                }

                                                return o;
                                              };
                                            }, {
                                              "../compressions": 3,
                                              "./ZipFileWorker": 8
                                            }],
                                            10: [function (e, t, r) {
                                              "use strict";

                                              function n() {
                                                if (!(this instanceof n)) return new n();
                                                if (arguments.length) throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
                                                this.files = {}, this.comment = null, this.root = "", this.clone = function () {
                                                  var e = new n();

                                                  for (var t in this) {
                                                    "function" != typeof this[t] && (e[t] = this[t]);
                                                  }

                                                  return e;
                                                };
                                              }

                                              (n.prototype = e("./object")).loadAsync = e("./load"), n.support = e("./support"), n.defaults = e("./defaults"), n.version = "3.5.0", n.loadAsync = function (e, t) {
                                                return new n().loadAsync(e, t);
                                              }, n.external = e("./external"), t.exports = n;
                                            }, {
                                              "./defaults": 5,
                                              "./external": 6,
                                              "./load": 11,
                                              "./object": 15,
                                              "./support": 30
                                            }],
                                            11: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./utils"),
                                                  i = e("./external"),
                                                  o = e("./utf8"),
                                                  u = e("./zipEntries"),
                                                  s = e("./stream/Crc32Probe"),
                                                  h = e("./nodejsUtils");

                                              function f(n) {
                                                return new i.Promise(function (e, t) {
                                                  var r = n.decompressed.getContentWorker().pipe(new s());
                                                  r.on("error", function (e) {
                                                    t(e);
                                                  }).on("end", function () {
                                                    r.streamInfo.crc32 !== n.decompressed.crc32 ? t(new Error("Corrupted zip : CRC32 mismatch")) : e();
                                                  }).resume();
                                                });
                                              }

                                              t.exports = function (e, s) {
                                                var a = this;
                                                return s = n.extend(s || {}, {
                                                  base64: !1,
                                                  checkCRC32: !1,
                                                  optimizedBinaryString: !1,
                                                  createFolders: !1,
                                                  decodeFileName: o.utf8decode
                                                }), h.isNode && h.isStream(e) ? i.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")) : n.prepareContent("the loaded zip file", e, !0, s.optimizedBinaryString, s.base64).then(function (e) {
                                                  var t = new u(s);
                                                  return t.load(e), t;
                                                }).then(function (e) {
                                                  var t = [i.Promise.resolve(e)],
                                                      r = e.files;
                                                  if (s.checkCRC32) for (var n = 0; n < r.length; n++) {
                                                    t.push(f(r[n]));
                                                  }
                                                  return i.Promise.all(t);
                                                }).then(function (e) {
                                                  for (var t = e.shift(), r = t.files, n = 0; n < r.length; n++) {
                                                    var i = r[n];
                                                    a.file(i.fileNameStr, i.decompressed, {
                                                      binary: !0,
                                                      optimizedBinaryString: !0,
                                                      date: i.date,
                                                      dir: i.dir,
                                                      comment: i.fileCommentStr.length ? i.fileCommentStr : null,
                                                      unixPermissions: i.unixPermissions,
                                                      dosPermissions: i.dosPermissions,
                                                      createFolders: s.createFolders
                                                    });
                                                  }

                                                  return t.zipComment.length && (a.comment = t.zipComment), a;
                                                });
                                              };
                                            }, {
                                              "./external": 6,
                                              "./nodejsUtils": 14,
                                              "./stream/Crc32Probe": 25,
                                              "./utf8": 31,
                                              "./utils": 32,
                                              "./zipEntries": 33
                                            }],
                                            12: [function (e, t, r) {
                                              "use strict";

                                              var n = e("../utils"),
                                                  i = e("../stream/GenericWorker");

                                              function s(e, t) {
                                                i.call(this, "Nodejs stream input adapter for " + e), this._upstreamEnded = !1, this._bindStream(t);
                                              }

                                              n.inherits(s, i), s.prototype._bindStream = function (e) {
                                                var t = this;
                                                (this._stream = e).pause(), e.on("data", function (e) {
                                                  t.push({
                                                    data: e,
                                                    meta: {
                                                      percent: 0
                                                    }
                                                  });
                                                }).on("error", function (e) {
                                                  t.isPaused ? this.generatedError = e : t.error(e);
                                                }).on("end", function () {
                                                  t.isPaused ? t._upstreamEnded = !0 : t.end();
                                                });
                                              }, s.prototype.pause = function () {
                                                return !!i.prototype.pause.call(this) && (this._stream.pause(), !0);
                                              }, s.prototype.resume = function () {
                                                return !!i.prototype.resume.call(this) && (this._upstreamEnded ? this.end() : this._stream.resume(), !0);
                                              }, t.exports = s;
                                            }, {
                                              "../stream/GenericWorker": 28,
                                              "../utils": 32
                                            }],
                                            13: [function (e, t, r) {
                                              "use strict";

                                              var i = e("readable-stream").Readable;

                                              function n(e, t, r) {
                                                i.call(this, t), this._helper = e;
                                                var n = this;
                                                e.on("data", function (e, t) {
                                                  n.push(e) || n._helper.pause(), r && r(t);
                                                }).on("error", function (e) {
                                                  n.emit("error", e);
                                                }).on("end", function () {
                                                  n.push(null);
                                                });
                                              }

                                              e("../utils").inherits(n, i), n.prototype._read = function () {
                                                this._helper.resume();
                                              }, t.exports = n;
                                            }, {
                                              "../utils": 32,
                                              "readable-stream": 16
                                            }],
                                            14: [function (e, t, r) {
                                              "use strict";

                                              t.exports = {
                                                isNode: "undefined" != typeof Buffer,
                                                newBufferFrom: function newBufferFrom(e, t) {
                                                  if (Buffer.from && Buffer.from !== Uint8Array.from) return Buffer.from(e, t);
                                                  if ("number" == typeof e) throw new Error('The "data" argument must not be a number');
                                                  return new Buffer(e, t);
                                                },
                                                allocBuffer: function allocBuffer(e) {
                                                  if (Buffer.alloc) return Buffer.alloc(e);
                                                  var t = new Buffer(e);
                                                  return t.fill(0), t;
                                                },
                                                isBuffer: function isBuffer(e) {
                                                  return Buffer.isBuffer(e);
                                                },
                                                isStream: function isStream(e) {
                                                  return e && "function" == typeof e.on && "function" == typeof e.pause && "function" == typeof e.resume;
                                                }
                                              };
                                            }, {}],
                                            15: [function (e, t, r) {
                                              "use strict";

                                              function s(e, t, r) {
                                                var n,
                                                    i = f.getTypeOf(t),
                                                    s = f.extend(r || {}, d);
                                                s.date = s.date || new Date(), null !== s.compression && (s.compression = s.compression.toUpperCase()), "string" == typeof s.unixPermissions && (s.unixPermissions = parseInt(s.unixPermissions, 8)), s.unixPermissions && 16384 & s.unixPermissions && (s.dir = !0), s.dosPermissions && 16 & s.dosPermissions && (s.dir = !0), s.dir && (e = h(e)), s.createFolders && (n = function (e) {
                                                  "/" === e.slice(-1) && (e = e.substring(0, e.length - 1));
                                                  var t = e.lastIndexOf("/");
                                                  return 0 < t ? e.substring(0, t) : "";
                                                }(e)) && g.call(this, n, !0);
                                                var a,
                                                    o = "string" === i && !1 === s.binary && !1 === s.base64;
                                                r && void 0 !== r.binary || (s.binary = !o), (t instanceof c && 0 === t.uncompressedSize || s.dir || !t || 0 === t.length) && (s.base64 = !1, s.binary = !0, t = "", s.compression = "STORE", i = "string"), a = t instanceof c || t instanceof l ? t : m.isNode && m.isStream(t) ? new _(e, t) : f.prepareContent(e, t, s.binary, s.optimizedBinaryString, s.base64);
                                                var u = new p(e, a, s);
                                                this.files[e] = u;
                                              }

                                              function h(e) {
                                                return "/" !== e.slice(-1) && (e += "/"), e;
                                              }

                                              var i = e("./utf8"),
                                                  f = e("./utils"),
                                                  l = e("./stream/GenericWorker"),
                                                  a = e("./stream/StreamHelper"),
                                                  d = e("./defaults"),
                                                  c = e("./compressedObject"),
                                                  p = e("./zipObject"),
                                                  o = e("./generate"),
                                                  m = e("./nodejsUtils"),
                                                  _ = e("./nodejs/NodejsStreamInputAdapter"),
                                                  g = function g(e, t) {
                                                return t = void 0 !== t ? t : d.createFolders, e = h(e), this.files[e] || s.call(this, e, null, {
                                                  dir: !0,
                                                  createFolders: t
                                                }), this.files[e];
                                              };

                                              function u(e) {
                                                return "[object RegExp]" === Object.prototype.toString.call(e);
                                              }

                                              var n = {
                                                load: function load() {
                                                  throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
                                                },
                                                forEach: function forEach(e) {
                                                  var t, r, n;

                                                  for (t in this.files) {
                                                    this.files.hasOwnProperty(t) && (n = this.files[t], (r = t.slice(this.root.length, t.length)) && t.slice(0, this.root.length) === this.root && e(r, n));
                                                  }
                                                },
                                                filter: function filter(r) {
                                                  var n = [];
                                                  return this.forEach(function (e, t) {
                                                    r(e, t) && n.push(t);
                                                  }), n;
                                                },
                                                file: function file(e, t, r) {
                                                  if (1 !== arguments.length) return e = this.root + e, s.call(this, e, t, r), this;

                                                  if (u(e)) {
                                                    var n = e;
                                                    return this.filter(function (e, t) {
                                                      return !t.dir && n.test(e);
                                                    });
                                                  }

                                                  var i = this.files[this.root + e];
                                                  return i && !i.dir ? i : null;
                                                },
                                                folder: function folder(r) {
                                                  if (!r) return this;
                                                  if (u(r)) return this.filter(function (e, t) {
                                                    return t.dir && r.test(e);
                                                  });
                                                  var e = this.root + r,
                                                      t = g.call(this, e),
                                                      n = this.clone();
                                                  return n.root = t.name, n;
                                                },
                                                remove: function remove(r) {
                                                  r = this.root + r;
                                                  var e = this.files[r];
                                                  if (e || ("/" !== r.slice(-1) && (r += "/"), e = this.files[r]), e && !e.dir) delete this.files[r];else for (var t = this.filter(function (e, t) {
                                                    return t.name.slice(0, r.length) === r;
                                                  }), n = 0; n < t.length; n++) {
                                                    delete this.files[t[n].name];
                                                  }
                                                  return this;
                                                },
                                                generate: function generate(e) {
                                                  throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
                                                },
                                                generateInternalStream: function generateInternalStream(e) {
                                                  var t,
                                                      r = {};

                                                  try {
                                                    if ((r = f.extend(e || {}, {
                                                      streamFiles: !1,
                                                      compression: "STORE",
                                                      compressionOptions: null,
                                                      type: "",
                                                      platform: "DOS",
                                                      comment: null,
                                                      mimeType: "application/zip",
                                                      encodeFileName: i.utf8encode
                                                    })).type = r.type.toLowerCase(), r.compression = r.compression.toUpperCase(), "binarystring" === r.type && (r.type = "string"), !r.type) throw new Error("No output type specified.");
                                                    f.checkSupport(r.type), "darwin" !== r.platform && "freebsd" !== r.platform && "linux" !== r.platform && "sunos" !== r.platform || (r.platform = "UNIX"), "win32" === r.platform && (r.platform = "DOS");
                                                    var n = r.comment || this.comment || "";
                                                    t = o.generateWorker(this, r, n);
                                                  } catch (e) {
                                                    (t = new l("error")).error(e);
                                                  }

                                                  return new a(t, r.type || "string", r.mimeType);
                                                },
                                                generateAsync: function generateAsync(e, t) {
                                                  return this.generateInternalStream(e).accumulate(t);
                                                },
                                                generateNodeStream: function generateNodeStream(e, t) {
                                                  return (e = e || {}).type || (e.type = "nodebuffer"), this.generateInternalStream(e).toNodejsStream(t);
                                                }
                                              };
                                              t.exports = n;
                                            }, {
                                              "./compressedObject": 2,
                                              "./defaults": 5,
                                              "./generate": 9,
                                              "./nodejs/NodejsStreamInputAdapter": 12,
                                              "./nodejsUtils": 14,
                                              "./stream/GenericWorker": 28,
                                              "./stream/StreamHelper": 29,
                                              "./utf8": 31,
                                              "./utils": 32,
                                              "./zipObject": 35
                                            }],
                                            16: [function (e, t, r) {
                                              t.exports = e("stream");
                                            }, {
                                              stream: void 0
                                            }],
                                            17: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./DataReader");

                                              function i(e) {
                                                n.call(this, e);

                                                for (var t = 0; t < this.data.length; t++) {
                                                  e[t] = 255 & e[t];
                                                }
                                              }

                                              e("../utils").inherits(i, n), i.prototype.byteAt = function (e) {
                                                return this.data[this.zero + e];
                                              }, i.prototype.lastIndexOfSignature = function (e) {
                                                for (var t = e.charCodeAt(0), r = e.charCodeAt(1), n = e.charCodeAt(2), i = e.charCodeAt(3), s = this.length - 4; 0 <= s; --s) {
                                                  if (this.data[s] === t && this.data[s + 1] === r && this.data[s + 2] === n && this.data[s + 3] === i) return s - this.zero;
                                                }

                                                return -1;
                                              }, i.prototype.readAndCheckSignature = function (e) {
                                                var t = e.charCodeAt(0),
                                                    r = e.charCodeAt(1),
                                                    n = e.charCodeAt(2),
                                                    i = e.charCodeAt(3),
                                                    s = this.readData(4);
                                                return t === s[0] && r === s[1] && n === s[2] && i === s[3];
                                              }, i.prototype.readData = function (e) {
                                                if (this.checkOffset(e), 0 === e) return [];
                                                var t = this.data.slice(this.zero + this.index, this.zero + this.index + e);
                                                return this.index += e, t;
                                              }, t.exports = i;
                                            }, {
                                              "../utils": 32,
                                              "./DataReader": 18
                                            }],
                                            18: [function (e, t, r) {
                                              "use strict";

                                              var n = e("../utils");

                                              function i(e) {
                                                this.data = e, this.length = e.length, this.index = 0, this.zero = 0;
                                              }

                                              i.prototype = {
                                                checkOffset: function checkOffset(e) {
                                                  this.checkIndex(this.index + e);
                                                },
                                                checkIndex: function checkIndex(e) {
                                                  if (this.length < this.zero + e || e < 0) throw new Error("End of data reached (data length = " + this.length + ", asked index = " + e + "). Corrupted zip ?");
                                                },
                                                setIndex: function setIndex(e) {
                                                  this.checkIndex(e), this.index = e;
                                                },
                                                skip: function skip(e) {
                                                  this.setIndex(this.index + e);
                                                },
                                                byteAt: function byteAt(e) {},
                                                readInt: function readInt(e) {
                                                  var t,
                                                      r = 0;

                                                  for (this.checkOffset(e), t = this.index + e - 1; t >= this.index; t--) {
                                                    r = (r << 8) + this.byteAt(t);
                                                  }

                                                  return this.index += e, r;
                                                },
                                                readString: function readString(e) {
                                                  return n.transformTo("string", this.readData(e));
                                                },
                                                readData: function readData(e) {},
                                                lastIndexOfSignature: function lastIndexOfSignature(e) {},
                                                readAndCheckSignature: function readAndCheckSignature(e) {},
                                                readDate: function readDate() {
                                                  var e = this.readInt(4);
                                                  return new Date(Date.UTC(1980 + (e >> 25 & 127), (e >> 21 & 15) - 1, e >> 16 & 31, e >> 11 & 31, e >> 5 & 63, (31 & e) << 1));
                                                }
                                              }, t.exports = i;
                                            }, {
                                              "../utils": 32
                                            }],
                                            19: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./Uint8ArrayReader");

                                              function i(e) {
                                                n.call(this, e);
                                              }

                                              e("../utils").inherits(i, n), i.prototype.readData = function (e) {
                                                this.checkOffset(e);
                                                var t = this.data.slice(this.zero + this.index, this.zero + this.index + e);
                                                return this.index += e, t;
                                              }, t.exports = i;
                                            }, {
                                              "../utils": 32,
                                              "./Uint8ArrayReader": 21
                                            }],
                                            20: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./DataReader");

                                              function i(e) {
                                                n.call(this, e);
                                              }

                                              e("../utils").inherits(i, n), i.prototype.byteAt = function (e) {
                                                return this.data.charCodeAt(this.zero + e);
                                              }, i.prototype.lastIndexOfSignature = function (e) {
                                                return this.data.lastIndexOf(e) - this.zero;
                                              }, i.prototype.readAndCheckSignature = function (e) {
                                                return e === this.readData(4);
                                              }, i.prototype.readData = function (e) {
                                                this.checkOffset(e);
                                                var t = this.data.slice(this.zero + this.index, this.zero + this.index + e);
                                                return this.index += e, t;
                                              }, t.exports = i;
                                            }, {
                                              "../utils": 32,
                                              "./DataReader": 18
                                            }],
                                            21: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./ArrayReader");

                                              function i(e) {
                                                n.call(this, e);
                                              }

                                              e("../utils").inherits(i, n), i.prototype.readData = function (e) {
                                                if (this.checkOffset(e), 0 === e) return new Uint8Array(0);
                                                var t = this.data.subarray(this.zero + this.index, this.zero + this.index + e);
                                                return this.index += e, t;
                                              }, t.exports = i;
                                            }, {
                                              "../utils": 32,
                                              "./ArrayReader": 17
                                            }],
                                            22: [function (e, t, r) {
                                              "use strict";

                                              var n = e("../utils"),
                                                  i = e("../support"),
                                                  s = e("./ArrayReader"),
                                                  a = e("./StringReader"),
                                                  o = e("./NodeBufferReader"),
                                                  u = e("./Uint8ArrayReader");

                                              t.exports = function (e) {
                                                var t = n.getTypeOf(e);
                                                return n.checkSupport(t), "string" !== t || i.uint8array ? "nodebuffer" === t ? new o(e) : i.uint8array ? new u(n.transformTo("uint8array", e)) : new s(n.transformTo("array", e)) : new a(e);
                                              };
                                            }, {
                                              "../support": 30,
                                              "../utils": 32,
                                              "./ArrayReader": 17,
                                              "./NodeBufferReader": 19,
                                              "./StringReader": 20,
                                              "./Uint8ArrayReader": 21
                                            }],
                                            23: [function (e, t, r) {
                                              "use strict";

                                              r.LOCAL_FILE_HEADER = "PK", r.CENTRAL_FILE_HEADER = "PK", r.CENTRAL_DIRECTORY_END = "PK", r.ZIP64_CENTRAL_DIRECTORY_LOCATOR = "PK", r.ZIP64_CENTRAL_DIRECTORY_END = "PK", r.DATA_DESCRIPTOR = "PK\b";
                                            }, {}],
                                            24: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./GenericWorker"),
                                                  i = e("../utils");

                                              function s(e) {
                                                n.call(this, "ConvertWorker to " + e), this.destType = e;
                                              }

                                              i.inherits(s, n), s.prototype.processChunk = function (e) {
                                                this.push({
                                                  data: i.transformTo(this.destType, e.data),
                                                  meta: e.meta
                                                });
                                              }, t.exports = s;
                                            }, {
                                              "../utils": 32,
                                              "./GenericWorker": 28
                                            }],
                                            25: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./GenericWorker"),
                                                  i = e("../crc32");

                                              function s() {
                                                n.call(this, "Crc32Probe"), this.withStreamInfo("crc32", 0);
                                              }

                                              e("../utils").inherits(s, n), s.prototype.processChunk = function (e) {
                                                this.streamInfo.crc32 = i(e.data, this.streamInfo.crc32 || 0), this.push(e);
                                              }, t.exports = s;
                                            }, {
                                              "../crc32": 4,
                                              "../utils": 32,
                                              "./GenericWorker": 28
                                            }],
                                            26: [function (e, t, r) {
                                              "use strict";

                                              var n = e("../utils"),
                                                  i = e("./GenericWorker");

                                              function s(e) {
                                                i.call(this, "DataLengthProbe for " + e), this.propName = e, this.withStreamInfo(e, 0);
                                              }

                                              n.inherits(s, i), s.prototype.processChunk = function (e) {
                                                if (e) {
                                                  var t = this.streamInfo[this.propName] || 0;
                                                  this.streamInfo[this.propName] = t + e.data.length;
                                                }

                                                i.prototype.processChunk.call(this, e);
                                              }, t.exports = s;
                                            }, {
                                              "../utils": 32,
                                              "./GenericWorker": 28
                                            }],
                                            27: [function (e, t, r) {
                                              "use strict";

                                              var n = e("../utils"),
                                                  i = e("./GenericWorker");

                                              function s(e) {
                                                i.call(this, "DataWorker");
                                                var t = this;
                                                this.dataIsReady = !1, this.index = 0, this.max = 0, this.data = null, this.type = "", this._tickScheduled = !1, e.then(function (e) {
                                                  t.dataIsReady = !0, t.data = e, t.max = e && e.length || 0, t.type = n.getTypeOf(e), t.isPaused || t._tickAndRepeat();
                                                }, function (e) {
                                                  t.error(e);
                                                });
                                              }

                                              n.inherits(s, i), s.prototype.cleanUp = function () {
                                                i.prototype.cleanUp.call(this), this.data = null;
                                              }, s.prototype.resume = function () {
                                                return !!i.prototype.resume.call(this) && (!this._tickScheduled && this.dataIsReady && (this._tickScheduled = !0, n.delay(this._tickAndRepeat, [], this)), !0);
                                              }, s.prototype._tickAndRepeat = function () {
                                                this._tickScheduled = !1, this.isPaused || this.isFinished || (this._tick(), this.isFinished || (n.delay(this._tickAndRepeat, [], this), this._tickScheduled = !0));
                                              }, s.prototype._tick = function () {
                                                if (this.isPaused || this.isFinished) return !1;
                                                var e = null,
                                                    t = Math.min(this.max, this.index + 16384);
                                                if (this.index >= this.max) return this.end();

                                                switch (this.type) {
                                                  case "string":
                                                    e = this.data.substring(this.index, t);
                                                    break;

                                                  case "uint8array":
                                                    e = this.data.subarray(this.index, t);
                                                    break;

                                                  case "array":
                                                  case "nodebuffer":
                                                    e = this.data.slice(this.index, t);
                                                }

                                                return this.index = t, this.push({
                                                  data: e,
                                                  meta: {
                                                    percent: this.max ? this.index / this.max * 100 : 0
                                                  }
                                                });
                                              }, t.exports = s;
                                            }, {
                                              "../utils": 32,
                                              "./GenericWorker": 28
                                            }],
                                            28: [function (e, t, r) {
                                              "use strict";

                                              function n(e) {
                                                this.name = e || "default", this.streamInfo = {}, this.generatedError = null, this.extraStreamInfo = {}, this.isPaused = !0, this.isFinished = !1, this.isLocked = !1, this._listeners = {
                                                  data: [],
                                                  end: [],
                                                  error: []
                                                }, this.previous = null;
                                              }

                                              n.prototype = {
                                                push: function push(e) {
                                                  this.emit("data", e);
                                                },
                                                end: function end() {
                                                  if (this.isFinished) return !1;
                                                  this.flush();

                                                  try {
                                                    this.emit("end"), this.cleanUp(), this.isFinished = !0;
                                                  } catch (e) {
                                                    this.emit("error", e);
                                                  }

                                                  return !0;
                                                },
                                                error: function error(e) {
                                                  return !this.isFinished && (this.isPaused ? this.generatedError = e : (this.isFinished = !0, this.emit("error", e), this.previous && this.previous.error(e), this.cleanUp()), !0);
                                                },
                                                on: function on(e, t) {
                                                  return this._listeners[e].push(t), this;
                                                },
                                                cleanUp: function cleanUp() {
                                                  this.streamInfo = this.generatedError = this.extraStreamInfo = null, this._listeners = [];
                                                },
                                                emit: function emit(e, t) {
                                                  if (this._listeners[e]) for (var r = 0; r < this._listeners[e].length; r++) {
                                                    this._listeners[e][r].call(this, t);
                                                  }
                                                },
                                                pipe: function pipe(e) {
                                                  return e.registerPrevious(this);
                                                },
                                                registerPrevious: function registerPrevious(e) {
                                                  if (this.isLocked) throw new Error("The stream '" + this + "' has already been used.");
                                                  this.streamInfo = e.streamInfo, this.mergeStreamInfo(), this.previous = e;
                                                  var t = this;
                                                  return e.on("data", function (e) {
                                                    t.processChunk(e);
                                                  }), e.on("end", function () {
                                                    t.end();
                                                  }), e.on("error", function (e) {
                                                    t.error(e);
                                                  }), this;
                                                },
                                                pause: function pause() {
                                                  return !this.isPaused && !this.isFinished && (this.isPaused = !0, this.previous && this.previous.pause(), !0);
                                                },
                                                resume: function resume() {
                                                  if (!this.isPaused || this.isFinished) return !1;
                                                  var e = this.isPaused = !1;
                                                  return this.generatedError && (this.error(this.generatedError), e = !0), this.previous && this.previous.resume(), !e;
                                                },
                                                flush: function flush() {},
                                                processChunk: function processChunk(e) {
                                                  this.push(e);
                                                },
                                                withStreamInfo: function withStreamInfo(e, t) {
                                                  return this.extraStreamInfo[e] = t, this.mergeStreamInfo(), this;
                                                },
                                                mergeStreamInfo: function mergeStreamInfo() {
                                                  for (var e in this.extraStreamInfo) {
                                                    this.extraStreamInfo.hasOwnProperty(e) && (this.streamInfo[e] = this.extraStreamInfo[e]);
                                                  }
                                                },
                                                lock: function lock() {
                                                  if (this.isLocked) throw new Error("The stream '" + this + "' has already been used.");
                                                  this.isLocked = !0, this.previous && this.previous.lock();
                                                },
                                                toString: function toString() {
                                                  var e = "Worker " + this.name;
                                                  return this.previous ? this.previous + " -> " + e : e;
                                                }
                                              }, t.exports = n;
                                            }, {}],
                                            29: [function (e, t, r) {
                                              "use strict";

                                              var h = e("../utils"),
                                                  i = e("./ConvertWorker"),
                                                  s = e("./GenericWorker"),
                                                  f = e("../base64"),
                                                  n = e("../support"),
                                                  a = e("../external"),
                                                  o = null;
                                              if (n.nodestream) try {
                                                o = e("../nodejs/NodejsStreamOutputAdapter");
                                              } catch (e) {}

                                              function u(e, t, r) {
                                                var n = t;

                                                switch (t) {
                                                  case "blob":
                                                  case "arraybuffer":
                                                    n = "uint8array";
                                                    break;

                                                  case "base64":
                                                    n = "string";
                                                }

                                                try {
                                                  this._internalType = n, this._outputType = t, this._mimeType = r, h.checkSupport(n), this._worker = e.pipe(new i(n)), e.lock();
                                                } catch (e) {
                                                  this._worker = new s("error"), this._worker.error(e);
                                                }
                                              }

                                              u.prototype = {
                                                accumulate: function accumulate(e) {
                                                  return o = this, u = e, new a.Promise(function (t, r) {
                                                    var n = [],
                                                        i = o._internalType,
                                                        s = o._outputType,
                                                        a = o._mimeType;
                                                    o.on("data", function (e, t) {
                                                      n.push(e), u && u(t);
                                                    }).on("error", function (e) {
                                                      n = [], r(e);
                                                    }).on("end", function () {
                                                      try {
                                                        var e = function (e, t, r) {
                                                          switch (e) {
                                                            case "blob":
                                                              return h.newBlob(h.transformTo("arraybuffer", t), r);

                                                            case "base64":
                                                              return f.encode(t);

                                                            default:
                                                              return h.transformTo(e, t);
                                                          }
                                                        }(s, function (e, t) {
                                                          var r,
                                                              n = 0,
                                                              i = null,
                                                              s = 0;

                                                          for (r = 0; r < t.length; r++) {
                                                            s += t[r].length;
                                                          }

                                                          switch (e) {
                                                            case "string":
                                                              return t.join("");

                                                            case "array":
                                                              return Array.prototype.concat.apply([], t);

                                                            case "uint8array":
                                                              for (i = new Uint8Array(s), r = 0; r < t.length; r++) {
                                                                i.set(t[r], n), n += t[r].length;
                                                              }

                                                              return i;

                                                            case "nodebuffer":
                                                              return Buffer.concat(t);

                                                            default:
                                                              throw new Error("concat : unsupported type '" + e + "'");
                                                          }
                                                        }(i, n), a);

                                                        t(e);
                                                      } catch (e) {
                                                        r(e);
                                                      }

                                                      n = [];
                                                    }).resume();
                                                  });
                                                  var o, u;
                                                },
                                                on: function on(e, t) {
                                                  var r = this;
                                                  return "data" === e ? this._worker.on(e, function (e) {
                                                    t.call(r, e.data, e.meta);
                                                  }) : this._worker.on(e, function () {
                                                    h.delay(t, arguments, r);
                                                  }), this;
                                                },
                                                resume: function resume() {
                                                  return h.delay(this._worker.resume, [], this._worker), this;
                                                },
                                                pause: function pause() {
                                                  return this._worker.pause(), this;
                                                },
                                                toNodejsStream: function toNodejsStream(e) {
                                                  if (h.checkSupport("nodestream"), "nodebuffer" !== this._outputType) throw new Error(this._outputType + " is not supported by this method");
                                                  return new o(this, {
                                                    objectMode: "nodebuffer" !== this._outputType
                                                  }, e);
                                                }
                                              }, t.exports = u;
                                            }, {
                                              "../base64": 1,
                                              "../external": 6,
                                              "../nodejs/NodejsStreamOutputAdapter": 13,
                                              "../support": 30,
                                              "../utils": 32,
                                              "./ConvertWorker": 24,
                                              "./GenericWorker": 28
                                            }],
                                            30: [function (e, t, r) {
                                              "use strict";

                                              if (r.base64 = !0, r.array = !0, r.string = !0, r.arraybuffer = "undefined" != typeof ArrayBuffer && "undefined" != typeof Uint8Array, r.nodebuffer = "undefined" != typeof Buffer, r.uint8array = "undefined" != typeof Uint8Array, "undefined" == typeof ArrayBuffer) r.blob = !1;else {
                                                var n = new ArrayBuffer(0);

                                                try {
                                                  r.blob = 0 === new Blob([n], {
                                                    type: "application/zip"
                                                  }).size;
                                                } catch (e) {
                                                  try {
                                                    var i = new (self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder)();
                                                    i.append(n), r.blob = 0 === i.getBlob("application/zip").size;
                                                  } catch (e) {
                                                    r.blob = !1;
                                                  }
                                                }
                                              }

                                              try {
                                                r.nodestream = !!e("readable-stream").Readable;
                                              } catch (e) {
                                                r.nodestream = !1;
                                              }
                                            }, {
                                              "readable-stream": 16
                                            }],
                                            31: [function (e, t, s) {
                                              "use strict";

                                              for (var o = e("./utils"), u = e("./support"), r = e("./nodejsUtils"), n = e("./stream/GenericWorker"), h = new Array(256), i = 0; i < 256; i++) {
                                                h[i] = 252 <= i ? 6 : 248 <= i ? 5 : 240 <= i ? 4 : 224 <= i ? 3 : 192 <= i ? 2 : 1;
                                              }

                                              function a() {
                                                n.call(this, "utf-8 decode"), this.leftOver = null;
                                              }

                                              function f() {
                                                n.call(this, "utf-8 encode");
                                              }

                                              h[254] = h[254] = 1, s.utf8encode = function (e) {
                                                return u.nodebuffer ? r.newBufferFrom(e, "utf-8") : function (e) {
                                                  var t,
                                                      r,
                                                      n,
                                                      i,
                                                      s,
                                                      a = e.length,
                                                      o = 0;

                                                  for (i = 0; i < a; i++) {
                                                    55296 == (64512 & (r = e.charCodeAt(i))) && i + 1 < a && 56320 == (64512 & (n = e.charCodeAt(i + 1))) && (r = 65536 + (r - 55296 << 10) + (n - 56320), i++), o += r < 128 ? 1 : r < 2048 ? 2 : r < 65536 ? 3 : 4;
                                                  }

                                                  for (t = u.uint8array ? new Uint8Array(o) : new Array(o), i = s = 0; s < o; i++) {
                                                    55296 == (64512 & (r = e.charCodeAt(i))) && i + 1 < a && 56320 == (64512 & (n = e.charCodeAt(i + 1))) && (r = 65536 + (r - 55296 << 10) + (n - 56320), i++), r < 128 ? t[s++] = r : (r < 2048 ? t[s++] = 192 | r >>> 6 : (r < 65536 ? t[s++] = 224 | r >>> 12 : (t[s++] = 240 | r >>> 18, t[s++] = 128 | r >>> 12 & 63), t[s++] = 128 | r >>> 6 & 63), t[s++] = 128 | 63 & r);
                                                  }

                                                  return t;
                                                }(e);
                                              }, s.utf8decode = function (e) {
                                                return u.nodebuffer ? o.transformTo("nodebuffer", e).toString("utf-8") : function (e) {
                                                  var t,
                                                      r,
                                                      n,
                                                      i,
                                                      s = e.length,
                                                      a = new Array(2 * s);

                                                  for (t = r = 0; t < s;) {
                                                    if ((n = e[t++]) < 128) a[r++] = n;else if (4 < (i = h[n])) a[r++] = 65533, t += i - 1;else {
                                                      for (n &= 2 === i ? 31 : 3 === i ? 15 : 7; 1 < i && t < s;) {
                                                        n = n << 6 | 63 & e[t++], i--;
                                                      }

                                                      1 < i ? a[r++] = 65533 : n < 65536 ? a[r++] = n : (n -= 65536, a[r++] = 55296 | n >> 10 & 1023, a[r++] = 56320 | 1023 & n);
                                                    }
                                                  }

                                                  return a.length !== r && (a.subarray ? a = a.subarray(0, r) : a.length = r), o.applyFromCharCode(a);
                                                }(e = o.transformTo(u.uint8array ? "uint8array" : "array", e));
                                              }, o.inherits(a, n), a.prototype.processChunk = function (e) {
                                                var t = o.transformTo(u.uint8array ? "uint8array" : "array", e.data);

                                                if (this.leftOver && this.leftOver.length) {
                                                  if (u.uint8array) {
                                                    var r = t;
                                                    (t = new Uint8Array(r.length + this.leftOver.length)).set(this.leftOver, 0), t.set(r, this.leftOver.length);
                                                  } else t = this.leftOver.concat(t);

                                                  this.leftOver = null;
                                                }

                                                var n = function (e, t) {
                                                  var r;

                                                  for ((t = t || e.length) > e.length && (t = e.length), r = t - 1; 0 <= r && 128 == (192 & e[r]);) {
                                                    r--;
                                                  }

                                                  return r < 0 ? t : 0 === r ? t : r + h[e[r]] > t ? r : t;
                                                }(t),
                                                    i = t;

                                                n !== t.length && (u.uint8array ? (i = t.subarray(0, n), this.leftOver = t.subarray(n, t.length)) : (i = t.slice(0, n), this.leftOver = t.slice(n, t.length))), this.push({
                                                  data: s.utf8decode(i),
                                                  meta: e.meta
                                                });
                                              }, a.prototype.flush = function () {
                                                this.leftOver && this.leftOver.length && (this.push({
                                                  data: s.utf8decode(this.leftOver),
                                                  meta: {}
                                                }), this.leftOver = null);
                                              }, s.Utf8DecodeWorker = a, o.inherits(f, n), f.prototype.processChunk = function (e) {
                                                this.push({
                                                  data: s.utf8encode(e.data),
                                                  meta: e.meta
                                                });
                                              }, s.Utf8EncodeWorker = f;
                                            }, {
                                              "./nodejsUtils": 14,
                                              "./stream/GenericWorker": 28,
                                              "./support": 30,
                                              "./utils": 32
                                            }],
                                            32: [function (e, t, o) {
                                              "use strict";

                                              var u = e("./support"),
                                                  h = e("./base64"),
                                                  r = e("./nodejsUtils"),
                                                  n = e("set-immediate-shim"),
                                                  f = e("./external");

                                              function i(e) {
                                                return e;
                                              }

                                              function l(e, t) {
                                                for (var r = 0; r < e.length; ++r) {
                                                  t[r] = 255 & e.charCodeAt(r);
                                                }

                                                return t;
                                              }

                                              o.newBlob = function (t, r) {
                                                o.checkSupport("blob");

                                                try {
                                                  return new Blob([t], {
                                                    type: r
                                                  });
                                                } catch (e) {
                                                  try {
                                                    var n = new (self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder)();
                                                    return n.append(t), n.getBlob(r);
                                                  } catch (e) {
                                                    throw new Error("Bug : can't construct the Blob.");
                                                  }
                                                }
                                              };

                                              var s = {
                                                stringifyByChunk: function stringifyByChunk(e, t, r) {
                                                  var n = [],
                                                      i = 0,
                                                      s = e.length;
                                                  if (s <= r) return String.fromCharCode.apply(null, e);

                                                  for (; i < s;) {
                                                    "array" === t || "nodebuffer" === t ? n.push(String.fromCharCode.apply(null, e.slice(i, Math.min(i + r, s)))) : n.push(String.fromCharCode.apply(null, e.subarray(i, Math.min(i + r, s)))), i += r;
                                                  }

                                                  return n.join("");
                                                },
                                                stringifyByChar: function stringifyByChar(e) {
                                                  for (var t = "", r = 0; r < e.length; r++) {
                                                    t += String.fromCharCode(e[r]);
                                                  }

                                                  return t;
                                                },
                                                applyCanBeUsed: {
                                                  uint8array: function () {
                                                    try {
                                                      return u.uint8array && 1 === String.fromCharCode.apply(null, new Uint8Array(1)).length;
                                                    } catch (e) {
                                                      return !1;
                                                    }
                                                  }(),
                                                  nodebuffer: function () {
                                                    try {
                                                      return u.nodebuffer && 1 === String.fromCharCode.apply(null, r.allocBuffer(1)).length;
                                                    } catch (e) {
                                                      return !1;
                                                    }
                                                  }()
                                                }
                                              };

                                              function a(e) {
                                                var t = 65536,
                                                    r = o.getTypeOf(e),
                                                    n = !0;
                                                if ("uint8array" === r ? n = s.applyCanBeUsed.uint8array : "nodebuffer" === r && (n = s.applyCanBeUsed.nodebuffer), n) for (; 1 < t;) {
                                                  try {
                                                    return s.stringifyByChunk(e, r, t);
                                                  } catch (e) {
                                                    t = Math.floor(t / 2);
                                                  }
                                                }
                                                return s.stringifyByChar(e);
                                              }

                                              function d(e, t) {
                                                for (var r = 0; r < e.length; r++) {
                                                  t[r] = e[r];
                                                }

                                                return t;
                                              }

                                              o.applyFromCharCode = a;
                                              var c = {};
                                              c.string = {
                                                string: i,
                                                array: function array(e) {
                                                  return l(e, new Array(e.length));
                                                },
                                                arraybuffer: function arraybuffer(e) {
                                                  return c.string.uint8array(e).buffer;
                                                },
                                                uint8array: function uint8array(e) {
                                                  return l(e, new Uint8Array(e.length));
                                                },
                                                nodebuffer: function nodebuffer(e) {
                                                  return l(e, r.allocBuffer(e.length));
                                                }
                                              }, c.array = {
                                                string: a,
                                                array: i,
                                                arraybuffer: function arraybuffer(e) {
                                                  return new Uint8Array(e).buffer;
                                                },
                                                uint8array: function uint8array(e) {
                                                  return new Uint8Array(e);
                                                },
                                                nodebuffer: function nodebuffer(e) {
                                                  return r.newBufferFrom(e);
                                                }
                                              }, c.arraybuffer = {
                                                string: function string(e) {
                                                  return a(new Uint8Array(e));
                                                },
                                                array: function array(e) {
                                                  return d(new Uint8Array(e), new Array(e.byteLength));
                                                },
                                                arraybuffer: i,
                                                uint8array: function uint8array(e) {
                                                  return new Uint8Array(e);
                                                },
                                                nodebuffer: function nodebuffer(e) {
                                                  return r.newBufferFrom(new Uint8Array(e));
                                                }
                                              }, c.uint8array = {
                                                string: a,
                                                array: function array(e) {
                                                  return d(e, new Array(e.length));
                                                },
                                                arraybuffer: function arraybuffer(e) {
                                                  return e.buffer;
                                                },
                                                uint8array: i,
                                                nodebuffer: function nodebuffer(e) {
                                                  return r.newBufferFrom(e);
                                                }
                                              }, c.nodebuffer = {
                                                string: a,
                                                array: function array(e) {
                                                  return d(e, new Array(e.length));
                                                },
                                                arraybuffer: function arraybuffer(e) {
                                                  return c.nodebuffer.uint8array(e).buffer;
                                                },
                                                uint8array: function uint8array(e) {
                                                  return d(e, new Uint8Array(e.length));
                                                },
                                                nodebuffer: i
                                              }, o.transformTo = function (e, t) {
                                                if (t = t || "", !e) return t;
                                                o.checkSupport(e);
                                                var r = o.getTypeOf(t);
                                                return c[r][e](t);
                                              }, o.getTypeOf = function (e) {
                                                return "string" == typeof e ? "string" : "[object Array]" === Object.prototype.toString.call(e) ? "array" : u.nodebuffer && r.isBuffer(e) ? "nodebuffer" : u.uint8array && e instanceof Uint8Array ? "uint8array" : u.arraybuffer && e instanceof ArrayBuffer ? "arraybuffer" : void 0;
                                              }, o.checkSupport = function (e) {
                                                if (!u[e.toLowerCase()]) throw new Error(e + " is not supported by this platform");
                                              }, o.MAX_VALUE_16BITS = 65535, o.MAX_VALUE_32BITS = -1, o.pretty = function (e) {
                                                var t,
                                                    r,
                                                    n = "";

                                                for (r = 0; r < (e || "").length; r++) {
                                                  n += "\\x" + ((t = e.charCodeAt(r)) < 16 ? "0" : "") + t.toString(16).toUpperCase();
                                                }

                                                return n;
                                              }, o.delay = function (e, t, r) {
                                                n(function () {
                                                  e.apply(r || null, t || []);
                                                });
                                              }, o.inherits = function (e, t) {
                                                function r() {}

                                                r.prototype = t.prototype, e.prototype = new r();
                                              }, o.extend = function () {
                                                var e,
                                                    t,
                                                    r = {};

                                                for (e = 0; e < arguments.length; e++) {
                                                  for (t in arguments[e]) {
                                                    arguments[e].hasOwnProperty(t) && void 0 === r[t] && (r[t] = arguments[e][t]);
                                                  }
                                                }

                                                return r;
                                              }, o.prepareContent = function (n, e, i, s, a) {
                                                return f.Promise.resolve(e).then(function (n) {
                                                  return u.blob && (n instanceof Blob || -1 !== ["[object File]", "[object Blob]"].indexOf(Object.prototype.toString.call(n))) && "undefined" != typeof FileReader ? new f.Promise(function (t, r) {
                                                    var e = new FileReader();
                                                    e.onload = function (e) {
                                                      t(e.target.result);
                                                    }, e.onerror = function (e) {
                                                      r(e.target.error);
                                                    }, e.readAsArrayBuffer(n);
                                                  }) : n;
                                                }).then(function (e) {
                                                  var t,
                                                      r = o.getTypeOf(e);
                                                  return r ? ("arraybuffer" === r ? e = o.transformTo("uint8array", e) : "string" === r && (a ? e = h.decode(e) : i && !0 !== s && (e = l(t = e, u.uint8array ? new Uint8Array(t.length) : new Array(t.length)))), e) : f.Promise.reject(new Error("Can't read the data of '" + n + "'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"));
                                                });
                                              };
                                            }, {
                                              "./base64": 1,
                                              "./external": 6,
                                              "./nodejsUtils": 14,
                                              "./support": 30,
                                              "set-immediate-shim": 54
                                            }],
                                            33: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./reader/readerFor"),
                                                  i = e("./utils"),
                                                  s = e("./signature"),
                                                  a = e("./zipEntry"),
                                                  o = (e("./utf8"), e("./support"));

                                              function u(e) {
                                                this.files = [], this.loadOptions = e;
                                              }

                                              u.prototype = {
                                                checkSignature: function checkSignature(e) {
                                                  if (!this.reader.readAndCheckSignature(e)) {
                                                    this.reader.index -= 4;
                                                    var t = this.reader.readString(4);
                                                    throw new Error("Corrupted zip or bug: unexpected signature (" + i.pretty(t) + ", expected " + i.pretty(e) + ")");
                                                  }
                                                },
                                                isSignature: function isSignature(e, t) {
                                                  var r = this.reader.index;
                                                  this.reader.setIndex(e);
                                                  var n = this.reader.readString(4) === t;
                                                  return this.reader.setIndex(r), n;
                                                },
                                                readBlockEndOfCentral: function readBlockEndOfCentral() {
                                                  this.diskNumber = this.reader.readInt(2), this.diskWithCentralDirStart = this.reader.readInt(2), this.centralDirRecordsOnThisDisk = this.reader.readInt(2), this.centralDirRecords = this.reader.readInt(2), this.centralDirSize = this.reader.readInt(4), this.centralDirOffset = this.reader.readInt(4), this.zipCommentLength = this.reader.readInt(2);
                                                  var e = this.reader.readData(this.zipCommentLength),
                                                      t = o.uint8array ? "uint8array" : "array",
                                                      r = i.transformTo(t, e);
                                                  this.zipComment = this.loadOptions.decodeFileName(r);
                                                },
                                                readBlockZip64EndOfCentral: function readBlockZip64EndOfCentral() {
                                                  this.zip64EndOfCentralSize = this.reader.readInt(8), this.reader.skip(4), this.diskNumber = this.reader.readInt(4), this.diskWithCentralDirStart = this.reader.readInt(4), this.centralDirRecordsOnThisDisk = this.reader.readInt(8), this.centralDirRecords = this.reader.readInt(8), this.centralDirSize = this.reader.readInt(8), this.centralDirOffset = this.reader.readInt(8), this.zip64ExtensibleData = {};

                                                  for (var e, t, r, n = this.zip64EndOfCentralSize - 44; 0 < n;) {
                                                    e = this.reader.readInt(2), t = this.reader.readInt(4), r = this.reader.readData(t), this.zip64ExtensibleData[e] = {
                                                      id: e,
                                                      length: t,
                                                      value: r
                                                    };
                                                  }
                                                },
                                                readBlockZip64EndOfCentralLocator: function readBlockZip64EndOfCentralLocator() {
                                                  if (this.diskWithZip64CentralDirStart = this.reader.readInt(4), this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8), this.disksCount = this.reader.readInt(4), 1 < this.disksCount) throw new Error("Multi-volumes zip are not supported");
                                                },
                                                readLocalFiles: function readLocalFiles() {
                                                  var e, t;

                                                  for (e = 0; e < this.files.length; e++) {
                                                    t = this.files[e], this.reader.setIndex(t.localHeaderOffset), this.checkSignature(s.LOCAL_FILE_HEADER), t.readLocalPart(this.reader), t.handleUTF8(), t.processAttributes();
                                                  }
                                                },
                                                readCentralDir: function readCentralDir() {
                                                  var e;

                                                  for (this.reader.setIndex(this.centralDirOffset); this.reader.readAndCheckSignature(s.CENTRAL_FILE_HEADER);) {
                                                    (e = new a({
                                                      zip64: this.zip64
                                                    }, this.loadOptions)).readCentralPart(this.reader), this.files.push(e);
                                                  }

                                                  if (this.centralDirRecords !== this.files.length && 0 !== this.centralDirRecords && 0 === this.files.length) throw new Error("Corrupted zip or bug: expected " + this.centralDirRecords + " records in central dir, got " + this.files.length);
                                                },
                                                readEndOfCentral: function readEndOfCentral() {
                                                  var e = this.reader.lastIndexOfSignature(s.CENTRAL_DIRECTORY_END);
                                                  if (e < 0) throw this.isSignature(0, s.LOCAL_FILE_HEADER) ? new Error("Corrupted zip: can't find end of central directory") : new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");
                                                  this.reader.setIndex(e);
                                                  var t = e;

                                                  if (this.checkSignature(s.CENTRAL_DIRECTORY_END), this.readBlockEndOfCentral(), this.diskNumber === i.MAX_VALUE_16BITS || this.diskWithCentralDirStart === i.MAX_VALUE_16BITS || this.centralDirRecordsOnThisDisk === i.MAX_VALUE_16BITS || this.centralDirRecords === i.MAX_VALUE_16BITS || this.centralDirSize === i.MAX_VALUE_32BITS || this.centralDirOffset === i.MAX_VALUE_32BITS) {
                                                    if (this.zip64 = !0, (e = this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR)) < 0) throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");
                                                    if (this.reader.setIndex(e), this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR), this.readBlockZip64EndOfCentralLocator(), !this.isSignature(this.relativeOffsetEndOfZip64CentralDir, s.ZIP64_CENTRAL_DIRECTORY_END) && (this.relativeOffsetEndOfZip64CentralDir = this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_END), this.relativeOffsetEndOfZip64CentralDir < 0)) throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");
                                                    this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir), this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_END), this.readBlockZip64EndOfCentral();
                                                  }

                                                  var r = this.centralDirOffset + this.centralDirSize;
                                                  this.zip64 && (r += 20, r += 12 + this.zip64EndOfCentralSize);
                                                  var n = t - r;
                                                  if (0 < n) this.isSignature(t, s.CENTRAL_FILE_HEADER) || (this.reader.zero = n);else if (n < 0) throw new Error("Corrupted zip: missing " + Math.abs(n) + " bytes.");
                                                },
                                                prepareReader: function prepareReader(e) {
                                                  this.reader = n(e);
                                                },
                                                load: function load(e) {
                                                  this.prepareReader(e), this.readEndOfCentral(), this.readCentralDir(), this.readLocalFiles();
                                                }
                                              }, t.exports = u;
                                            }, {
                                              "./reader/readerFor": 22,
                                              "./signature": 23,
                                              "./support": 30,
                                              "./utf8": 31,
                                              "./utils": 32,
                                              "./zipEntry": 34
                                            }],
                                            34: [function (e, t, r) {
                                              "use strict";

                                              var n = e("./reader/readerFor"),
                                                  s = e("./utils"),
                                                  i = e("./compressedObject"),
                                                  a = e("./crc32"),
                                                  o = e("./utf8"),
                                                  u = e("./compressions"),
                                                  h = e("./support");

                                              function f(e, t) {
                                                this.options = e, this.loadOptions = t;
                                              }

                                              f.prototype = {
                                                isEncrypted: function isEncrypted() {
                                                  return 1 == (1 & this.bitFlag);
                                                },
                                                useUTF8: function useUTF8() {
                                                  return 2048 == (2048 & this.bitFlag);
                                                },
                                                readLocalPart: function readLocalPart(e) {
                                                  var t, r;
                                                  if (e.skip(22), this.fileNameLength = e.readInt(2), r = e.readInt(2), this.fileName = e.readData(this.fileNameLength), e.skip(r), -1 === this.compressedSize || -1 === this.uncompressedSize) throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");
                                                  if (null === (t = function (e) {
                                                    for (var t in u) {
                                                      if (u.hasOwnProperty(t) && u[t].magic === e) return u[t];
                                                    }

                                                    return null;
                                                  }(this.compressionMethod))) throw new Error("Corrupted zip : compression " + s.pretty(this.compressionMethod) + " unknown (inner file : " + s.transformTo("string", this.fileName) + ")");
                                                  this.decompressed = new i(this.compressedSize, this.uncompressedSize, this.crc32, t, e.readData(this.compressedSize));
                                                },
                                                readCentralPart: function readCentralPart(e) {
                                                  this.versionMadeBy = e.readInt(2), e.skip(2), this.bitFlag = e.readInt(2), this.compressionMethod = e.readString(2), this.date = e.readDate(), this.crc32 = e.readInt(4), this.compressedSize = e.readInt(4), this.uncompressedSize = e.readInt(4);
                                                  var t = e.readInt(2);
                                                  if (this.extraFieldsLength = e.readInt(2), this.fileCommentLength = e.readInt(2), this.diskNumberStart = e.readInt(2), this.internalFileAttributes = e.readInt(2), this.externalFileAttributes = e.readInt(4), this.localHeaderOffset = e.readInt(4), this.isEncrypted()) throw new Error("Encrypted zip are not supported");
                                                  e.skip(t), this.readExtraFields(e), this.parseZIP64ExtraField(e), this.fileComment = e.readData(this.fileCommentLength);
                                                },
                                                processAttributes: function processAttributes() {
                                                  this.unixPermissions = null, this.dosPermissions = null;
                                                  var e = this.versionMadeBy >> 8;
                                                  this.dir = !!(16 & this.externalFileAttributes), 0 == e && (this.dosPermissions = 63 & this.externalFileAttributes), 3 == e && (this.unixPermissions = this.externalFileAttributes >> 16 & 65535), this.dir || "/" !== this.fileNameStr.slice(-1) || (this.dir = !0);
                                                },
                                                parseZIP64ExtraField: function parseZIP64ExtraField(e) {
                                                  if (this.extraFields[1]) {
                                                    var t = n(this.extraFields[1].value);
                                                    this.uncompressedSize === s.MAX_VALUE_32BITS && (this.uncompressedSize = t.readInt(8)), this.compressedSize === s.MAX_VALUE_32BITS && (this.compressedSize = t.readInt(8)), this.localHeaderOffset === s.MAX_VALUE_32BITS && (this.localHeaderOffset = t.readInt(8)), this.diskNumberStart === s.MAX_VALUE_32BITS && (this.diskNumberStart = t.readInt(4));
                                                  }
                                                },
                                                readExtraFields: function readExtraFields(e) {
                                                  var t,
                                                      r,
                                                      n,
                                                      i = e.index + this.extraFieldsLength;

                                                  for (this.extraFields || (this.extraFields = {}); e.index + 4 < i;) {
                                                    t = e.readInt(2), r = e.readInt(2), n = e.readData(r), this.extraFields[t] = {
                                                      id: t,
                                                      length: r,
                                                      value: n
                                                    };
                                                  }

                                                  e.setIndex(i);
                                                },
                                                handleUTF8: function handleUTF8() {
                                                  var e = h.uint8array ? "uint8array" : "array";
                                                  if (this.useUTF8()) this.fileNameStr = o.utf8decode(this.fileName), this.fileCommentStr = o.utf8decode(this.fileComment);else {
                                                    var t = this.findExtraFieldUnicodePath();
                                                    if (null !== t) this.fileNameStr = t;else {
                                                      var r = s.transformTo(e, this.fileName);
                                                      this.fileNameStr = this.loadOptions.decodeFileName(r);
                                                    }
                                                    var n = this.findExtraFieldUnicodeComment();
                                                    if (null !== n) this.fileCommentStr = n;else {
                                                      var i = s.transformTo(e, this.fileComment);
                                                      this.fileCommentStr = this.loadOptions.decodeFileName(i);
                                                    }
                                                  }
                                                },
                                                findExtraFieldUnicodePath: function findExtraFieldUnicodePath() {
                                                  var e = this.extraFields[28789];

                                                  if (e) {
                                                    var t = n(e.value);
                                                    return 1 !== t.readInt(1) ? null : a(this.fileName) !== t.readInt(4) ? null : o.utf8decode(t.readData(e.length - 5));
                                                  }

                                                  return null;
                                                },
                                                findExtraFieldUnicodeComment: function findExtraFieldUnicodeComment() {
                                                  var e = this.extraFields[25461];

                                                  if (e) {
                                                    var t = n(e.value);
                                                    return 1 !== t.readInt(1) ? null : a(this.fileComment) !== t.readInt(4) ? null : o.utf8decode(t.readData(e.length - 5));
                                                  }

                                                  return null;
                                                }
                                              }, t.exports = f;
                                            }, {
                                              "./compressedObject": 2,
                                              "./compressions": 3,
                                              "./crc32": 4,
                                              "./reader/readerFor": 22,
                                              "./support": 30,
                                              "./utf8": 31,
                                              "./utils": 32
                                            }],
                                            35: [function (e, t, r) {
                                              "use strict";

                                              function n(e, t, r) {
                                                this.name = e, this.dir = r.dir, this.date = r.date, this.comment = r.comment, this.unixPermissions = r.unixPermissions, this.dosPermissions = r.dosPermissions, this._data = t, this._dataBinary = r.binary, this.options = {
                                                  compression: r.compression,
                                                  compressionOptions: r.compressionOptions
                                                };
                                              }

                                              var s = e("./stream/StreamHelper"),
                                                  i = e("./stream/DataWorker"),
                                                  a = e("./utf8"),
                                                  o = e("./compressedObject"),
                                                  u = e("./stream/GenericWorker");
                                              n.prototype = {
                                                internalStream: function internalStream(e) {
                                                  var t = null,
                                                      r = "string";

                                                  try {
                                                    if (!e) throw new Error("No output type specified.");
                                                    var n = "string" === (r = e.toLowerCase()) || "text" === r;
                                                    "binarystring" !== r && "text" !== r || (r = "string"), t = this._decompressWorker();
                                                    var i = !this._dataBinary;
                                                    i && !n && (t = t.pipe(new a.Utf8EncodeWorker())), !i && n && (t = t.pipe(new a.Utf8DecodeWorker()));
                                                  } catch (e) {
                                                    (t = new u("error")).error(e);
                                                  }

                                                  return new s(t, r, "");
                                                },
                                                async: function async(e, t) {
                                                  return this.internalStream(e).accumulate(t);
                                                },
                                                nodeStream: function nodeStream(e, t) {
                                                  return this.internalStream(e || "nodebuffer").toNodejsStream(t);
                                                },
                                                _compressWorker: function _compressWorker(e, t) {
                                                  if (this._data instanceof o && this._data.compression.magic === e.magic) return this._data.getCompressedWorker();

                                                  var r = this._decompressWorker();

                                                  return this._dataBinary || (r = r.pipe(new a.Utf8EncodeWorker())), o.createWorkerFrom(r, e, t);
                                                },
                                                _decompressWorker: function _decompressWorker() {
                                                  return this._data instanceof o ? this._data.getContentWorker() : this._data instanceof u ? this._data : new i(this._data);
                                                }
                                              };

                                              for (var h = ["asText", "asBinary", "asNodeBuffer", "asUint8Array", "asArrayBuffer"], f = function f() {
                                                throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
                                              }, l = 0; l < h.length; l++) {
                                                n.prototype[h[l]] = f;
                                              }

                                              t.exports = n;
                                            }, {
                                              "./compressedObject": 2,
                                              "./stream/DataWorker": 27,
                                              "./stream/GenericWorker": 28,
                                              "./stream/StreamHelper": 29,
                                              "./utf8": 31
                                            }],
                                            36: [function (e, f, t) {
                                              (function (t) {
                                                "use strict";

                                                var r,
                                                    n,
                                                    e = t.MutationObserver || t.WebKitMutationObserver;

                                                if (e) {
                                                  var i = 0,
                                                      s = new e(h),
                                                      a = t.document.createTextNode("");
                                                  s.observe(a, {
                                                    characterData: !0
                                                  }), r = function r() {
                                                    a.data = i = ++i % 2;
                                                  };
                                                } else if (t.setImmediate || void 0 === t.MessageChannel) r = "document" in t && "onreadystatechange" in t.document.createElement("script") ? function () {
                                                  var e = t.document.createElement("script");
                                                  e.onreadystatechange = function () {
                                                    h(), e.onreadystatechange = null, e.parentNode.removeChild(e), e = null;
                                                  }, t.document.documentElement.appendChild(e);
                                                } : function () {
                                                  setTimeout(h, 0);
                                                };else {
                                                  var o = new t.MessageChannel();
                                                  o.port1.onmessage = h, r = function r() {
                                                    o.port2.postMessage(0);
                                                  };
                                                }

                                                var u = [];

                                                function h() {
                                                  var e, t;
                                                  n = !0;

                                                  for (var r = u.length; r;) {
                                                    for (t = u, u = [], e = -1; ++e < r;) {
                                                      t[e]();
                                                    }

                                                    r = u.length;
                                                  }

                                                  n = !1;
                                                }

                                                f.exports = function (e) {
                                                  1 !== u.push(e) || n || r();
                                                };
                                              }).call(this, void 0 !== r ? r : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
                                            }, {}],
                                            37: [function (e, t, r) {
                                              "use strict";

                                              var i = e("immediate");

                                              function h() {}

                                              var f = {},
                                                  s = ["REJECTED"],
                                                  a = ["FULFILLED"],
                                                  n = ["PENDING"];

                                              function o(e) {
                                                if ("function" != typeof e) throw new TypeError("resolver must be a function");
                                                this.state = n, this.queue = [], this.outcome = void 0, e !== h && c(this, e);
                                              }

                                              function u(e, t, r) {
                                                this.promise = e, "function" == typeof t && (this.onFulfilled = t, this.callFulfilled = this.otherCallFulfilled), "function" == typeof r && (this.onRejected = r, this.callRejected = this.otherCallRejected);
                                              }

                                              function l(t, r, n) {
                                                i(function () {
                                                  var e;

                                                  try {
                                                    e = r(n);
                                                  } catch (e) {
                                                    return f.reject(t, e);
                                                  }

                                                  e === t ? f.reject(t, new TypeError("Cannot resolve promise with itself")) : f.resolve(t, e);
                                                });
                                              }

                                              function d(e) {
                                                var t = e && e.then;
                                                if (e && ("object" == typeof e || "function" == typeof e) && "function" == typeof t) return function () {
                                                  t.apply(e, arguments);
                                                };
                                              }

                                              function c(t, e) {
                                                var r = !1;

                                                function n(e) {
                                                  r || (r = !0, f.reject(t, e));
                                                }

                                                function i(e) {
                                                  r || (r = !0, f.resolve(t, e));
                                                }

                                                var s = p(function () {
                                                  e(i, n);
                                                });
                                                "error" === s.status && n(s.value);
                                              }

                                              function p(e, t) {
                                                var r = {};

                                                try {
                                                  r.value = e(t), r.status = "success";
                                                } catch (e) {
                                                  r.status = "error", r.value = e;
                                                }

                                                return r;
                                              }

                                              (t.exports = o).prototype["finally"] = function (t) {
                                                if ("function" != typeof t) return this;
                                                var r = this.constructor;
                                                return this.then(function (e) {
                                                  return r.resolve(t()).then(function () {
                                                    return e;
                                                  });
                                                }, function (e) {
                                                  return r.resolve(t()).then(function () {
                                                    throw e;
                                                  });
                                                });
                                              }, o.prototype["catch"] = function (e) {
                                                return this.then(null, e);
                                              }, o.prototype.then = function (e, t) {
                                                if ("function" != typeof e && this.state === a || "function" != typeof t && this.state === s) return this;
                                                var r = new this.constructor(h);
                                                return this.state !== n ? l(r, this.state === a ? e : t, this.outcome) : this.queue.push(new u(r, e, t)), r;
                                              }, u.prototype.callFulfilled = function (e) {
                                                f.resolve(this.promise, e);
                                              }, u.prototype.otherCallFulfilled = function (e) {
                                                l(this.promise, this.onFulfilled, e);
                                              }, u.prototype.callRejected = function (e) {
                                                f.reject(this.promise, e);
                                              }, u.prototype.otherCallRejected = function (e) {
                                                l(this.promise, this.onRejected, e);
                                              }, f.resolve = function (e, t) {
                                                var r = p(d, t);
                                                if ("error" === r.status) return f.reject(e, r.value);
                                                var n = r.value;
                                                if (n) c(e, n);else {
                                                  e.state = a, e.outcome = t;

                                                  for (var i = -1, s = e.queue.length; ++i < s;) {
                                                    e.queue[i].callFulfilled(t);
                                                  }
                                                }
                                                return e;
                                              }, f.reject = function (e, t) {
                                                e.state = s, e.outcome = t;

                                                for (var r = -1, n = e.queue.length; ++r < n;) {
                                                  e.queue[r].callRejected(t);
                                                }

                                                return e;
                                              }, o.resolve = function (e) {
                                                return e instanceof this ? e : f.resolve(new this(h), e);
                                              }, o.reject = function (e) {
                                                var t = new this(h);
                                                return f.reject(t, e);
                                              }, o.all = function (e) {
                                                var r = this;
                                                if ("[object Array]" !== Object.prototype.toString.call(e)) return this.reject(new TypeError("must be an array"));
                                                var n = e.length,
                                                    i = !1;
                                                if (!n) return this.resolve([]);

                                                for (var s = new Array(n), a = 0, t = -1, o = new this(h); ++t < n;) {
                                                  u(e[t], t);
                                                }

                                                return o;

                                                function u(e, t) {
                                                  r.resolve(e).then(function (e) {
                                                    s[t] = e, ++a !== n || i || (i = !0, f.resolve(o, s));
                                                  }, function (e) {
                                                    i || (i = !0, f.reject(o, e));
                                                  });
                                                }
                                              }, o.race = function (e) {
                                                if ("[object Array]" !== Object.prototype.toString.call(e)) return this.reject(new TypeError("must be an array"));
                                                var t = e.length,
                                                    r = !1;
                                                if (!t) return this.resolve([]);

                                                for (var n, i = -1, s = new this(h); ++i < t;) {
                                                  n = e[i], this.resolve(n).then(function (e) {
                                                    r || (r = !0, f.resolve(s, e));
                                                  }, function (e) {
                                                    r || (r = !0, f.reject(s, e));
                                                  });
                                                }

                                                return s;
                                              };
                                            }, {
                                              immediate: 36
                                            }],
                                            38: [function (e, t, r) {
                                              "use strict";

                                              var n = {};
                                              (0, e("./lib/utils/common").assign)(n, e("./lib/deflate"), e("./lib/inflate"), e("./lib/zlib/constants")), t.exports = n;
                                            }, {
                                              "./lib/deflate": 39,
                                              "./lib/inflate": 40,
                                              "./lib/utils/common": 41,
                                              "./lib/zlib/constants": 44
                                            }],
                                            39: [function (e, t, r) {
                                              "use strict";

                                              var a = e("./zlib/deflate"),
                                                  o = e("./utils/common"),
                                                  u = e("./utils/strings"),
                                                  i = e("./zlib/messages"),
                                                  s = e("./zlib/zstream"),
                                                  h = Object.prototype.toString,
                                                  f = 0,
                                                  l = -1,
                                                  d = 0,
                                                  c = 8;

                                              function p(e) {
                                                if (!(this instanceof p)) return new p(e);
                                                this.options = o.assign({
                                                  level: l,
                                                  method: c,
                                                  chunkSize: 16384,
                                                  windowBits: 15,
                                                  memLevel: 8,
                                                  strategy: d,
                                                  to: ""
                                                }, e || {});
                                                var t = this.options;
                                                t.raw && 0 < t.windowBits ? t.windowBits = -t.windowBits : t.gzip && 0 < t.windowBits && t.windowBits < 16 && (t.windowBits += 16), this.err = 0, this.msg = "", this.ended = !1, this.chunks = [], this.strm = new s(), this.strm.avail_out = 0;
                                                var r = a.deflateInit2(this.strm, t.level, t.method, t.windowBits, t.memLevel, t.strategy);
                                                if (r !== f) throw new Error(i[r]);

                                                if (t.header && a.deflateSetHeader(this.strm, t.header), t.dictionary) {
                                                  var n;
                                                  if (n = "string" == typeof t.dictionary ? u.string2buf(t.dictionary) : "[object ArrayBuffer]" === h.call(t.dictionary) ? new Uint8Array(t.dictionary) : t.dictionary, (r = a.deflateSetDictionary(this.strm, n)) !== f) throw new Error(i[r]);
                                                  this._dict_set = !0;
                                                }
                                              }

                                              function n(e, t) {
                                                var r = new p(t);
                                                if (r.push(e, !0), r.err) throw r.msg || i[r.err];
                                                return r.result;
                                              }

                                              p.prototype.push = function (e, t) {
                                                var r,
                                                    n,
                                                    i = this.strm,
                                                    s = this.options.chunkSize;
                                                if (this.ended) return !1;
                                                n = t === ~~t ? t : !0 === t ? 4 : 0, "string" == typeof e ? i.input = u.string2buf(e) : "[object ArrayBuffer]" === h.call(e) ? i.input = new Uint8Array(e) : i.input = e, i.next_in = 0, i.avail_in = i.input.length;

                                                do {
                                                  if (0 === i.avail_out && (i.output = new o.Buf8(s), i.next_out = 0, i.avail_out = s), 1 !== (r = a.deflate(i, n)) && r !== f) return this.onEnd(r), !(this.ended = !0);
                                                  0 !== i.avail_out && (0 !== i.avail_in || 4 !== n && 2 !== n) || ("string" === this.options.to ? this.onData(u.buf2binstring(o.shrinkBuf(i.output, i.next_out))) : this.onData(o.shrinkBuf(i.output, i.next_out)));
                                                } while ((0 < i.avail_in || 0 === i.avail_out) && 1 !== r);

                                                return 4 === n ? (r = a.deflateEnd(this.strm), this.onEnd(r), this.ended = !0, r === f) : 2 !== n || (this.onEnd(f), !(i.avail_out = 0));
                                              }, p.prototype.onData = function (e) {
                                                this.chunks.push(e);
                                              }, p.prototype.onEnd = function (e) {
                                                e === f && ("string" === this.options.to ? this.result = this.chunks.join("") : this.result = o.flattenChunks(this.chunks)), this.chunks = [], this.err = e, this.msg = this.strm.msg;
                                              }, r.Deflate = p, r.deflate = n, r.deflateRaw = function (e, t) {
                                                return (t = t || {}).raw = !0, n(e, t);
                                              }, r.gzip = function (e, t) {
                                                return (t = t || {}).gzip = !0, n(e, t);
                                              };
                                            }, {
                                              "./utils/common": 41,
                                              "./utils/strings": 42,
                                              "./zlib/deflate": 46,
                                              "./zlib/messages": 51,
                                              "./zlib/zstream": 53
                                            }],
                                            40: [function (e, t, r) {
                                              "use strict";

                                              var d = e("./zlib/inflate"),
                                                  c = e("./utils/common"),
                                                  p = e("./utils/strings"),
                                                  m = e("./zlib/constants"),
                                                  n = e("./zlib/messages"),
                                                  i = e("./zlib/zstream"),
                                                  s = e("./zlib/gzheader"),
                                                  _ = Object.prototype.toString;

                                              function a(e) {
                                                if (!(this instanceof a)) return new a(e);
                                                this.options = c.assign({
                                                  chunkSize: 16384,
                                                  windowBits: 0,
                                                  to: ""
                                                }, e || {});
                                                var t = this.options;
                                                t.raw && 0 <= t.windowBits && t.windowBits < 16 && (t.windowBits = -t.windowBits, 0 === t.windowBits && (t.windowBits = -15)), !(0 <= t.windowBits && t.windowBits < 16) || e && e.windowBits || (t.windowBits += 32), 15 < t.windowBits && t.windowBits < 48 && 0 == (15 & t.windowBits) && (t.windowBits |= 15), this.err = 0, this.msg = "", this.ended = !1, this.chunks = [], this.strm = new i(), this.strm.avail_out = 0;
                                                var r = d.inflateInit2(this.strm, t.windowBits);
                                                if (r !== m.Z_OK) throw new Error(n[r]);
                                                this.header = new s(), d.inflateGetHeader(this.strm, this.header);
                                              }

                                              function o(e, t) {
                                                var r = new a(t);
                                                if (r.push(e, !0), r.err) throw r.msg || n[r.err];
                                                return r.result;
                                              }

                                              a.prototype.push = function (e, t) {
                                                var r,
                                                    n,
                                                    i,
                                                    s,
                                                    a,
                                                    o,
                                                    u = this.strm,
                                                    h = this.options.chunkSize,
                                                    f = this.options.dictionary,
                                                    l = !1;
                                                if (this.ended) return !1;
                                                n = t === ~~t ? t : !0 === t ? m.Z_FINISH : m.Z_NO_FLUSH, "string" == typeof e ? u.input = p.binstring2buf(e) : "[object ArrayBuffer]" === _.call(e) ? u.input = new Uint8Array(e) : u.input = e, u.next_in = 0, u.avail_in = u.input.length;

                                                do {
                                                  if (0 === u.avail_out && (u.output = new c.Buf8(h), u.next_out = 0, u.avail_out = h), (r = d.inflate(u, m.Z_NO_FLUSH)) === m.Z_NEED_DICT && f && (o = "string" == typeof f ? p.string2buf(f) : "[object ArrayBuffer]" === _.call(f) ? new Uint8Array(f) : f, r = d.inflateSetDictionary(this.strm, o)), r === m.Z_BUF_ERROR && !0 === l && (r = m.Z_OK, l = !1), r !== m.Z_STREAM_END && r !== m.Z_OK) return this.onEnd(r), !(this.ended = !0);
                                                  u.next_out && (0 !== u.avail_out && r !== m.Z_STREAM_END && (0 !== u.avail_in || n !== m.Z_FINISH && n !== m.Z_SYNC_FLUSH) || ("string" === this.options.to ? (i = p.utf8border(u.output, u.next_out), s = u.next_out - i, a = p.buf2string(u.output, i), u.next_out = s, u.avail_out = h - s, s && c.arraySet(u.output, u.output, i, s, 0), this.onData(a)) : this.onData(c.shrinkBuf(u.output, u.next_out)))), 0 === u.avail_in && 0 === u.avail_out && (l = !0);
                                                } while ((0 < u.avail_in || 0 === u.avail_out) && r !== m.Z_STREAM_END);

                                                return r === m.Z_STREAM_END && (n = m.Z_FINISH), n === m.Z_FINISH ? (r = d.inflateEnd(this.strm), this.onEnd(r), this.ended = !0, r === m.Z_OK) : n !== m.Z_SYNC_FLUSH || (this.onEnd(m.Z_OK), !(u.avail_out = 0));
                                              }, a.prototype.onData = function (e) {
                                                this.chunks.push(e);
                                              }, a.prototype.onEnd = function (e) {
                                                e === m.Z_OK && ("string" === this.options.to ? this.result = this.chunks.join("") : this.result = c.flattenChunks(this.chunks)), this.chunks = [], this.err = e, this.msg = this.strm.msg;
                                              }, r.Inflate = a, r.inflate = o, r.inflateRaw = function (e, t) {
                                                return (t = t || {}).raw = !0, o(e, t);
                                              }, r.ungzip = o;
                                            }, {
                                              "./utils/common": 41,
                                              "./utils/strings": 42,
                                              "./zlib/constants": 44,
                                              "./zlib/gzheader": 47,
                                              "./zlib/inflate": 49,
                                              "./zlib/messages": 51,
                                              "./zlib/zstream": 53
                                            }],
                                            41: [function (e, t, r) {
                                              "use strict";

                                              var n = "undefined" != typeof Uint8Array && "undefined" != typeof Uint16Array && "undefined" != typeof Int32Array;
                                              r.assign = function (e) {
                                                for (var t = Array.prototype.slice.call(arguments, 1); t.length;) {
                                                  var r = t.shift();

                                                  if (r) {
                                                    if ("object" != typeof r) throw new TypeError(r + "must be non-object");

                                                    for (var n in r) {
                                                      r.hasOwnProperty(n) && (e[n] = r[n]);
                                                    }
                                                  }
                                                }

                                                return e;
                                              }, r.shrinkBuf = function (e, t) {
                                                return e.length === t ? e : e.subarray ? e.subarray(0, t) : (e.length = t, e);
                                              };
                                              var i = {
                                                arraySet: function arraySet(e, t, r, n, i) {
                                                  if (t.subarray && e.subarray) e.set(t.subarray(r, r + n), i);else for (var s = 0; s < n; s++) {
                                                    e[i + s] = t[r + s];
                                                  }
                                                },
                                                flattenChunks: function flattenChunks(e) {
                                                  var t, r, n, i, s, a;

                                                  for (t = n = 0, r = e.length; t < r; t++) {
                                                    n += e[t].length;
                                                  }

                                                  for (a = new Uint8Array(n), t = i = 0, r = e.length; t < r; t++) {
                                                    s = e[t], a.set(s, i), i += s.length;
                                                  }

                                                  return a;
                                                }
                                              },
                                                  s = {
                                                arraySet: function arraySet(e, t, r, n, i) {
                                                  for (var s = 0; s < n; s++) {
                                                    e[i + s] = t[r + s];
                                                  }
                                                },
                                                flattenChunks: function flattenChunks(e) {
                                                  return [].concat.apply([], e);
                                                }
                                              };
                                              r.setTyped = function (e) {
                                                e ? (r.Buf8 = Uint8Array, r.Buf16 = Uint16Array, r.Buf32 = Int32Array, r.assign(r, i)) : (r.Buf8 = Array, r.Buf16 = Array, r.Buf32 = Array, r.assign(r, s));
                                              }, r.setTyped(n);
                                            }, {}],
                                            42: [function (e, t, r) {
                                              "use strict";

                                              var u = e("./common"),
                                                  i = !0,
                                                  s = !0;

                                              try {
                                                String.fromCharCode.apply(null, [0]);
                                              } catch (e) {
                                                i = !1;
                                              }

                                              try {
                                                String.fromCharCode.apply(null, new Uint8Array(1));
                                              } catch (e) {
                                                s = !1;
                                              }

                                              for (var h = new u.Buf8(256), n = 0; n < 256; n++) {
                                                h[n] = 252 <= n ? 6 : 248 <= n ? 5 : 240 <= n ? 4 : 224 <= n ? 3 : 192 <= n ? 2 : 1;
                                              }

                                              function f(e, t) {
                                                if (t < 65537 && (e.subarray && s || !e.subarray && i)) return String.fromCharCode.apply(null, u.shrinkBuf(e, t));

                                                for (var r = "", n = 0; n < t; n++) {
                                                  r += String.fromCharCode(e[n]);
                                                }

                                                return r;
                                              }

                                              h[254] = h[254] = 1, r.string2buf = function (e) {
                                                var t,
                                                    r,
                                                    n,
                                                    i,
                                                    s,
                                                    a = e.length,
                                                    o = 0;

                                                for (i = 0; i < a; i++) {
                                                  55296 == (64512 & (r = e.charCodeAt(i))) && i + 1 < a && 56320 == (64512 & (n = e.charCodeAt(i + 1))) && (r = 65536 + (r - 55296 << 10) + (n - 56320), i++), o += r < 128 ? 1 : r < 2048 ? 2 : r < 65536 ? 3 : 4;
                                                }

                                                for (t = new u.Buf8(o), i = s = 0; s < o; i++) {
                                                  55296 == (64512 & (r = e.charCodeAt(i))) && i + 1 < a && 56320 == (64512 & (n = e.charCodeAt(i + 1))) && (r = 65536 + (r - 55296 << 10) + (n - 56320), i++), r < 128 ? t[s++] = r : (r < 2048 ? t[s++] = 192 | r >>> 6 : (r < 65536 ? t[s++] = 224 | r >>> 12 : (t[s++] = 240 | r >>> 18, t[s++] = 128 | r >>> 12 & 63), t[s++] = 128 | r >>> 6 & 63), t[s++] = 128 | 63 & r);
                                                }

                                                return t;
                                              }, r.buf2binstring = function (e) {
                                                return f(e, e.length);
                                              }, r.binstring2buf = function (e) {
                                                for (var t = new u.Buf8(e.length), r = 0, n = t.length; r < n; r++) {
                                                  t[r] = e.charCodeAt(r);
                                                }

                                                return t;
                                              }, r.buf2string = function (e, t) {
                                                var r,
                                                    n,
                                                    i,
                                                    s,
                                                    a = t || e.length,
                                                    o = new Array(2 * a);

                                                for (r = n = 0; r < a;) {
                                                  if ((i = e[r++]) < 128) o[n++] = i;else if (4 < (s = h[i])) o[n++] = 65533, r += s - 1;else {
                                                    for (i &= 2 === s ? 31 : 3 === s ? 15 : 7; 1 < s && r < a;) {
                                                      i = i << 6 | 63 & e[r++], s--;
                                                    }

                                                    1 < s ? o[n++] = 65533 : i < 65536 ? o[n++] = i : (i -= 65536, o[n++] = 55296 | i >> 10 & 1023, o[n++] = 56320 | 1023 & i);
                                                  }
                                                }

                                                return f(o, n);
                                              }, r.utf8border = function (e, t) {
                                                var r;

                                                for ((t = t || e.length) > e.length && (t = e.length), r = t - 1; 0 <= r && 128 == (192 & e[r]);) {
                                                  r--;
                                                }

                                                return r < 0 ? t : 0 === r ? t : r + h[e[r]] > t ? r : t;
                                              };
                                            }, {
                                              "./common": 41
                                            }],
                                            43: [function (e, t, r) {
                                              "use strict";

                                              t.exports = function (e, t, r, n) {
                                                for (var i = 65535 & e | 0, s = e >>> 16 & 65535 | 0, a = 0; 0 !== r;) {
                                                  for (r -= a = 2e3 < r ? 2e3 : r; s = s + (i = i + t[n++] | 0) | 0, --a;) {
                                                    ;
                                                  }

                                                  i %= 65521, s %= 65521;
                                                }

                                                return i | s << 16 | 0;
                                              };
                                            }, {}],
                                            44: [function (e, t, r) {
                                              "use strict";

                                              t.exports = {
                                                Z_NO_FLUSH: 0,
                                                Z_PARTIAL_FLUSH: 1,
                                                Z_SYNC_FLUSH: 2,
                                                Z_FULL_FLUSH: 3,
                                                Z_FINISH: 4,
                                                Z_BLOCK: 5,
                                                Z_TREES: 6,
                                                Z_OK: 0,
                                                Z_STREAM_END: 1,
                                                Z_NEED_DICT: 2,
                                                Z_ERRNO: -1,
                                                Z_STREAM_ERROR: -2,
                                                Z_DATA_ERROR: -3,
                                                Z_BUF_ERROR: -5,
                                                Z_NO_COMPRESSION: 0,
                                                Z_BEST_SPEED: 1,
                                                Z_BEST_COMPRESSION: 9,
                                                Z_DEFAULT_COMPRESSION: -1,
                                                Z_FILTERED: 1,
                                                Z_HUFFMAN_ONLY: 2,
                                                Z_RLE: 3,
                                                Z_FIXED: 4,
                                                Z_DEFAULT_STRATEGY: 0,
                                                Z_BINARY: 0,
                                                Z_TEXT: 1,
                                                Z_UNKNOWN: 2,
                                                Z_DEFLATED: 8
                                              };
                                            }, {}],
                                            45: [function (e, t, r) {
                                              "use strict";

                                              var o = function () {
                                                for (var e, t = [], r = 0; r < 256; r++) {
                                                  e = r;

                                                  for (var n = 0; n < 8; n++) {
                                                    e = 1 & e ? 3988292384 ^ e >>> 1 : e >>> 1;
                                                  }

                                                  t[r] = e;
                                                }

                                                return t;
                                              }();

                                              t.exports = function (e, t, r, n) {
                                                var i = o,
                                                    s = n + r;
                                                e ^= -1;

                                                for (var a = n; a < s; a++) {
                                                  e = e >>> 8 ^ i[255 & (e ^ t[a])];
                                                }

                                                return -1 ^ e;
                                              };
                                            }, {}],
                                            46: [function (e, t, r) {
                                              "use strict";

                                              var u,
                                                  d = e("../utils/common"),
                                                  h = e("./trees"),
                                                  c = e("./adler32"),
                                                  p = e("./crc32"),
                                                  n = e("./messages"),
                                                  f = 0,
                                                  l = 0,
                                                  m = -2,
                                                  i = 2,
                                                  _ = 8,
                                                  s = 286,
                                                  a = 30,
                                                  o = 19,
                                                  g = 2 * s + 1,
                                                  v = 15,
                                                  b = 3,
                                                  w = 258,
                                                  y = w + b + 1,
                                                  k = 42,
                                                  x = 113;

                                              function S(e, t) {
                                                return e.msg = n[t], t;
                                              }

                                              function z(e) {
                                                return (e << 1) - (4 < e ? 9 : 0);
                                              }

                                              function E(e) {
                                                for (var t = e.length; 0 <= --t;) {
                                                  e[t] = 0;
                                                }
                                              }

                                              function C(e) {
                                                var t = e.state,
                                                    r = t.pending;
                                                r > e.avail_out && (r = e.avail_out), 0 !== r && (d.arraySet(e.output, t.pending_buf, t.pending_out, r, e.next_out), e.next_out += r, t.pending_out += r, e.total_out += r, e.avail_out -= r, t.pending -= r, 0 === t.pending && (t.pending_out = 0));
                                              }

                                              function A(e, t) {
                                                h._tr_flush_block(e, 0 <= e.block_start ? e.block_start : -1, e.strstart - e.block_start, t), e.block_start = e.strstart, C(e.strm);
                                              }

                                              function I(e, t) {
                                                e.pending_buf[e.pending++] = t;
                                              }

                                              function O(e, t) {
                                                e.pending_buf[e.pending++] = t >>> 8 & 255, e.pending_buf[e.pending++] = 255 & t;
                                              }

                                              function B(e, t) {
                                                var r,
                                                    n,
                                                    i = e.max_chain_length,
                                                    s = e.strstart,
                                                    a = e.prev_length,
                                                    o = e.nice_match,
                                                    u = e.strstart > e.w_size - y ? e.strstart - (e.w_size - y) : 0,
                                                    h = e.window,
                                                    f = e.w_mask,
                                                    l = e.prev,
                                                    d = e.strstart + w,
                                                    c = h[s + a - 1],
                                                    p = h[s + a];
                                                e.prev_length >= e.good_match && (i >>= 2), o > e.lookahead && (o = e.lookahead);

                                                do {
                                                  if (h[(r = t) + a] === p && h[r + a - 1] === c && h[r] === h[s] && h[++r] === h[s + 1]) {
                                                    s += 2, r++;

                                                    do {} while (h[++s] === h[++r] && h[++s] === h[++r] && h[++s] === h[++r] && h[++s] === h[++r] && h[++s] === h[++r] && h[++s] === h[++r] && h[++s] === h[++r] && h[++s] === h[++r] && s < d);

                                                    if (n = w - (d - s), s = d - w, a < n) {
                                                      if (e.match_start = t, o <= (a = n)) break;
                                                      c = h[s + a - 1], p = h[s + a];
                                                    }
                                                  }
                                                } while ((t = l[t & f]) > u && 0 != --i);

                                                return a <= e.lookahead ? a : e.lookahead;
                                              }

                                              function T(e) {
                                                var t,
                                                    r,
                                                    n,
                                                    i,
                                                    s,
                                                    a,
                                                    o,
                                                    u,
                                                    h,
                                                    f,
                                                    l = e.w_size;

                                                do {
                                                  if (i = e.window_size - e.lookahead - e.strstart, e.strstart >= l + (l - y)) {
                                                    for (d.arraySet(e.window, e.window, l, l, 0), e.match_start -= l, e.strstart -= l, e.block_start -= l, t = r = e.hash_size; n = e.head[--t], e.head[t] = l <= n ? n - l : 0, --r;) {
                                                      ;
                                                    }

                                                    for (t = r = l; n = e.prev[--t], e.prev[t] = l <= n ? n - l : 0, --r;) {
                                                      ;
                                                    }

                                                    i += l;
                                                  }

                                                  if (0 === e.strm.avail_in) break;
                                                  if (a = e.strm, o = e.window, u = e.strstart + e.lookahead, f = void 0, (h = i) < (f = a.avail_in) && (f = h), r = 0 === f ? 0 : (a.avail_in -= f, d.arraySet(o, a.input, a.next_in, f, u), 1 === a.state.wrap ? a.adler = c(a.adler, o, f, u) : 2 === a.state.wrap && (a.adler = p(a.adler, o, f, u)), a.next_in += f, a.total_in += f, f), e.lookahead += r, e.lookahead + e.insert >= b) for (s = e.strstart - e.insert, e.ins_h = e.window[s], e.ins_h = (e.ins_h << e.hash_shift ^ e.window[s + 1]) & e.hash_mask; e.insert && (e.ins_h = (e.ins_h << e.hash_shift ^ e.window[s + b - 1]) & e.hash_mask, e.prev[s & e.w_mask] = e.head[e.ins_h], e.head[e.ins_h] = s, s++, e.insert--, !(e.lookahead + e.insert < b));) {
                                                    ;
                                                  }
                                                } while (e.lookahead < y && 0 !== e.strm.avail_in);
                                              }

                                              function R(e, t) {
                                                for (var r, n;;) {
                                                  if (e.lookahead < y) {
                                                    if (T(e), e.lookahead < y && t === f) return 1;
                                                    if (0 === e.lookahead) break;
                                                  }

                                                  if (r = 0, e.lookahead >= b && (e.ins_h = (e.ins_h << e.hash_shift ^ e.window[e.strstart + b - 1]) & e.hash_mask, r = e.prev[e.strstart & e.w_mask] = e.head[e.ins_h], e.head[e.ins_h] = e.strstart), 0 !== r && e.strstart - r <= e.w_size - y && (e.match_length = B(e, r)), e.match_length >= b) {
                                                    if (n = h._tr_tally(e, e.strstart - e.match_start, e.match_length - b), e.lookahead -= e.match_length, e.match_length <= e.max_lazy_match && e.lookahead >= b) {
                                                      for (e.match_length--; e.strstart++, e.ins_h = (e.ins_h << e.hash_shift ^ e.window[e.strstart + b - 1]) & e.hash_mask, r = e.prev[e.strstart & e.w_mask] = e.head[e.ins_h], e.head[e.ins_h] = e.strstart, 0 != --e.match_length;) {
                                                        ;
                                                      }

                                                      e.strstart++;
                                                    } else e.strstart += e.match_length, e.match_length = 0, e.ins_h = e.window[e.strstart], e.ins_h = (e.ins_h << e.hash_shift ^ e.window[e.strstart + 1]) & e.hash_mask;
                                                  } else n = h._tr_tally(e, 0, e.window[e.strstart]), e.lookahead--, e.strstart++;
                                                  if (n && (A(e, !1), 0 === e.strm.avail_out)) return 1;
                                                }

                                                return e.insert = e.strstart < b - 1 ? e.strstart : b - 1, 4 === t ? (A(e, !0), 0 === e.strm.avail_out ? 3 : 4) : e.last_lit && (A(e, !1), 0 === e.strm.avail_out) ? 1 : 2;
                                              }

                                              function D(e, t) {
                                                for (var r, n, i;;) {
                                                  if (e.lookahead < y) {
                                                    if (T(e), e.lookahead < y && t === f) return 1;
                                                    if (0 === e.lookahead) break;
                                                  }

                                                  if (r = 0, e.lookahead >= b && (e.ins_h = (e.ins_h << e.hash_shift ^ e.window[e.strstart + b - 1]) & e.hash_mask, r = e.prev[e.strstart & e.w_mask] = e.head[e.ins_h], e.head[e.ins_h] = e.strstart), e.prev_length = e.match_length, e.prev_match = e.match_start, e.match_length = b - 1, 0 !== r && e.prev_length < e.max_lazy_match && e.strstart - r <= e.w_size - y && (e.match_length = B(e, r), e.match_length <= 5 && (1 === e.strategy || e.match_length === b && 4096 < e.strstart - e.match_start) && (e.match_length = b - 1)), e.prev_length >= b && e.match_length <= e.prev_length) {
                                                    for (i = e.strstart + e.lookahead - b, n = h._tr_tally(e, e.strstart - 1 - e.prev_match, e.prev_length - b), e.lookahead -= e.prev_length - 1, e.prev_length -= 2; ++e.strstart <= i && (e.ins_h = (e.ins_h << e.hash_shift ^ e.window[e.strstart + b - 1]) & e.hash_mask, r = e.prev[e.strstart & e.w_mask] = e.head[e.ins_h], e.head[e.ins_h] = e.strstart), 0 != --e.prev_length;) {
                                                      ;
                                                    }

                                                    if (e.match_available = 0, e.match_length = b - 1, e.strstart++, n && (A(e, !1), 0 === e.strm.avail_out)) return 1;
                                                  } else if (e.match_available) {
                                                    if ((n = h._tr_tally(e, 0, e.window[e.strstart - 1])) && A(e, !1), e.strstart++, e.lookahead--, 0 === e.strm.avail_out) return 1;
                                                  } else e.match_available = 1, e.strstart++, e.lookahead--;
                                                }

                                                return e.match_available && (n = h._tr_tally(e, 0, e.window[e.strstart - 1]), e.match_available = 0), e.insert = e.strstart < b - 1 ? e.strstart : b - 1, 4 === t ? (A(e, !0), 0 === e.strm.avail_out ? 3 : 4) : e.last_lit && (A(e, !1), 0 === e.strm.avail_out) ? 1 : 2;
                                              }

                                              function F(e, t, r, n, i) {
                                                this.good_length = e, this.max_lazy = t, this.nice_length = r, this.max_chain = n, this.func = i;
                                              }

                                              function N() {
                                                this.strm = null, this.status = 0, this.pending_buf = null, this.pending_buf_size = 0, this.pending_out = 0, this.pending = 0, this.wrap = 0, this.gzhead = null, this.gzindex = 0, this.method = _, this.last_flush = -1, this.w_size = 0, this.w_bits = 0, this.w_mask = 0, this.window = null, this.window_size = 0, this.prev = null, this.head = null, this.ins_h = 0, this.hash_size = 0, this.hash_bits = 0, this.hash_mask = 0, this.hash_shift = 0, this.block_start = 0, this.match_length = 0, this.prev_match = 0, this.match_available = 0, this.strstart = 0, this.match_start = 0, this.lookahead = 0, this.prev_length = 0, this.max_chain_length = 0, this.max_lazy_match = 0, this.level = 0, this.strategy = 0, this.good_match = 0, this.nice_match = 0, this.dyn_ltree = new d.Buf16(2 * g), this.dyn_dtree = new d.Buf16(2 * (2 * a + 1)), this.bl_tree = new d.Buf16(2 * (2 * o + 1)), E(this.dyn_ltree), E(this.dyn_dtree), E(this.bl_tree), this.l_desc = null, this.d_desc = null, this.bl_desc = null, this.bl_count = new d.Buf16(v + 1), this.heap = new d.Buf16(2 * s + 1), E(this.heap), this.heap_len = 0, this.heap_max = 0, this.depth = new d.Buf16(2 * s + 1), E(this.depth), this.l_buf = 0, this.lit_bufsize = 0, this.last_lit = 0, this.d_buf = 0, this.opt_len = 0, this.static_len = 0, this.matches = 0, this.insert = 0, this.bi_buf = 0, this.bi_valid = 0;
                                              }

                                              function U(e) {
                                                var t;
                                                return e && e.state ? (e.total_in = e.total_out = 0, e.data_type = i, (t = e.state).pending = 0, t.pending_out = 0, t.wrap < 0 && (t.wrap = -t.wrap), t.status = t.wrap ? k : x, e.adler = 2 === t.wrap ? 0 : 1, t.last_flush = f, h._tr_init(t), l) : S(e, m);
                                              }

                                              function P(e) {
                                                var t,
                                                    r = U(e);
                                                return r === l && ((t = e.state).window_size = 2 * t.w_size, E(t.head), t.max_lazy_match = u[t.level].max_lazy, t.good_match = u[t.level].good_length, t.nice_match = u[t.level].nice_length, t.max_chain_length = u[t.level].max_chain, t.strstart = 0, t.block_start = 0, t.lookahead = 0, t.insert = 0, t.match_length = t.prev_length = b - 1, t.match_available = 0, t.ins_h = 0), r;
                                              }

                                              function L(e, t, r, n, i, s) {
                                                if (!e) return m;
                                                var a = 1;
                                                if (-1 === t && (t = 6), n < 0 ? (a = 0, n = -n) : 15 < n && (a = 2, n -= 16), i < 1 || 9 < i || r !== _ || n < 8 || 15 < n || t < 0 || 9 < t || s < 0 || 4 < s) return S(e, m);
                                                8 === n && (n = 9);
                                                var o = new N();
                                                return (e.state = o).strm = e, o.wrap = a, o.gzhead = null, o.w_bits = n, o.w_size = 1 << o.w_bits, o.w_mask = o.w_size - 1, o.hash_bits = i + 7, o.hash_size = 1 << o.hash_bits, o.hash_mask = o.hash_size - 1, o.hash_shift = ~~((o.hash_bits + b - 1) / b), o.window = new d.Buf8(2 * o.w_size), o.head = new d.Buf16(o.hash_size), o.prev = new d.Buf16(o.w_size), o.lit_bufsize = 1 << i + 6, o.pending_buf_size = 4 * o.lit_bufsize, o.pending_buf = new d.Buf8(o.pending_buf_size), o.d_buf = 1 * o.lit_bufsize, o.l_buf = 3 * o.lit_bufsize, o.level = t, o.strategy = s, o.method = r, P(e);
                                              }

                                              u = [new F(0, 0, 0, 0, function (e, t) {
                                                var r = 65535;

                                                for (r > e.pending_buf_size - 5 && (r = e.pending_buf_size - 5);;) {
                                                  if (e.lookahead <= 1) {
                                                    if (T(e), 0 === e.lookahead && t === f) return 1;
                                                    if (0 === e.lookahead) break;
                                                  }

                                                  e.strstart += e.lookahead, e.lookahead = 0;
                                                  var n = e.block_start + r;
                                                  if ((0 === e.strstart || e.strstart >= n) && (e.lookahead = e.strstart - n, e.strstart = n, A(e, !1), 0 === e.strm.avail_out)) return 1;
                                                  if (e.strstart - e.block_start >= e.w_size - y && (A(e, !1), 0 === e.strm.avail_out)) return 1;
                                                }

                                                return e.insert = 0, 4 === t ? (A(e, !0), 0 === e.strm.avail_out ? 3 : 4) : (e.strstart > e.block_start && (A(e, !1), e.strm.avail_out), 1);
                                              }), new F(4, 4, 8, 4, R), new F(4, 5, 16, 8, R), new F(4, 6, 32, 32, R), new F(4, 4, 16, 16, D), new F(8, 16, 32, 32, D), new F(8, 16, 128, 128, D), new F(8, 32, 128, 256, D), new F(32, 128, 258, 1024, D), new F(32, 258, 258, 4096, D)], r.deflateInit = function (e, t) {
                                                return L(e, t, _, 15, 8, 0);
                                              }, r.deflateInit2 = L, r.deflateReset = P, r.deflateResetKeep = U, r.deflateSetHeader = function (e, t) {
                                                return e && e.state ? 2 !== e.state.wrap ? m : (e.state.gzhead = t, l) : m;
                                              }, r.deflate = function (e, t) {
                                                var r, n, i, s;
                                                if (!e || !e.state || 5 < t || t < 0) return e ? S(e, m) : m;
                                                if (n = e.state, !e.output || !e.input && 0 !== e.avail_in || 666 === n.status && 4 !== t) return S(e, 0 === e.avail_out ? -5 : m);
                                                if (n.strm = e, r = n.last_flush, n.last_flush = t, n.status === k) if (2 === n.wrap) e.adler = 0, I(n, 31), I(n, 139), I(n, 8), n.gzhead ? (I(n, (n.gzhead.text ? 1 : 0) + (n.gzhead.hcrc ? 2 : 0) + (n.gzhead.extra ? 4 : 0) + (n.gzhead.name ? 8 : 0) + (n.gzhead.comment ? 16 : 0)), I(n, 255 & n.gzhead.time), I(n, n.gzhead.time >> 8 & 255), I(n, n.gzhead.time >> 16 & 255), I(n, n.gzhead.time >> 24 & 255), I(n, 9 === n.level ? 2 : 2 <= n.strategy || n.level < 2 ? 4 : 0), I(n, 255 & n.gzhead.os), n.gzhead.extra && n.gzhead.extra.length && (I(n, 255 & n.gzhead.extra.length), I(n, n.gzhead.extra.length >> 8 & 255)), n.gzhead.hcrc && (e.adler = p(e.adler, n.pending_buf, n.pending, 0)), n.gzindex = 0, n.status = 69) : (I(n, 0), I(n, 0), I(n, 0), I(n, 0), I(n, 0), I(n, 9 === n.level ? 2 : 2 <= n.strategy || n.level < 2 ? 4 : 0), I(n, 3), n.status = x);else {
                                                  var a = _ + (n.w_bits - 8 << 4) << 8;
                                                  a |= (2 <= n.strategy || n.level < 2 ? 0 : n.level < 6 ? 1 : 6 === n.level ? 2 : 3) << 6, 0 !== n.strstart && (a |= 32), a += 31 - a % 31, n.status = x, O(n, a), 0 !== n.strstart && (O(n, e.adler >>> 16), O(n, 65535 & e.adler)), e.adler = 1;
                                                }
                                                if (69 === n.status) if (n.gzhead.extra) {
                                                  for (i = n.pending; n.gzindex < (65535 & n.gzhead.extra.length) && (n.pending !== n.pending_buf_size || (n.gzhead.hcrc && n.pending > i && (e.adler = p(e.adler, n.pending_buf, n.pending - i, i)), C(e), i = n.pending, n.pending !== n.pending_buf_size));) {
                                                    I(n, 255 & n.gzhead.extra[n.gzindex]), n.gzindex++;
                                                  }

                                                  n.gzhead.hcrc && n.pending > i && (e.adler = p(e.adler, n.pending_buf, n.pending - i, i)), n.gzindex === n.gzhead.extra.length && (n.gzindex = 0, n.status = 73);
                                                } else n.status = 73;
                                                if (73 === n.status) if (n.gzhead.name) {
                                                  i = n.pending;

                                                  do {
                                                    if (n.pending === n.pending_buf_size && (n.gzhead.hcrc && n.pending > i && (e.adler = p(e.adler, n.pending_buf, n.pending - i, i)), C(e), i = n.pending, n.pending === n.pending_buf_size)) {
                                                      s = 1;
                                                      break;
                                                    }

                                                    s = n.gzindex < n.gzhead.name.length ? 255 & n.gzhead.name.charCodeAt(n.gzindex++) : 0, I(n, s);
                                                  } while (0 !== s);

                                                  n.gzhead.hcrc && n.pending > i && (e.adler = p(e.adler, n.pending_buf, n.pending - i, i)), 0 === s && (n.gzindex = 0, n.status = 91);
                                                } else n.status = 91;
                                                if (91 === n.status) if (n.gzhead.comment) {
                                                  i = n.pending;

                                                  do {
                                                    if (n.pending === n.pending_buf_size && (n.gzhead.hcrc && n.pending > i && (e.adler = p(e.adler, n.pending_buf, n.pending - i, i)), C(e), i = n.pending, n.pending === n.pending_buf_size)) {
                                                      s = 1;
                                                      break;
                                                    }

                                                    s = n.gzindex < n.gzhead.comment.length ? 255 & n.gzhead.comment.charCodeAt(n.gzindex++) : 0, I(n, s);
                                                  } while (0 !== s);

                                                  n.gzhead.hcrc && n.pending > i && (e.adler = p(e.adler, n.pending_buf, n.pending - i, i)), 0 === s && (n.status = 103);
                                                } else n.status = 103;

                                                if (103 === n.status && (n.gzhead.hcrc ? (n.pending + 2 > n.pending_buf_size && C(e), n.pending + 2 <= n.pending_buf_size && (I(n, 255 & e.adler), I(n, e.adler >> 8 & 255), e.adler = 0, n.status = x)) : n.status = x), 0 !== n.pending) {
                                                  if (C(e), 0 === e.avail_out) return n.last_flush = -1, l;
                                                } else if (0 === e.avail_in && z(t) <= z(r) && 4 !== t) return S(e, -5);

                                                if (666 === n.status && 0 !== e.avail_in) return S(e, -5);

                                                if (0 !== e.avail_in || 0 !== n.lookahead || t !== f && 666 !== n.status) {
                                                  var o = 2 === n.strategy ? function (e, t) {
                                                    for (var r;;) {
                                                      if (0 === e.lookahead && (T(e), 0 === e.lookahead)) {
                                                        if (t === f) return 1;
                                                        break;
                                                      }

                                                      if (e.match_length = 0, r = h._tr_tally(e, 0, e.window[e.strstart]), e.lookahead--, e.strstart++, r && (A(e, !1), 0 === e.strm.avail_out)) return 1;
                                                    }

                                                    return e.insert = 0, 4 === t ? (A(e, !0), 0 === e.strm.avail_out ? 3 : 4) : e.last_lit && (A(e, !1), 0 === e.strm.avail_out) ? 1 : 2;
                                                  }(n, t) : 3 === n.strategy ? function (e, t) {
                                                    for (var r, n, i, s, a = e.window;;) {
                                                      if (e.lookahead <= w) {
                                                        if (T(e), e.lookahead <= w && t === f) return 1;
                                                        if (0 === e.lookahead) break;
                                                      }

                                                      if (e.match_length = 0, e.lookahead >= b && 0 < e.strstart && (n = a[i = e.strstart - 1]) === a[++i] && n === a[++i] && n === a[++i]) {
                                                        s = e.strstart + w;

                                                        do {} while (n === a[++i] && n === a[++i] && n === a[++i] && n === a[++i] && n === a[++i] && n === a[++i] && n === a[++i] && n === a[++i] && i < s);

                                                        e.match_length = w - (s - i), e.match_length > e.lookahead && (e.match_length = e.lookahead);
                                                      }

                                                      if (e.match_length >= b ? (r = h._tr_tally(e, 1, e.match_length - b), e.lookahead -= e.match_length, e.strstart += e.match_length, e.match_length = 0) : (r = h._tr_tally(e, 0, e.window[e.strstart]), e.lookahead--, e.strstart++), r && (A(e, !1), 0 === e.strm.avail_out)) return 1;
                                                    }

                                                    return e.insert = 0, 4 === t ? (A(e, !0), 0 === e.strm.avail_out ? 3 : 4) : e.last_lit && (A(e, !1), 0 === e.strm.avail_out) ? 1 : 2;
                                                  }(n, t) : u[n.level].func(n, t);
                                                  if (3 !== o && 4 !== o || (n.status = 666), 1 === o || 3 === o) return 0 === e.avail_out && (n.last_flush = -1), l;
                                                  if (2 === o && (1 === t ? h._tr_align(n) : 5 !== t && (h._tr_stored_block(n, 0, 0, !1), 3 === t && (E(n.head), 0 === n.lookahead && (n.strstart = 0, n.block_start = 0, n.insert = 0))), C(e), 0 === e.avail_out)) return n.last_flush = -1, l;
                                                }

                                                return 4 !== t ? l : n.wrap <= 0 ? 1 : (2 === n.wrap ? (I(n, 255 & e.adler), I(n, e.adler >> 8 & 255), I(n, e.adler >> 16 & 255), I(n, e.adler >> 24 & 255), I(n, 255 & e.total_in), I(n, e.total_in >> 8 & 255), I(n, e.total_in >> 16 & 255), I(n, e.total_in >> 24 & 255)) : (O(n, e.adler >>> 16), O(n, 65535 & e.adler)), C(e), 0 < n.wrap && (n.wrap = -n.wrap), 0 !== n.pending ? l : 1);
                                              }, r.deflateEnd = function (e) {
                                                var t;
                                                return e && e.state ? (t = e.state.status) !== k && 69 !== t && 73 !== t && 91 !== t && 103 !== t && t !== x && 666 !== t ? S(e, m) : (e.state = null, t === x ? S(e, -3) : l) : m;
                                              }, r.deflateSetDictionary = function (e, t) {
                                                var r,
                                                    n,
                                                    i,
                                                    s,
                                                    a,
                                                    o,
                                                    u,
                                                    h,
                                                    f = t.length;
                                                if (!e || !e.state) return m;
                                                if (2 === (s = (r = e.state).wrap) || 1 === s && r.status !== k || r.lookahead) return m;

                                                for (1 === s && (e.adler = c(e.adler, t, f, 0)), r.wrap = 0, f >= r.w_size && (0 === s && (E(r.head), r.strstart = 0, r.block_start = 0, r.insert = 0), h = new d.Buf8(r.w_size), d.arraySet(h, t, f - r.w_size, r.w_size, 0), t = h, f = r.w_size), a = e.avail_in, o = e.next_in, u = e.input, e.avail_in = f, e.next_in = 0, e.input = t, T(r); r.lookahead >= b;) {
                                                  for (n = r.strstart, i = r.lookahead - (b - 1); r.ins_h = (r.ins_h << r.hash_shift ^ r.window[n + b - 1]) & r.hash_mask, r.prev[n & r.w_mask] = r.head[r.ins_h], r.head[r.ins_h] = n, n++, --i;) {
                                                    ;
                                                  }

                                                  r.strstart = n, r.lookahead = b - 1, T(r);
                                                }

                                                return r.strstart += r.lookahead, r.block_start = r.strstart, r.insert = r.lookahead, r.lookahead = 0, r.match_length = r.prev_length = b - 1, r.match_available = 0, e.next_in = o, e.input = u, e.avail_in = a, r.wrap = s, l;
                                              }, r.deflateInfo = "pako deflate (from Nodeca project)";
                                            }, {
                                              "../utils/common": 41,
                                              "./adler32": 43,
                                              "./crc32": 45,
                                              "./messages": 51,
                                              "./trees": 52
                                            }],
                                            47: [function (e, t, r) {
                                              "use strict";

                                              t.exports = function () {
                                                this.text = 0, this.time = 0, this.xflags = 0, this.os = 0, this.extra = null, this.extra_len = 0, this.name = "", this.comment = "", this.hcrc = 0, this.done = !1;
                                              };
                                            }, {}],
                                            48: [function (e, t, r) {
                                              "use strict";

                                              t.exports = function (e, t) {
                                                var r, n, i, s, a, o, u, h, f, l, d, c, p, m, _, g, v, b, w, y, k, x, S, z, E;

                                                r = e.state, n = e.next_in, z = e.input, i = n + (e.avail_in - 5), s = e.next_out, E = e.output, a = s - (t - e.avail_out), o = s + (e.avail_out - 257), u = r.dmax, h = r.wsize, f = r.whave, l = r.wnext, d = r.window, c = r.hold, p = r.bits, m = r.lencode, _ = r.distcode, g = (1 << r.lenbits) - 1, v = (1 << r.distbits) - 1;

                                                e: do {
                                                  p < 15 && (c += z[n++] << p, p += 8, c += z[n++] << p, p += 8), b = m[c & g];

                                                  t: for (;;) {
                                                    if (c >>>= w = b >>> 24, p -= w, 0 == (w = b >>> 16 & 255)) E[s++] = 65535 & b;else {
                                                      if (!(16 & w)) {
                                                        if (0 == (64 & w)) {
                                                          b = m[(65535 & b) + (c & (1 << w) - 1)];
                                                          continue t;
                                                        }

                                                        if (32 & w) {
                                                          r.mode = 12;
                                                          break e;
                                                        }

                                                        e.msg = "invalid literal/length code", r.mode = 30;
                                                        break e;
                                                      }

                                                      y = 65535 & b, (w &= 15) && (p < w && (c += z[n++] << p, p += 8), y += c & (1 << w) - 1, c >>>= w, p -= w), p < 15 && (c += z[n++] << p, p += 8, c += z[n++] << p, p += 8), b = _[c & v];

                                                      r: for (;;) {
                                                        if (c >>>= w = b >>> 24, p -= w, !(16 & (w = b >>> 16 & 255))) {
                                                          if (0 == (64 & w)) {
                                                            b = _[(65535 & b) + (c & (1 << w) - 1)];
                                                            continue r;
                                                          }

                                                          e.msg = "invalid distance code", r.mode = 30;
                                                          break e;
                                                        }

                                                        if (k = 65535 & b, p < (w &= 15) && (c += z[n++] << p, (p += 8) < w && (c += z[n++] << p, p += 8)), u < (k += c & (1 << w) - 1)) {
                                                          e.msg = "invalid distance too far back", r.mode = 30;
                                                          break e;
                                                        }

                                                        if (c >>>= w, p -= w, (w = s - a) < k) {
                                                          if (f < (w = k - w) && r.sane) {
                                                            e.msg = "invalid distance too far back", r.mode = 30;
                                                            break e;
                                                          }

                                                          if (S = d, (x = 0) === l) {
                                                            if (x += h - w, w < y) {
                                                              for (y -= w; E[s++] = d[x++], --w;) {
                                                                ;
                                                              }

                                                              x = s - k, S = E;
                                                            }
                                                          } else if (l < w) {
                                                            if (x += h + l - w, (w -= l) < y) {
                                                              for (y -= w; E[s++] = d[x++], --w;) {
                                                                ;
                                                              }

                                                              if (x = 0, l < y) {
                                                                for (y -= w = l; E[s++] = d[x++], --w;) {
                                                                  ;
                                                                }

                                                                x = s - k, S = E;
                                                              }
                                                            }
                                                          } else if (x += l - w, w < y) {
                                                            for (y -= w; E[s++] = d[x++], --w;) {
                                                              ;
                                                            }

                                                            x = s - k, S = E;
                                                          }

                                                          for (; 2 < y;) {
                                                            E[s++] = S[x++], E[s++] = S[x++], E[s++] = S[x++], y -= 3;
                                                          }

                                                          y && (E[s++] = S[x++], 1 < y && (E[s++] = S[x++]));
                                                        } else {
                                                          for (x = s - k; E[s++] = E[x++], E[s++] = E[x++], E[s++] = E[x++], 2 < (y -= 3);) {
                                                            ;
                                                          }

                                                          y && (E[s++] = E[x++], 1 < y && (E[s++] = E[x++]));
                                                        }

                                                        break;
                                                      }
                                                    }
                                                    break;
                                                  }
                                                } while (n < i && s < o);

                                                n -= y = p >> 3, c &= (1 << (p -= y << 3)) - 1, e.next_in = n, e.next_out = s, e.avail_in = n < i ? i - n + 5 : 5 - (n - i), e.avail_out = s < o ? o - s + 257 : 257 - (s - o), r.hold = c, r.bits = p;
                                              };
                                            }, {}],
                                            49: [function (e, t, r) {
                                              "use strict";

                                              var I = e("../utils/common"),
                                                  O = e("./adler32"),
                                                  B = e("./crc32"),
                                                  T = e("./inffast"),
                                                  R = e("./inftrees"),
                                                  D = 1,
                                                  F = 2,
                                                  N = 0,
                                                  U = -2,
                                                  P = 1,
                                                  n = 852,
                                                  i = 592;

                                              function L(e) {
                                                return (e >>> 24 & 255) + (e >>> 8 & 65280) + ((65280 & e) << 8) + ((255 & e) << 24);
                                              }

                                              function s() {
                                                this.mode = 0, this.last = !1, this.wrap = 0, this.havedict = !1, this.flags = 0, this.dmax = 0, this.check = 0, this.total = 0, this.head = null, this.wbits = 0, this.wsize = 0, this.whave = 0, this.wnext = 0, this.window = null, this.hold = 0, this.bits = 0, this.length = 0, this.offset = 0, this.extra = 0, this.lencode = null, this.distcode = null, this.lenbits = 0, this.distbits = 0, this.ncode = 0, this.nlen = 0, this.ndist = 0, this.have = 0, this.next = null, this.lens = new I.Buf16(320), this.work = new I.Buf16(288), this.lendyn = null, this.distdyn = null, this.sane = 0, this.back = 0, this.was = 0;
                                              }

                                              function a(e) {
                                                var t;
                                                return e && e.state ? (t = e.state, e.total_in = e.total_out = t.total = 0, e.msg = "", t.wrap && (e.adler = 1 & t.wrap), t.mode = P, t.last = 0, t.havedict = 0, t.dmax = 32768, t.head = null, t.hold = 0, t.bits = 0, t.lencode = t.lendyn = new I.Buf32(n), t.distcode = t.distdyn = new I.Buf32(i), t.sane = 1, t.back = -1, N) : U;
                                              }

                                              function o(e) {
                                                var t;
                                                return e && e.state ? ((t = e.state).wsize = 0, t.whave = 0, t.wnext = 0, a(e)) : U;
                                              }

                                              function u(e, t) {
                                                var r, n;
                                                return e && e.state ? (n = e.state, t < 0 ? (r = 0, t = -t) : (r = 1 + (t >> 4), t < 48 && (t &= 15)), t && (t < 8 || 15 < t) ? U : (null !== n.window && n.wbits !== t && (n.window = null), n.wrap = r, n.wbits = t, o(e))) : U;
                                              }

                                              function h(e, t) {
                                                var r, n;
                                                return e ? (n = new s(), (e.state = n).window = null, (r = u(e, t)) !== N && (e.state = null), r) : U;
                                              }

                                              var f,
                                                  l,
                                                  d = !0;

                                              function j(e) {
                                                if (d) {
                                                  var t;

                                                  for (f = new I.Buf32(512), l = new I.Buf32(32), t = 0; t < 144;) {
                                                    e.lens[t++] = 8;
                                                  }

                                                  for (; t < 256;) {
                                                    e.lens[t++] = 9;
                                                  }

                                                  for (; t < 280;) {
                                                    e.lens[t++] = 7;
                                                  }

                                                  for (; t < 288;) {
                                                    e.lens[t++] = 8;
                                                  }

                                                  for (R(D, e.lens, 0, 288, f, 0, e.work, {
                                                    bits: 9
                                                  }), t = 0; t < 32;) {
                                                    e.lens[t++] = 5;
                                                  }

                                                  R(F, e.lens, 0, 32, l, 0, e.work, {
                                                    bits: 5
                                                  }), d = !1;
                                                }

                                                e.lencode = f, e.lenbits = 9, e.distcode = l, e.distbits = 5;
                                              }

                                              function Z(e, t, r, n) {
                                                var i,
                                                    s = e.state;
                                                return null === s.window && (s.wsize = 1 << s.wbits, s.wnext = 0, s.whave = 0, s.window = new I.Buf8(s.wsize)), n >= s.wsize ? (I.arraySet(s.window, t, r - s.wsize, s.wsize, 0), s.wnext = 0, s.whave = s.wsize) : (n < (i = s.wsize - s.wnext) && (i = n), I.arraySet(s.window, t, r - n, i, s.wnext), (n -= i) ? (I.arraySet(s.window, t, r - n, n, 0), s.wnext = n, s.whave = s.wsize) : (s.wnext += i, s.wnext === s.wsize && (s.wnext = 0), s.whave < s.wsize && (s.whave += i))), 0;
                                              }

                                              r.inflateReset = o, r.inflateReset2 = u, r.inflateResetKeep = a, r.inflateInit = function (e) {
                                                return h(e, 15);
                                              }, r.inflateInit2 = h, r.inflate = function (e, t) {
                                                var r,
                                                    n,
                                                    i,
                                                    s,
                                                    a,
                                                    o,
                                                    u,
                                                    h,
                                                    f,
                                                    l,
                                                    d,
                                                    c,
                                                    p,
                                                    m,
                                                    _,
                                                    g,
                                                    v,
                                                    b,
                                                    w,
                                                    y,
                                                    k,
                                                    x,
                                                    S,
                                                    z,
                                                    E = 0,
                                                    C = new I.Buf8(4),
                                                    A = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];

                                                if (!e || !e.state || !e.output || !e.input && 0 !== e.avail_in) return U;
                                                12 === (r = e.state).mode && (r.mode = 13), a = e.next_out, i = e.output, u = e.avail_out, s = e.next_in, n = e.input, o = e.avail_in, h = r.hold, f = r.bits, l = o, d = u, x = N;

                                                e: for (;;) {
                                                  switch (r.mode) {
                                                    case P:
                                                      if (0 === r.wrap) {
                                                        r.mode = 13;
                                                        break;
                                                      }

                                                      for (; f < 16;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      if (2 & r.wrap && 35615 === h) {
                                                        C[r.check = 0] = 255 & h, C[1] = h >>> 8 & 255, r.check = B(r.check, C, 2, 0), f = h = 0, r.mode = 2;
                                                        break;
                                                      }

                                                      if (r.flags = 0, r.head && (r.head.done = !1), !(1 & r.wrap) || (((255 & h) << 8) + (h >> 8)) % 31) {
                                                        e.msg = "incorrect header check", r.mode = 30;
                                                        break;
                                                      }

                                                      if (8 != (15 & h)) {
                                                        e.msg = "unknown compression method", r.mode = 30;
                                                        break;
                                                      }

                                                      if (f -= 4, k = 8 + (15 & (h >>>= 4)), 0 === r.wbits) r.wbits = k;else if (k > r.wbits) {
                                                        e.msg = "invalid window size", r.mode = 30;
                                                        break;
                                                      }
                                                      r.dmax = 1 << k, e.adler = r.check = 1, r.mode = 512 & h ? 10 : 12, f = h = 0;
                                                      break;

                                                    case 2:
                                                      for (; f < 16;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      if (r.flags = h, 8 != (255 & r.flags)) {
                                                        e.msg = "unknown compression method", r.mode = 30;
                                                        break;
                                                      }

                                                      if (57344 & r.flags) {
                                                        e.msg = "unknown header flags set", r.mode = 30;
                                                        break;
                                                      }

                                                      r.head && (r.head.text = h >> 8 & 1), 512 & r.flags && (C[0] = 255 & h, C[1] = h >>> 8 & 255, r.check = B(r.check, C, 2, 0)), f = h = 0, r.mode = 3;

                                                    case 3:
                                                      for (; f < 32;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      r.head && (r.head.time = h), 512 & r.flags && (C[0] = 255 & h, C[1] = h >>> 8 & 255, C[2] = h >>> 16 & 255, C[3] = h >>> 24 & 255, r.check = B(r.check, C, 4, 0)), f = h = 0, r.mode = 4;

                                                    case 4:
                                                      for (; f < 16;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      r.head && (r.head.xflags = 255 & h, r.head.os = h >> 8), 512 & r.flags && (C[0] = 255 & h, C[1] = h >>> 8 & 255, r.check = B(r.check, C, 2, 0)), f = h = 0, r.mode = 5;

                                                    case 5:
                                                      if (1024 & r.flags) {
                                                        for (; f < 16;) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        r.length = h, r.head && (r.head.extra_len = h), 512 & r.flags && (C[0] = 255 & h, C[1] = h >>> 8 & 255, r.check = B(r.check, C, 2, 0)), f = h = 0;
                                                      } else r.head && (r.head.extra = null);

                                                      r.mode = 6;

                                                    case 6:
                                                      if (1024 & r.flags && (o < (c = r.length) && (c = o), c && (r.head && (k = r.head.extra_len - r.length, r.head.extra || (r.head.extra = new Array(r.head.extra_len)), I.arraySet(r.head.extra, n, s, c, k)), 512 & r.flags && (r.check = B(r.check, n, c, s)), o -= c, s += c, r.length -= c), r.length)) break e;
                                                      r.length = 0, r.mode = 7;

                                                    case 7:
                                                      if (2048 & r.flags) {
                                                        if (0 === o) break e;

                                                        for (c = 0; k = n[s + c++], r.head && k && r.length < 65536 && (r.head.name += String.fromCharCode(k)), k && c < o;) {
                                                          ;
                                                        }

                                                        if (512 & r.flags && (r.check = B(r.check, n, c, s)), o -= c, s += c, k) break e;
                                                      } else r.head && (r.head.name = null);

                                                      r.length = 0, r.mode = 8;

                                                    case 8:
                                                      if (4096 & r.flags) {
                                                        if (0 === o) break e;

                                                        for (c = 0; k = n[s + c++], r.head && k && r.length < 65536 && (r.head.comment += String.fromCharCode(k)), k && c < o;) {
                                                          ;
                                                        }

                                                        if (512 & r.flags && (r.check = B(r.check, n, c, s)), o -= c, s += c, k) break e;
                                                      } else r.head && (r.head.comment = null);

                                                      r.mode = 9;

                                                    case 9:
                                                      if (512 & r.flags) {
                                                        for (; f < 16;) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        if (h !== (65535 & r.check)) {
                                                          e.msg = "header crc mismatch", r.mode = 30;
                                                          break;
                                                        }

                                                        f = h = 0;
                                                      }

                                                      r.head && (r.head.hcrc = r.flags >> 9 & 1, r.head.done = !0), e.adler = r.check = 0, r.mode = 12;
                                                      break;

                                                    case 10:
                                                      for (; f < 32;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      e.adler = r.check = L(h), f = h = 0, r.mode = 11;

                                                    case 11:
                                                      if (0 === r.havedict) return e.next_out = a, e.avail_out = u, e.next_in = s, e.avail_in = o, r.hold = h, r.bits = f, 2;
                                                      e.adler = r.check = 1, r.mode = 12;

                                                    case 12:
                                                      if (5 === t || 6 === t) break e;

                                                    case 13:
                                                      if (r.last) {
                                                        h >>>= 7 & f, f -= 7 & f, r.mode = 27;
                                                        break;
                                                      }

                                                      for (; f < 3;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      switch (r.last = 1 & h, f -= 1, 3 & (h >>>= 1)) {
                                                        case 0:
                                                          r.mode = 14;
                                                          break;

                                                        case 1:
                                                          if (j(r), r.mode = 20, 6 !== t) break;
                                                          h >>>= 2, f -= 2;
                                                          break e;

                                                        case 2:
                                                          r.mode = 17;
                                                          break;

                                                        case 3:
                                                          e.msg = "invalid block type", r.mode = 30;
                                                      }

                                                      h >>>= 2, f -= 2;
                                                      break;

                                                    case 14:
                                                      for (h >>>= 7 & f, f -= 7 & f; f < 32;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      if ((65535 & h) != (h >>> 16 ^ 65535)) {
                                                        e.msg = "invalid stored block lengths", r.mode = 30;
                                                        break;
                                                      }

                                                      if (r.length = 65535 & h, f = h = 0, r.mode = 15, 6 === t) break e;

                                                    case 15:
                                                      r.mode = 16;

                                                    case 16:
                                                      if (c = r.length) {
                                                        if (o < c && (c = o), u < c && (c = u), 0 === c) break e;
                                                        I.arraySet(i, n, s, c, a), o -= c, s += c, u -= c, a += c, r.length -= c;
                                                        break;
                                                      }

                                                      r.mode = 12;
                                                      break;

                                                    case 17:
                                                      for (; f < 14;) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      if (r.nlen = 257 + (31 & h), h >>>= 5, f -= 5, r.ndist = 1 + (31 & h), h >>>= 5, f -= 5, r.ncode = 4 + (15 & h), h >>>= 4, f -= 4, 286 < r.nlen || 30 < r.ndist) {
                                                        e.msg = "too many length or distance symbols", r.mode = 30;
                                                        break;
                                                      }

                                                      r.have = 0, r.mode = 18;

                                                    case 18:
                                                      for (; r.have < r.ncode;) {
                                                        for (; f < 3;) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        r.lens[A[r.have++]] = 7 & h, h >>>= 3, f -= 3;
                                                      }

                                                      for (; r.have < 19;) {
                                                        r.lens[A[r.have++]] = 0;
                                                      }

                                                      if (r.lencode = r.lendyn, r.lenbits = 7, S = {
                                                        bits: r.lenbits
                                                      }, x = R(0, r.lens, 0, 19, r.lencode, 0, r.work, S), r.lenbits = S.bits, x) {
                                                        e.msg = "invalid code lengths set", r.mode = 30;
                                                        break;
                                                      }

                                                      r.have = 0, r.mode = 19;

                                                    case 19:
                                                      for (; r.have < r.nlen + r.ndist;) {
                                                        for (; g = (E = r.lencode[h & (1 << r.lenbits) - 1]) >>> 16 & 255, v = 65535 & E, !((_ = E >>> 24) <= f);) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        if (v < 16) h >>>= _, f -= _, r.lens[r.have++] = v;else {
                                                          if (16 === v) {
                                                            for (z = _ + 2; f < z;) {
                                                              if (0 === o) break e;
                                                              o--, h += n[s++] << f, f += 8;
                                                            }

                                                            if (h >>>= _, f -= _, 0 === r.have) {
                                                              e.msg = "invalid bit length repeat", r.mode = 30;
                                                              break;
                                                            }

                                                            k = r.lens[r.have - 1], c = 3 + (3 & h), h >>>= 2, f -= 2;
                                                          } else if (17 === v) {
                                                            for (z = _ + 3; f < z;) {
                                                              if (0 === o) break e;
                                                              o--, h += n[s++] << f, f += 8;
                                                            }

                                                            f -= _, k = 0, c = 3 + (7 & (h >>>= _)), h >>>= 3, f -= 3;
                                                          } else {
                                                            for (z = _ + 7; f < z;) {
                                                              if (0 === o) break e;
                                                              o--, h += n[s++] << f, f += 8;
                                                            }

                                                            f -= _, k = 0, c = 11 + (127 & (h >>>= _)), h >>>= 7, f -= 7;
                                                          }

                                                          if (r.have + c > r.nlen + r.ndist) {
                                                            e.msg = "invalid bit length repeat", r.mode = 30;
                                                            break;
                                                          }

                                                          for (; c--;) {
                                                            r.lens[r.have++] = k;
                                                          }
                                                        }
                                                      }

                                                      if (30 === r.mode) break;

                                                      if (0 === r.lens[256]) {
                                                        e.msg = "invalid code -- missing end-of-block", r.mode = 30;
                                                        break;
                                                      }

                                                      if (r.lenbits = 9, S = {
                                                        bits: r.lenbits
                                                      }, x = R(D, r.lens, 0, r.nlen, r.lencode, 0, r.work, S), r.lenbits = S.bits, x) {
                                                        e.msg = "invalid literal/lengths set", r.mode = 30;
                                                        break;
                                                      }

                                                      if (r.distbits = 6, r.distcode = r.distdyn, S = {
                                                        bits: r.distbits
                                                      }, x = R(F, r.lens, r.nlen, r.ndist, r.distcode, 0, r.work, S), r.distbits = S.bits, x) {
                                                        e.msg = "invalid distances set", r.mode = 30;
                                                        break;
                                                      }

                                                      if (r.mode = 20, 6 === t) break e;

                                                    case 20:
                                                      r.mode = 21;

                                                    case 21:
                                                      if (6 <= o && 258 <= u) {
                                                        e.next_out = a, e.avail_out = u, e.next_in = s, e.avail_in = o, r.hold = h, r.bits = f, T(e, d), a = e.next_out, i = e.output, u = e.avail_out, s = e.next_in, n = e.input, o = e.avail_in, h = r.hold, f = r.bits, 12 === r.mode && (r.back = -1);
                                                        break;
                                                      }

                                                      for (r.back = 0; g = (E = r.lencode[h & (1 << r.lenbits) - 1]) >>> 16 & 255, v = 65535 & E, !((_ = E >>> 24) <= f);) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      if (g && 0 == (240 & g)) {
                                                        for (b = _, w = g, y = v; g = (E = r.lencode[y + ((h & (1 << b + w) - 1) >> b)]) >>> 16 & 255, v = 65535 & E, !(b + (_ = E >>> 24) <= f);) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        h >>>= b, f -= b, r.back += b;
                                                      }

                                                      if (h >>>= _, f -= _, r.back += _, r.length = v, 0 === g) {
                                                        r.mode = 26;
                                                        break;
                                                      }

                                                      if (32 & g) {
                                                        r.back = -1, r.mode = 12;
                                                        break;
                                                      }

                                                      if (64 & g) {
                                                        e.msg = "invalid literal/length code", r.mode = 30;
                                                        break;
                                                      }

                                                      r.extra = 15 & g, r.mode = 22;

                                                    case 22:
                                                      if (r.extra) {
                                                        for (z = r.extra; f < z;) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        r.length += h & (1 << r.extra) - 1, h >>>= r.extra, f -= r.extra, r.back += r.extra;
                                                      }

                                                      r.was = r.length, r.mode = 23;

                                                    case 23:
                                                      for (; g = (E = r.distcode[h & (1 << r.distbits) - 1]) >>> 16 & 255, v = 65535 & E, !((_ = E >>> 24) <= f);) {
                                                        if (0 === o) break e;
                                                        o--, h += n[s++] << f, f += 8;
                                                      }

                                                      if (0 == (240 & g)) {
                                                        for (b = _, w = g, y = v; g = (E = r.distcode[y + ((h & (1 << b + w) - 1) >> b)]) >>> 16 & 255, v = 65535 & E, !(b + (_ = E >>> 24) <= f);) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        h >>>= b, f -= b, r.back += b;
                                                      }

                                                      if (h >>>= _, f -= _, r.back += _, 64 & g) {
                                                        e.msg = "invalid distance code", r.mode = 30;
                                                        break;
                                                      }

                                                      r.offset = v, r.extra = 15 & g, r.mode = 24;

                                                    case 24:
                                                      if (r.extra) {
                                                        for (z = r.extra; f < z;) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        r.offset += h & (1 << r.extra) - 1, h >>>= r.extra, f -= r.extra, r.back += r.extra;
                                                      }

                                                      if (r.offset > r.dmax) {
                                                        e.msg = "invalid distance too far back", r.mode = 30;
                                                        break;
                                                      }

                                                      r.mode = 25;

                                                    case 25:
                                                      if (0 === u) break e;

                                                      if (c = d - u, r.offset > c) {
                                                        if ((c = r.offset - c) > r.whave && r.sane) {
                                                          e.msg = "invalid distance too far back", r.mode = 30;
                                                          break;
                                                        }

                                                        p = c > r.wnext ? (c -= r.wnext, r.wsize - c) : r.wnext - c, c > r.length && (c = r.length), m = r.window;
                                                      } else m = i, p = a - r.offset, c = r.length;

                                                      for (u < c && (c = u), u -= c, r.length -= c; i[a++] = m[p++], --c;) {
                                                        ;
                                                      }

                                                      0 === r.length && (r.mode = 21);
                                                      break;

                                                    case 26:
                                                      if (0 === u) break e;
                                                      i[a++] = r.length, u--, r.mode = 21;
                                                      break;

                                                    case 27:
                                                      if (r.wrap) {
                                                        for (; f < 32;) {
                                                          if (0 === o) break e;
                                                          o--, h |= n[s++] << f, f += 8;
                                                        }

                                                        if (d -= u, e.total_out += d, r.total += d, d && (e.adler = r.check = r.flags ? B(r.check, i, d, a - d) : O(r.check, i, d, a - d)), d = u, (r.flags ? h : L(h)) !== r.check) {
                                                          e.msg = "incorrect data check", r.mode = 30;
                                                          break;
                                                        }

                                                        f = h = 0;
                                                      }

                                                      r.mode = 28;

                                                    case 28:
                                                      if (r.wrap && r.flags) {
                                                        for (; f < 32;) {
                                                          if (0 === o) break e;
                                                          o--, h += n[s++] << f, f += 8;
                                                        }

                                                        if (h !== (4294967295 & r.total)) {
                                                          e.msg = "incorrect length check", r.mode = 30;
                                                          break;
                                                        }

                                                        f = h = 0;
                                                      }

                                                      r.mode = 29;

                                                    case 29:
                                                      x = 1;
                                                      break e;

                                                    case 30:
                                                      x = -3;
                                                      break e;

                                                    case 31:
                                                      return -4;

                                                    case 32:
                                                    default:
                                                      return U;
                                                  }
                                                }

                                                return e.next_out = a, e.avail_out = u, e.next_in = s, e.avail_in = o, r.hold = h, r.bits = f, (r.wsize || d !== e.avail_out && r.mode < 30 && (r.mode < 27 || 4 !== t)) && Z(e, e.output, e.next_out, d - e.avail_out) ? (r.mode = 31, -4) : (l -= e.avail_in, d -= e.avail_out, e.total_in += l, e.total_out += d, r.total += d, r.wrap && d && (e.adler = r.check = r.flags ? B(r.check, i, d, e.next_out - d) : O(r.check, i, d, e.next_out - d)), e.data_type = r.bits + (r.last ? 64 : 0) + (12 === r.mode ? 128 : 0) + (20 === r.mode || 15 === r.mode ? 256 : 0), (0 == l && 0 === d || 4 === t) && x === N && (x = -5), x);
                                              }, r.inflateEnd = function (e) {
                                                if (!e || !e.state) return U;
                                                var t = e.state;
                                                return t.window && (t.window = null), e.state = null, N;
                                              }, r.inflateGetHeader = function (e, t) {
                                                var r;
                                                return e && e.state ? 0 == (2 & (r = e.state).wrap) ? U : ((r.head = t).done = !1, N) : U;
                                              }, r.inflateSetDictionary = function (e, t) {
                                                var r,
                                                    n = t.length;
                                                return e && e.state ? 0 !== (r = e.state).wrap && 11 !== r.mode ? U : 11 === r.mode && O(1, t, n, 0) !== r.check ? -3 : Z(e, t, n, n) ? (r.mode = 31, -4) : (r.havedict = 1, N) : U;
                                              }, r.inflateInfo = "pako inflate (from Nodeca project)";
                                            }, {
                                              "../utils/common": 41,
                                              "./adler32": 43,
                                              "./crc32": 45,
                                              "./inffast": 48,
                                              "./inftrees": 50
                                            }],
                                            50: [function (e, t, r) {
                                              "use strict";

                                              var D = e("../utils/common"),
                                                  F = [3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0],
                                                  N = [16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78],
                                                  U = [1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0],
                                                  P = [16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 64, 64];

                                              t.exports = function (e, t, r, n, i, s, a, o) {
                                                var u,
                                                    h,
                                                    f,
                                                    l,
                                                    d,
                                                    c,
                                                    p,
                                                    m,
                                                    _,
                                                    g = o.bits,
                                                    v = 0,
                                                    b = 0,
                                                    w = 0,
                                                    y = 0,
                                                    k = 0,
                                                    x = 0,
                                                    S = 0,
                                                    z = 0,
                                                    E = 0,
                                                    C = 0,
                                                    A = null,
                                                    I = 0,
                                                    O = new D.Buf16(16),
                                                    B = new D.Buf16(16),
                                                    T = null,
                                                    R = 0;

                                                for (v = 0; v <= 15; v++) {
                                                  O[v] = 0;
                                                }

                                                for (b = 0; b < n; b++) {
                                                  O[t[r + b]]++;
                                                }

                                                for (k = g, y = 15; 1 <= y && 0 === O[y]; y--) {
                                                  ;
                                                }

                                                if (y < k && (k = y), 0 === y) return i[s++] = 20971520, i[s++] = 20971520, o.bits = 1, 0;

                                                for (w = 1; w < y && 0 === O[w]; w++) {
                                                  ;
                                                }

                                                for (k < w && (k = w), v = z = 1; v <= 15; v++) {
                                                  if (z <<= 1, (z -= O[v]) < 0) return -1;
                                                }

                                                if (0 < z && (0 === e || 1 !== y)) return -1;

                                                for (B[1] = 0, v = 1; v < 15; v++) {
                                                  B[v + 1] = B[v] + O[v];
                                                }

                                                for (b = 0; b < n; b++) {
                                                  0 !== t[r + b] && (a[B[t[r + b]]++] = b);
                                                }

                                                if (c = 0 === e ? (A = T = a, 19) : 1 === e ? (A = F, I -= 257, T = N, R -= 257, 256) : (A = U, T = P, -1), v = w, d = s, S = b = C = 0, f = -1, l = (E = 1 << (x = k)) - 1, 1 === e && 852 < E || 2 === e && 592 < E) return 1;

                                                for (;;) {
                                                  for (p = v - S, _ = a[b] < c ? (m = 0, a[b]) : a[b] > c ? (m = T[R + a[b]], A[I + a[b]]) : (m = 96, 0), u = 1 << v - S, w = h = 1 << x; i[d + (C >> S) + (h -= u)] = p << 24 | m << 16 | _ | 0, 0 !== h;) {
                                                    ;
                                                  }

                                                  for (u = 1 << v - 1; C & u;) {
                                                    u >>= 1;
                                                  }

                                                  if (0 !== u ? (C &= u - 1, C += u) : C = 0, b++, 0 == --O[v]) {
                                                    if (v === y) break;
                                                    v = t[r + a[b]];
                                                  }

                                                  if (k < v && (C & l) !== f) {
                                                    for (0 === S && (S = k), d += w, z = 1 << (x = v - S); x + S < y && !((z -= O[x + S]) <= 0);) {
                                                      x++, z <<= 1;
                                                    }

                                                    if (E += 1 << x, 1 === e && 852 < E || 2 === e && 592 < E) return 1;
                                                    i[f = C & l] = k << 24 | x << 16 | d - s | 0;
                                                  }
                                                }

                                                return 0 !== C && (i[d + C] = v - S << 24 | 64 << 16 | 0), o.bits = k, 0;
                                              };
                                            }, {
                                              "../utils/common": 41
                                            }],
                                            51: [function (e, t, r) {
                                              "use strict";

                                              t.exports = {
                                                2: "need dictionary",
                                                1: "stream end",
                                                0: "",
                                                "-1": "file error",
                                                "-2": "stream error",
                                                "-3": "data error",
                                                "-4": "insufficient memory",
                                                "-5": "buffer error",
                                                "-6": "incompatible version"
                                              };
                                            }, {}],
                                            52: [function (e, t, r) {
                                              "use strict";

                                              var o = e("../utils/common");

                                              function n(e) {
                                                for (var t = e.length; 0 <= --t;) {
                                                  e[t] = 0;
                                                }
                                              }

                                              var _ = 15,
                                                  i = 16,
                                                  u = [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0],
                                                  h = [0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13],
                                                  a = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7],
                                                  f = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15],
                                                  l = new Array(576);
                                              n(l);
                                              var d = new Array(60);
                                              n(d);
                                              var c = new Array(512);
                                              n(c);
                                              var p = new Array(256);
                                              n(p);
                                              var m = new Array(29);
                                              n(m);
                                              var g,
                                                  v,
                                                  b,
                                                  w = new Array(30);

                                              function y(e, t, r, n, i) {
                                                this.static_tree = e, this.extra_bits = t, this.extra_base = r, this.elems = n, this.max_length = i, this.has_stree = e && e.length;
                                              }

                                              function s(e, t) {
                                                this.dyn_tree = e, this.max_code = 0, this.stat_desc = t;
                                              }

                                              function k(e) {
                                                return e < 256 ? c[e] : c[256 + (e >>> 7)];
                                              }

                                              function x(e, t) {
                                                e.pending_buf[e.pending++] = 255 & t, e.pending_buf[e.pending++] = t >>> 8 & 255;
                                              }

                                              function S(e, t, r) {
                                                e.bi_valid > i - r ? (e.bi_buf |= t << e.bi_valid & 65535, x(e, e.bi_buf), e.bi_buf = t >> i - e.bi_valid, e.bi_valid += r - i) : (e.bi_buf |= t << e.bi_valid & 65535, e.bi_valid += r);
                                              }

                                              function z(e, t, r) {
                                                S(e, r[2 * t], r[2 * t + 1]);
                                              }

                                              function E(e, t) {
                                                for (var r = 0; r |= 1 & e, e >>>= 1, r <<= 1, 0 < --t;) {
                                                  ;
                                                }

                                                return r >>> 1;
                                              }

                                              function C(e, t, r) {
                                                var n,
                                                    i,
                                                    s = new Array(_ + 1),
                                                    a = 0;

                                                for (n = 1; n <= _; n++) {
                                                  s[n] = a = a + r[n - 1] << 1;
                                                }

                                                for (i = 0; i <= t; i++) {
                                                  var o = e[2 * i + 1];
                                                  0 !== o && (e[2 * i] = E(s[o]++, o));
                                                }
                                              }

                                              function A(e) {
                                                var t;

                                                for (t = 0; t < 286; t++) {
                                                  e.dyn_ltree[2 * t] = 0;
                                                }

                                                for (t = 0; t < 30; t++) {
                                                  e.dyn_dtree[2 * t] = 0;
                                                }

                                                for (t = 0; t < 19; t++) {
                                                  e.bl_tree[2 * t] = 0;
                                                }

                                                e.dyn_ltree[512] = 1, e.opt_len = e.static_len = 0, e.last_lit = e.matches = 0;
                                              }

                                              function I(e) {
                                                8 < e.bi_valid ? x(e, e.bi_buf) : 0 < e.bi_valid && (e.pending_buf[e.pending++] = e.bi_buf), e.bi_buf = 0, e.bi_valid = 0;
                                              }

                                              function O(e, t, r, n) {
                                                var i = 2 * t,
                                                    s = 2 * r;
                                                return e[i] < e[s] || e[i] === e[s] && n[t] <= n[r];
                                              }

                                              function B(e, t, r) {
                                                for (var n = e.heap[r], i = r << 1; i <= e.heap_len && (i < e.heap_len && O(t, e.heap[i + 1], e.heap[i], e.depth) && i++, !O(t, n, e.heap[i], e.depth));) {
                                                  e.heap[r] = e.heap[i], r = i, i <<= 1;
                                                }

                                                e.heap[r] = n;
                                              }

                                              function T(e, t, r) {
                                                var n,
                                                    i,
                                                    s,
                                                    a,
                                                    o = 0;
                                                if (0 !== e.last_lit) for (; n = e.pending_buf[e.d_buf + 2 * o] << 8 | e.pending_buf[e.d_buf + 2 * o + 1], i = e.pending_buf[e.l_buf + o], o++, 0 === n ? z(e, i, t) : (z(e, (s = p[i]) + 256 + 1, t), 0 !== (a = u[s]) && S(e, i -= m[s], a), z(e, s = k(--n), r), 0 !== (a = h[s]) && S(e, n -= w[s], a)), o < e.last_lit;) {
                                                  ;
                                                }
                                                z(e, 256, t);
                                              }

                                              function R(e, t) {
                                                var r,
                                                    n,
                                                    i,
                                                    s = t.dyn_tree,
                                                    a = t.stat_desc.static_tree,
                                                    o = t.stat_desc.has_stree,
                                                    u = t.stat_desc.elems,
                                                    h = -1;

                                                for (e.heap_len = 0, e.heap_max = 573, r = 0; r < u; r++) {
                                                  0 !== s[2 * r] ? (e.heap[++e.heap_len] = h = r, e.depth[r] = 0) : s[2 * r + 1] = 0;
                                                }

                                                for (; e.heap_len < 2;) {
                                                  s[2 * (i = e.heap[++e.heap_len] = h < 2 ? ++h : 0)] = 1, e.depth[i] = 0, e.opt_len--, o && (e.static_len -= a[2 * i + 1]);
                                                }

                                                for (t.max_code = h, r = e.heap_len >> 1; 1 <= r; r--) {
                                                  B(e, s, r);
                                                }

                                                for (i = u; r = e.heap[1], e.heap[1] = e.heap[e.heap_len--], B(e, s, 1), n = e.heap[1], e.heap[--e.heap_max] = r, e.heap[--e.heap_max] = n, s[2 * i] = s[2 * r] + s[2 * n], e.depth[i] = (e.depth[r] >= e.depth[n] ? e.depth[r] : e.depth[n]) + 1, s[2 * r + 1] = s[2 * n + 1] = i, e.heap[1] = i++, B(e, s, 1), 2 <= e.heap_len;) {
                                                  ;
                                                }

                                                e.heap[--e.heap_max] = e.heap[1], function (e, t) {
                                                  var r,
                                                      n,
                                                      i,
                                                      s,
                                                      a,
                                                      o,
                                                      u = t.dyn_tree,
                                                      h = t.max_code,
                                                      f = t.stat_desc.static_tree,
                                                      l = t.stat_desc.has_stree,
                                                      d = t.stat_desc.extra_bits,
                                                      c = t.stat_desc.extra_base,
                                                      p = t.stat_desc.max_length,
                                                      m = 0;

                                                  for (s = 0; s <= _; s++) {
                                                    e.bl_count[s] = 0;
                                                  }

                                                  for (u[2 * e.heap[e.heap_max] + 1] = 0, r = e.heap_max + 1; r < 573; r++) {
                                                    p < (s = u[2 * u[2 * (n = e.heap[r]) + 1] + 1] + 1) && (s = p, m++), u[2 * n + 1] = s, h < n || (e.bl_count[s]++, a = 0, c <= n && (a = d[n - c]), o = u[2 * n], e.opt_len += o * (s + a), l && (e.static_len += o * (f[2 * n + 1] + a)));
                                                  }

                                                  if (0 !== m) {
                                                    do {
                                                      for (s = p - 1; 0 === e.bl_count[s];) {
                                                        s--;
                                                      }

                                                      e.bl_count[s]--, e.bl_count[s + 1] += 2, e.bl_count[p]--, m -= 2;
                                                    } while (0 < m);

                                                    for (s = p; 0 !== s; s--) {
                                                      for (n = e.bl_count[s]; 0 !== n;) {
                                                        h < (i = e.heap[--r]) || (u[2 * i + 1] !== s && (e.opt_len += (s - u[2 * i + 1]) * u[2 * i], u[2 * i + 1] = s), n--);
                                                      }
                                                    }
                                                  }
                                                }(e, t), C(s, h, e.bl_count);
                                              }

                                              function D(e, t, r) {
                                                var n,
                                                    i,
                                                    s = -1,
                                                    a = t[1],
                                                    o = 0,
                                                    u = 7,
                                                    h = 4;

                                                for (0 === a && (u = 138, h = 3), t[2 * (r + 1) + 1] = 65535, n = 0; n <= r; n++) {
                                                  i = a, a = t[2 * (n + 1) + 1], ++o < u && i === a || (o < h ? e.bl_tree[2 * i] += o : 0 !== i ? (i !== s && e.bl_tree[2 * i]++, e.bl_tree[32]++) : o <= 10 ? e.bl_tree[34]++ : e.bl_tree[36]++, s = i, h = (o = 0) === a ? (u = 138, 3) : i === a ? (u = 6, 3) : (u = 7, 4));
                                                }
                                              }

                                              function F(e, t, r) {
                                                var n,
                                                    i,
                                                    s = -1,
                                                    a = t[1],
                                                    o = 0,
                                                    u = 7,
                                                    h = 4;

                                                for (0 === a && (u = 138, h = 3), n = 0; n <= r; n++) {
                                                  if (i = a, a = t[2 * (n + 1) + 1], !(++o < u && i === a)) {
                                                    if (o < h) for (; z(e, i, e.bl_tree), 0 != --o;) {
                                                      ;
                                                    } else 0 !== i ? (i !== s && (z(e, i, e.bl_tree), o--), z(e, 16, e.bl_tree), S(e, o - 3, 2)) : o <= 10 ? (z(e, 17, e.bl_tree), S(e, o - 3, 3)) : (z(e, 18, e.bl_tree), S(e, o - 11, 7));
                                                    s = i, h = (o = 0) === a ? (u = 138, 3) : i === a ? (u = 6, 3) : (u = 7, 4);
                                                  }
                                                }
                                              }

                                              n(w);
                                              var N = !1;

                                              function U(e, t, r, n) {
                                                var i, s, a;
                                                S(e, 0 + (n ? 1 : 0), 3), s = t, a = r, I(i = e), x(i, a), x(i, ~a), o.arraySet(i.pending_buf, i.window, s, a, i.pending), i.pending += a;
                                              }

                                              r._tr_init = function (e) {
                                                N || (function () {
                                                  var e,
                                                      t,
                                                      r,
                                                      n,
                                                      i,
                                                      s = new Array(_ + 1);

                                                  for (n = r = 0; n < 28; n++) {
                                                    for (m[n] = r, e = 0; e < 1 << u[n]; e++) {
                                                      p[r++] = n;
                                                    }
                                                  }

                                                  for (p[r - 1] = n, n = i = 0; n < 16; n++) {
                                                    for (w[n] = i, e = 0; e < 1 << h[n]; e++) {
                                                      c[i++] = n;
                                                    }
                                                  }

                                                  for (i >>= 7; n < 30; n++) {
                                                    for (w[n] = i << 7, e = 0; e < 1 << h[n] - 7; e++) {
                                                      c[256 + i++] = n;
                                                    }
                                                  }

                                                  for (t = 0; t <= _; t++) {
                                                    s[t] = 0;
                                                  }

                                                  for (e = 0; e <= 143;) {
                                                    l[2 * e + 1] = 8, e++, s[8]++;
                                                  }

                                                  for (; e <= 255;) {
                                                    l[2 * e + 1] = 9, e++, s[9]++;
                                                  }

                                                  for (; e <= 279;) {
                                                    l[2 * e + 1] = 7, e++, s[7]++;
                                                  }

                                                  for (; e <= 287;) {
                                                    l[2 * e + 1] = 8, e++, s[8]++;
                                                  }

                                                  for (C(l, 287, s), e = 0; e < 30; e++) {
                                                    d[2 * e + 1] = 5, d[2 * e] = E(e, 5);
                                                  }

                                                  g = new y(l, u, 257, 286, _), v = new y(d, h, 0, 30, _), b = new y(new Array(0), a, 0, 19, 7);
                                                }(), N = !0), e.l_desc = new s(e.dyn_ltree, g), e.d_desc = new s(e.dyn_dtree, v), e.bl_desc = new s(e.bl_tree, b), e.bi_buf = 0, e.bi_valid = 0, A(e);
                                              }, r._tr_stored_block = U, r._tr_flush_block = function (e, t, r, n) {
                                                var i,
                                                    s,
                                                    a = 0;
                                                0 < e.level ? (2 === e.strm.data_type && (e.strm.data_type = function (e) {
                                                  var t,
                                                      r = 4093624447;

                                                  for (t = 0; t <= 31; t++, r >>>= 1) {
                                                    if (1 & r && 0 !== e.dyn_ltree[2 * t]) return 0;
                                                  }

                                                  if (0 !== e.dyn_ltree[18] || 0 !== e.dyn_ltree[20] || 0 !== e.dyn_ltree[26]) return 1;

                                                  for (t = 32; t < 256; t++) {
                                                    if (0 !== e.dyn_ltree[2 * t]) return 1;
                                                  }

                                                  return 0;
                                                }(e)), R(e, e.l_desc), R(e, e.d_desc), a = function (e) {
                                                  var t;

                                                  for (D(e, e.dyn_ltree, e.l_desc.max_code), D(e, e.dyn_dtree, e.d_desc.max_code), R(e, e.bl_desc), t = 18; 3 <= t && 0 === e.bl_tree[2 * f[t] + 1]; t--) {
                                                    ;
                                                  }

                                                  return e.opt_len += 3 * (t + 1) + 5 + 5 + 4, t;
                                                }(e), i = e.opt_len + 3 + 7 >>> 3, (s = e.static_len + 3 + 7 >>> 3) <= i && (i = s)) : i = s = r + 5, r + 4 <= i && -1 !== t ? U(e, t, r, n) : 4 === e.strategy || s === i ? (S(e, 2 + (n ? 1 : 0), 3), T(e, l, d)) : (S(e, 4 + (n ? 1 : 0), 3), function (e, t, r, n) {
                                                  var i;

                                                  for (S(e, t - 257, 5), S(e, r - 1, 5), S(e, n - 4, 4), i = 0; i < n; i++) {
                                                    S(e, e.bl_tree[2 * f[i] + 1], 3);
                                                  }

                                                  F(e, e.dyn_ltree, t - 1), F(e, e.dyn_dtree, r - 1);
                                                }(e, e.l_desc.max_code + 1, e.d_desc.max_code + 1, a + 1), T(e, e.dyn_ltree, e.dyn_dtree)), A(e), n && I(e);
                                              }, r._tr_tally = function (e, t, r) {
                                                return e.pending_buf[e.d_buf + 2 * e.last_lit] = t >>> 8 & 255, e.pending_buf[e.d_buf + 2 * e.last_lit + 1] = 255 & t, e.pending_buf[e.l_buf + e.last_lit] = 255 & r, e.last_lit++, 0 === t ? e.dyn_ltree[2 * r]++ : (e.matches++, t--, e.dyn_ltree[2 * (p[r] + 256 + 1)]++, e.dyn_dtree[2 * k(t)]++), e.last_lit === e.lit_bufsize - 1;
                                              }, r._tr_align = function (e) {
                                                var t;
                                                S(e, 2, 3), z(e, 256, l), 16 === (t = e).bi_valid ? (x(t, t.bi_buf), t.bi_buf = 0, t.bi_valid = 0) : 8 <= t.bi_valid && (t.pending_buf[t.pending++] = 255 & t.bi_buf, t.bi_buf >>= 8, t.bi_valid -= 8);
                                              };
                                            }, {
                                              "../utils/common": 41
                                            }],
                                            53: [function (e, t, r) {
                                              "use strict";

                                              t.exports = function () {
                                                this.input = null, this.next_in = 0, this.avail_in = 0, this.total_in = 0, this.output = null, this.next_out = 0, this.avail_out = 0, this.total_out = 0, this.msg = "", this.state = null, this.data_type = 2, this.adler = 0;
                                              };
                                            }, {}],
                                            54: [function (e, t, r) {
                                              "use strict";

                                              t.exports = "function" == typeof setImmediate ? setImmediate : function () {
                                                var e = [].slice.apply(arguments);
                                                e.splice(1, 0, 0), setTimeout.apply(null, e);
                                              };
                                            }, {}]
                                          }, {}, [10])(10);
                                        });
                                      }).call(this, void 0 !== r ? r : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
                                    }, {}]
                                  }, {}, [1])(1);
                                });
                              }).call(this, void 0 !== r ? r : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
                            }, {}]
                          }, {}, [1])(1);
                        });
                      }).call(this, void 0 !== r ? r : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
                    }, {}]
                  }, {}, [1])(1);
                });
              }).call(this, void 0 !== r ? r : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
            }, {}]
          }, {}, [1])(1);
        });
      }).call(this, "undefined" != typeof global ? global : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
    }, {}]
  }, {}, [1])(1);
});

cc._RF.pop();

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {},require("buffer").Buffer)
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMUtils.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '78ca3nM8PRIVZeqkuNrmj1L', 'CCMUtils');
// lib/CCMUtils.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var CCMUtils = /** @class */ (function () {
    function CCMUtils() {
        this.clickTime = {};
    }
    CCMUtils.getInstance = function () {
        if (!CCMUtils.instance) {
            CCMUtils.instance = new CCMUtils();
        }
        return CCMUtils.instance;
    };
    /**
     * @description 是否频繁点击
     * @param 判断重点的一个id，用于区分不同时机
     * @duration 少于该时长即认为发生了重复点击（毫秒）
     **/
    CCMUtils.prototype.isQuickClick = function (tag, duration) {
        if (!tag)
            tag = 'normal';
        if (!this.clickTime)
            this.clickTime = {};
        if (this.clickTime[tag] == undefined)
            this.clickTime[tag] = 0;
        var gapTime = new Date().getTime() - this.clickTime[tag];
        if (!duration)
            duration = 500;
        if (gapTime < duration) {
            console.log(CCMUtils.TAG, '请勿重复点击');
            return true;
        }
        this.clickTime[tag] = new Date().getTime();
        return false;
    };
    /**
     * @description 是否是平板的屏幕，仅根据屏幕高宽比判断，不适合用于确定是否真的平板
     */
    CCMUtils.prototype.isPadScreen = function () {
        var screenWidth = cc.view.getVisibleSize().width;
        var screenHeight = cc.view.getVisibleSize().height;
        var ratio = 1.69;
        return !(screenWidth > screenHeight && screenWidth >= ratio * screenHeight)
            && !(screenHeight > screenWidth && screenHeight >= ratio * screenWidth);
    };
    CCMUtils.prototype.isWxGame = function () {
        return cc.sys.platform === cc.sys.WECHAT_GAME;
    };
    CCMUtils.prototype.isAndroid = function () {
        return cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID;
    };
    CCMUtils.prototype.isIOS = function () {
        return cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS;
    };
    CCMUtils.prototype.isBrowser = function () {
        return cc.sys.isBrowser;
    };
    /**
     * @description 快速获取某个数据对象中深层 key 的值
     * @param src 数据对象
     * @param key 要获取值对应的 key，层级通过 # 分割
     */
    CCMUtils.prototype.key4property = function (src, key) {
        if (!src)
            return undefined;
        var keys = key.split('#');
        for (var i = 0, j = keys.length; i < j; i++) {
            src = src[keys[i]];
            if (typeof src == 'object' && src != null)
                continue;
            if (i < j - 1)
                return undefined;
        }
        return src;
    };
    CCMUtils.TAG = 'CCMSceneManager';
    return CCMUtils;
}());
exports.default = CCMUtils;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMBinding/CCMBinding.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '88396uYlDlKdpiCzSL5nr8D', 'CCMBinding');
// lib/CCMBinding/CCMBinding.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var AUTO_INCREASE_ID = 0;
var ERROR_CODE_METHOD_NOT_DEFINED = -1;
var ERROR_CODE_PARAMS_ERROR = -2;
var ERROR_CODE_TIMEOUT = -3;
var ERROR_CODE_UNKNOW = -999;
var CCMBinding = /** @class */ (function () {
    function CCMBinding() {
        this.DEFAULT_OPTIONS = { timeout: 60, hasCallback: true, onProgress: undefined };
        this._options = this.DEFAULT_OPTIONS;
    }
    Object.defineProperty(CCMBinding, "Instance", {
        get: function () {
            if (!this.instance) {
                this.instance = new CCMBinding();
            }
            return this.instance;
        },
        enumerable: false,
        configurable: true
    });
    CCMBinding.withOptions = function (options) {
        return this.Instance.withOptions(options);
    };
    CCMBinding.callNativeMethod = function (methodName, args) {
        return this.Instance.callNativeMethod(methodName, args);
    };
    /**
     * 创建一个临时请求native方法的可选项，包含：
     * 超时时间设置默认60秒，过程回调（若有)
     * @param options Options,
     */
    CCMBinding.prototype.withOptions = function (options) {
        var oriProto = Object.getPrototypeOf(this);
        var temp = Object.assign(Object.create(oriProto), this);
        temp._options = Object.assign({}, this.DEFAULT_OPTIONS, options);
        return temp;
    };
    CCMBinding.prototype.callNativeMethod = function (methodName, args) {
        var _this = this;
        console.log("options:" + JSON.stringify(this._options) + ", args:" + args);
        var hasCallback = this._options.hasCallback;
        var hasProgress = this._options.onProgress;
        return new Promise(function (resolve, reject) {
            var cbName = '';
            var timeoutId;
            var cbProgressName = '';
            if (hasCallback || hasProgress) {
                // eslint-disable-next-line no-plusplus
                cbName = "CCM_CB" + new Date().getTime() + "_" + AUTO_INCREASE_ID++;
                cbProgressName = cbName + "_p";
                timeoutId = setTimeout(function () {
                    if (window[cbName]) {
                        _this.clearCallback(cbName, -1, cbProgressName);
                        reject({ code: ERROR_CODE_TIMEOUT, msg: "delete cb name: " + cbName + ",because of timeout" });
                    }
                }, _this._options.timeout * 1000);
                window[cbName] = function (result) {
                    console.log('result from native:', JSON.stringify(result));
                    if (result) {
                        var code = result.code;
                        var msg = result.msg;
                        var errCode = result.eCode;
                        var data = result.data;
                        if (code == 0) {
                            resolve(data);
                        }
                        else {
                            reject({ code: errCode, msg: msg });
                        }
                    }
                    else {
                        reject({ code: ERROR_CODE_UNKNOW, msg: 'result is null' });
                    }
                    _this.clearCallback(cbName, timeoutId, cbProgressName);
                };
                window[cbProgressName] = function (progressData) {
                    cc.log('invoke data', JSON.stringify(progressData));
                    if (_this._options.onProgress && progressData) {
                        var code = progressData.code;
                        var msg = progressData.msg;
                        var errCode = progressData.eCode;
                        var data = progressData.data;
                        if (code == 0) {
                            _this._options.onProgress(data);
                        }
                        else {
                            cc.log("progress error: " + code + ", " + errCode + "," + msg);
                        }
                    }
                };
            }
            if (cc.sys.isNative && cc.sys.os === cc.sys.OS_ANDROID) {
                var resultCode = jsb.reflection.callStaticMethod('com/tencent/cocomat/binding/CCMBinding', 'execute', '(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I', methodName, typeof args === 'object' ? JSON.stringify(args) : '', cbName);
                if (resultCode !== 0) {
                    switch (resultCode) {
                        case -1:
                            reject({
                                code: ERROR_CODE_METHOD_NOT_DEFINED,
                                msg: methodName + " not found on Android platform"
                            });
                            break;
                        case -2:
                            reject({ code: ERROR_CODE_PARAMS_ERROR, msg: "error! invalid parameters" });
                            break;
                        default:
                            reject({ code: resultCode, msg: "error! result code=" + resultCode });
                            break;
                    }
                    if (hasCallback) {
                        _this.clearCallback(cbName, timeoutId, cbProgressName);
                    }
                }
            }
            else if (cc.sys.isNative && cc.sys.os === cc.sys.OS_IOS) {
                var retId = jsb.reflection.callStaticMethod('CCMBinding', 'executeWithMethodName:args:callback:', methodName, typeof args === 'object' ? JSON.stringify(args) : '', cbName);
            }
            else {
                var msg = 'no implemented on this platform';
                reject({ code: ERROR_CODE_METHOD_NOT_DEFINED, msg: msg });
                _this.clearCallback(cbName, timeoutId, cbProgressName);
            }
        });
    };
    CCMBinding.prototype.clearCallback = function (cbName, timeoutId, cbProgressName) {
        if (timeoutId === void 0) { timeoutId = -1; }
        if (cbProgressName === void 0) { cbProgressName = ''; }
        if (cbProgressName && cbProgressName != '') {
            console.log("delete cbProgressName" + cbName);
            delete window[cbProgressName];
        }
        if (cbName && cbName != '') {
            console.log("delete cbName" + cbName);
            delete window[cbName];
        }
        if (timeoutId >= 0) {
            console.log("clearTimeout" + cbName);
            clearTimeout(timeoutId);
        }
    };
    return CCMBinding;
}());
exports.default = CCMBinding;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/coco-mat/lib/CCMVideo/CCMVideoAssembler.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '7fa81/nMOdGuIUmWdto22QE', 'CCMVideoAssembler');
// lib/CCMVideo/CCMVideoAssembler.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CCMVideoAssembler = void 0;
var ccclass = cc._decorator.ccclass;
var CCMVideoAssembler = /** @class */ (function (_super) {
    __extends(CCMVideoAssembler, _super);
    function CCMVideoAssembler() {
        var _this = _super.call(this) || this;
        // @ts-ignore
        _this.renderData = new cc.RenderData();
        _this.local = [];
        _this.floatsPerVert = 5;
        _this.verticesCount = 4;
        _this.indicesCount = 6;
        _this.uvOffset = 2;
        _this.colorOffset = 4;
        _this.uv = [0, 1, 1, 1, 0, 0, 1, 0];
        // @ts-ignore
        _this.initData();
        _this.initLocal();
        return _this;
    }
    CCMVideoAssembler.prototype.initData = function () {
        this.renderData.init(this);
        this.renderData.createQuadData(0, this.verticesCount * this.floatsPerVert, this.indicesCount);
    };
    CCMVideoAssembler.prototype.initLocal = function () {
        this.local.length = 4;
    };
    CCMVideoAssembler.prototype.updateColor = function (comp, color) {
        var uintVerts = this.renderData.uintVDatas[0];
        if (!uintVerts)
            return;
        // @ts-ignore
        color = color || comp.node.color._val;
        var floatsPerVert = this.floatsPerVert;
        var colorOffset = this.colorOffset;
        for (var i = colorOffset, l = uintVerts.length; i < l; i += floatsPerVert) {
            uintVerts[i] = color;
        }
    };
    CCMVideoAssembler.prototype.getBuffer = function () {
        // @ts-ignore
        return cc.renderer._handle._meshBuffer;
    };
    CCMVideoAssembler.prototype.updateWorldVerts = function (comp) {
        var local = this.local;
        var verts = this.renderData.vDatas[0];
        if (CC_JSB) {
            var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
            // left bottom
            verts[0] = vl;
            verts[1] = vb;
            // right bottom
            verts[5] = vr;
            verts[6] = vb;
            // left top
            verts[10] = vl;
            verts[11] = vt;
            // right top
            verts[15] = vr;
            verts[16] = vt;
        }
        else {
            // @ts-ignore
            var matrix = comp.node._worldMatrix;
            var matrixm = matrix.m, a = matrixm[0], b = matrixm[1], c = matrixm[4], d = matrixm[5], tx = matrixm[12], ty = matrixm[13];
            var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
            var justTranslate = a === 1 && b === 0 && c === 0 && d === 1;
            if (justTranslate) {
                // left bottom
                verts[0] = vl + tx;
                verts[1] = vb + ty;
                // right bottom
                verts[5] = vr + tx;
                verts[6] = vb + ty;
                // left top
                verts[10] = vl + tx;
                verts[11] = vt + ty;
                // right top
                verts[15] = vr + tx;
                verts[16] = vt + ty;
            }
            else {
                var al = a * vl, ar = a * vr, bl = b * vl, br = b * vr, cb = c * vb, ct = c * vt, db = d * vb, dt = d * vt;
                // left bottom
                verts[0] = al + cb + tx;
                verts[1] = bl + db + ty;
                // right bottom
                verts[5] = ar + cb + tx;
                verts[6] = br + db + ty;
                // left top
                verts[10] = al + ct + tx;
                verts[11] = bl + dt + ty;
                // right top
                verts[15] = ar + ct + tx;
                verts[16] = br + dt + ty;
            }
        }
    };
    CCMVideoAssembler.prototype.fillBuffers = function (comp, renderer) {
        if (renderer.worldMatDirty) {
            this.updateWorldVerts(comp);
        }
        var renderData = this.renderData;
        var vData = renderData.vDatas[0];
        var iData = renderData.iDatas[0];
        var buffer = this.getBuffer();
        var offsetInfo = buffer.request(this.verticesCount, this.indicesCount);
        // buffer data may be realloc, need get reference after request.
        // fill vertices
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        if (vData.length + vertexOffset > vbuf.length) {
            vbuf.set(vData.subarray(0, vbuf.length - vertexOffset), vertexOffset);
        }
        else {
            vbuf.set(vData, vertexOffset);
        }
        // fill indices
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset;
        for (var i = 0, l = iData.length; i < l; i++) {
            ibuf[indiceOffset++] = vertexId + iData[i];
        }
    };
    CCMVideoAssembler.prototype.updateRenderData = function (comp) {
        // @ts-ignore
        if (comp._vertsDirty) {
            this.updateUVs(comp);
            this.updateVerts(comp);
            // @ts-ignore
            comp._vertsDirty = false;
        }
    };
    CCMVideoAssembler.prototype.updateUVs = function (comp) {
        var uv = this.uv;
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this.renderData.vDatas[0];
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    CCMVideoAssembler.prototype.updateVerts = function (comp) {
        var node = comp.node, cw = node.width, ch = node.height, appx = node.anchorX * cw, appy = node.anchorY * ch, l, b, r, t;
        l = -appx;
        b = -appy;
        r = cw - appx;
        t = ch - appy;
        var local = this.local;
        local[0] = l;
        local[1] = b;
        local[2] = r;
        local[3] = t;
        this.updateWorldVerts(comp);
    };
    CCMVideoAssembler = __decorate([
        ccclass
    ], CCMVideoAssembler);
    return CCMVideoAssembler;
}(cc.Assembler));
exports.CCMVideoAssembler = CCMVideoAssembler;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__node_modules/buffer/index.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}(function (global){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */

'use strict'

var base64 = require('base64-js')
var ieee754 = require('ieee754')
var isArray = require('isarray')

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset