"use strict";
cc._RF.push(module, '7fa81/nMOdGuIUmWdto22QE', 'CCMVideoAssembler');
// lib/CCMVideo/CCMVideoAssembler.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CCMVideoAssembler = void 0;
var ccclass = cc._decorator.ccclass;
var CCMVideoAssembler = /** @class */ (function (_super) {
    __extends(CCMVideoAssembler, _super);
    function CCMVideoAssembler() {
        var _this = _super.call(this) || this;
        // @ts-ignore
        _this.renderData = new cc.RenderData();
        _this.local = [];
        _this.floatsPerVert = 5;
        _this.verticesCount = 4;
        _this.indicesCount = 6;
        _this.uvOffset = 2;
        _this.colorOffset = 4;
        _this.uv = [0, 1, 1, 1, 0, 0, 1, 0];
        // @ts-ignore
        _this.initData();
        _this.initLocal();
        return _this;
    }
    CCMVideoAssembler.prototype.initData = function () {
        this.renderData.init(this);
        this.renderData.createQuadData(0, this.verticesCount * this.floatsPerVert, this.indicesCount);
    };
    CCMVideoAssembler.prototype.initLocal = function () {
        this.local.length = 4;
    };
    CCMVideoAssembler.prototype.updateColor = function (comp, color) {
        var uintVerts = this.renderData.uintVDatas[0];
        if (!uintVerts)
            return;
        // @ts-ignore
        color = color || comp.node.color._val;
        var floatsPerVert = this.floatsPerVert;
        var colorOffset = this.colorOffset;
        for (var i = colorOffset, l = uintVerts.length; i < l; i += floatsPerVert) {
            uintVerts[i] = color;
        }
    };
    CCMVideoAssembler.prototype.getBuffer = function () {
        // @ts-ignore
        return cc.renderer._handle._meshBuffer;
    };
    CCMVideoAssembler.prototype.updateWorldVerts = function (comp) {
        var local = this.local;
        var verts = this.renderData.vDatas[0];
        if (CC_JSB) {
            var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
            // left bottom
            verts[0] = vl;
            verts[1] = vb;
            // right bottom
            verts[5] = vr;
            verts[6] = vb;
            // left top
            verts[10] = vl;
            verts[11] = vt;
            // right top
            verts[15] = vr;
            verts[16] = vt;
        }
        else {
            // @ts-ignore
            var matrix = comp.node._worldMatrix;
            var matrixm = matrix.m, a = matrixm[0], b = matrixm[1], c = matrixm[4], d = matrixm[5], tx = matrixm[12], ty = matrixm[13];
            var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
            var justTranslate = a === 1 && b === 0 && c === 0 && d === 1;
            if (justTranslate) {
                // left bottom
                verts[0] = vl + tx;
                verts[1] = vb + ty;
                // right bottom
                verts[5] = vr + tx;
                verts[6] = vb + ty;
                // left top
                verts[10] = vl + tx;
                verts[11] = vt + ty;
                // right top
                verts[15] = vr + tx;
                verts[16] = vt + ty;
            }
            else {
                var al = a * vl, ar = a * vr, bl = b * vl, br = b * vr, cb = c * vb, ct = c * vt, db = d * vb, dt = d * vt;
                // left bottom
                verts[0] = al + cb + tx;
                verts[1] = bl + db + ty;
                // right bottom
                verts[5] = ar + cb + tx;
                verts[6] = br + db + ty;
                // left top
                verts[10] = al + ct + tx;
                verts[11] = bl + dt + ty;
                // right top
                verts[15] = ar + ct + tx;
                verts[16] = br + dt + ty;
            }
        }
    };
    CCMVideoAssembler.prototype.fillBuffers = function (comp, renderer) {
        if (renderer.worldMatDirty) {
            this.updateWorldVerts(comp);
        }
        var renderData = this.renderData;
        var vData = renderData.vDatas[0];
        var iData = renderData.iDatas[0];
        var buffer = this.getBuffer();
        var offsetInfo = buffer.request(this.verticesCount, this.indicesCount);
        // buffer data may be realloc, need get reference after request.
        // fill vertices
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        if (vData.length + vertexOffset > vbuf.length) {
            vbuf.set(vData.subarray(0, vbuf.length - vertexOffset), vertexOffset);
        }
        else {
            vbuf.set(vData, vertexOffset);
        }
        // fill indices
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset;
        for (var i = 0, l = iData.length; i < l; i++) {
            ibuf[indiceOffset++] = vertexId + iData[i];
        }
    };
    CCMVideoAssembler.prototype.updateRenderData = function (comp) {
        // @ts-ignore
        if (comp._vertsDirty) {
            this.updateUVs(comp);
            this.updateVerts(comp);
            // @ts-ignore
            comp._vertsDirty = false;
        }
    };
    CCMVideoAssembler.prototype.updateUVs = function (comp) {
        var uv = this.uv;
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this.renderData.vDatas[0];
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    CCMVideoAssembler.prototype.updateVerts = function (comp) {
        var node = comp.node, cw = node.width, ch = node.height, appx = node.anchorX * cw, appy = node.anchorY * ch, l, b, r, t;
        l = -appx;
        b = -appy;
        r = cw - appx;
        t = ch - appy;
        var local = this.local;
        local[0] = l;
        local[1] = b;
        local[2] = r;
        local[3] = t;
        this.updateWorldVerts(comp);
    };
    CCMVideoAssembler = __decorate([
        ccclass
    ], CCMVideoAssembler);
    return CCMVideoAssembler;
}(cc.Assembler));
exports.CCMVideoAssembler = CCMVideoAssembler;

cc._RF.pop();