"use strict";
cc._RF.push(module, '0cac4WEByFBWavsOGLakGqf', 'CCMRouter');
// lib/CCMBinding/CCMRouter.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 路由方法，可以注册方法供别的模块,或者是native主动发起调用
 */
var CCMBinding_1 = require("./CCMBinding");
var TAG = 'CCMRouter';
var CCMRouter = /** @class */ (function () {
    function CCMRouter() {
        this.methodMap = new Map();
    }
    CCMRouter.callMethod = function (methodName, args) {
        return this.Instance.callMethod(methodName, args);
    };
    CCMRouter.registerMethod = function (methodName, callback) {
        return this.Instance.registerMethod(methodName, callback);
    };
    CCMRouter.unRegisterMethod = function (eventName) {
        return this.Instance.unRegisterMethod(eventName);
    };
    Object.defineProperty(CCMRouter, "Instance", {
        get: function () {
            if (!this.instance) {
                this.instance = new CCMRouter();
            }
            return this.instance;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 自定义事件处理者
     */
    CCMRouter.prototype.registerMethod = function (eventName, callback) {
        var _this = this;
        this.methodMap.set(eventName, callback);
        window["ccmbinding_router_" + eventName] = function (args) {
            cc.log(TAG, 'called eventName' + eventName);
            return _this.callMethod(eventName, args).then().catch();
        };
    };
    CCMRouter.prototype.unRegisterMethod = function (eventName) {
        this.methodMap.delete(eventName);
        delete window["ccmbinding_router_" + eventName];
    };
    CCMRouter.prototype.callMethod = function (methodName, args) {
        var method = this.methodMap.get(methodName);
        if (method) {
            var data = args['data'];
            var exeResult = method.call(this, data);
            // 如果是在native环境下，则需要把结果返回到native中。
            if (cc.sys.isNative && typeof exeResult === 'object') {
                if (exeResult instanceof Promise) {
                    exeResult.then(function (result) {
                        cc.log('start call native from ts');
                        var callbackName = args['@nativeCallbackName'];
                        CCMBinding_1.default.withOptions({ hasCallback: false }).callNativeMethod(callbackName, result)
                            .then(function (rs) {
                            cc.log('receive:', rs);
                        }).catch(function (e) {
                            cc.log('exception:', e);
                        });
                    });
                }
                else {
                    cc.log('start call native from ts');
                    var callbackName = args['@nativeCallbackName'];
                    CCMBinding_1.default.withOptions({ hasCallback: false }).callNativeMethod(callbackName, exeResult)
                        .then(function (rs) {
                        cc.log('receive:', rs);
                    }).catch(function (e) {
                        cc.log('exception:', e);
                    });
                }
            }
            return Promise.resolve(exeResult);
        }
        else {
            return Promise.reject({ code: -1, msg: methodName + " not register" });
        }
    };
    return CCMRouter;
}());
exports.default = CCMRouter;

cc._RF.pop();